/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.views.ResourceSorter;
import org.eclipse.birt.report.designer.internal.ui.views.WorkbenchContentProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WizardCustomTemplatePage
extends WizardPage {
    private static final String MESSAGE_SHOW_CHEATSHEET = Messages.getString((String)"WizardTemplateChoicePage.label.ShowCheatSheets");
    private static final String MESSAGE_BROWSE = Messages.getString((String)"WizardCustomTemplatePage.button.Browse");
    private static final String MESSAGE_LABEL = Messages.getString((String)"WizardCustomTemplatePage.label.FileName");
    private static final String MESSAGE_FROM_LOCAL = Messages.getString((String)"WizardCustomTemplatePage.label.FromLocal");
    private static final String MESSAGE_FROM_PROJECT_TITLE = Messages.getString((String)"WizardCustomTemplatePage.label.FromProjectTitle");
    private static final String MESSAGE_FROM_PROJECT_DESCRIPTION = Messages.getString((String)"WizardCustomTemplatePage.label.FromProjectDescription");
    private Text inputText;
    private Button browse;
    private Button chkBoxBrowseFrom;
    private Button chkBoxCheetSheet;

    public WizardCustomTemplatePage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Label lb = new Label(composite, 0);
        lb.setText(MESSAGE_LABEL);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        lb.setLayoutData((Object)data);
        Composite space = new Composite(composite, 0);
        data = new GridData();
        data.heightHint = 20;
        data.widthHint = 20;
        space.setLayoutData((Object)data);
        this.inputText = new Text(composite, 2052);
        data = new GridData(800);
        data.grabExcessHorizontalSpace = true;
        this.inputText.setLayoutData((Object)data);
        this.inputText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardCustomTemplatePage.this.setPageComplete(WizardCustomTemplatePage.this.validatePage());
                WizardCustomTemplatePage.this.updateChkBox();
            }
        });
        this.browse = new Button(composite, 8);
        this.browse.setText(MESSAGE_BROWSE);
        data = new GridData(128);
        this.browse.setLayoutData((Object)data);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardCustomTemplatePage.this.chkBoxBrowseFrom.getSelection()) {
                    FileDialog dialog = new FileDialog(WizardCustomTemplatePage.this.getShell());
                    dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
                    dialog.setFilterExtensions(new String[]{"*.rptdesign"});
                    if (dialog.open() != null) {
                        WizardCustomTemplatePage.this.inputText.setText(dialog.getFilterPath() + File.separator + dialog.getFileName());
                    }
                } else {
                    ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(WizardCustomTemplatePage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                    dialog.setAllowMultiple(false);
                    dialog.setTitle(MESSAGE_FROM_PROJECT_TITLE);
                    dialog.setMessage(MESSAGE_FROM_PROJECT_DESCRIPTION);
                    dialog.setValidator(new ISelectionStatusValidator(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public IStatus validate(Object[] selection) {
                            if (selection == null || selection.length < 1 || selection[0] instanceof IProject || selection[0] instanceof IFolder) {
                                return new Status(4, "org.eclipse.birt.report.designer.ui", 4, "", null);
                            }
                            return new Status(0, "org.eclipse.birt.report.designer.ui", 0, "", null);
                        }
                    });
                    dialog.addFilter(new ViewerFilter(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            if (element instanceof IProject || element instanceof IFolder) {
                                return ((IResource)element).isAccessible();
                            }
                            if (element instanceof IFile) {
                                return ((IResource)element).isAccessible() && "rptdesign".equals(((IResource)element).getFileExtension());
                            }
                            return false;
                        }
                    });
                    dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                    dialog.setSorter((ViewerSorter)new ResourceSorter(1));
                    if (dialog.open() == 0) {
                        IResource res = (IResource)dialog.getFirstResult();
                        WizardCustomTemplatePage.this.inputText.setText(res.getLocation().toOSString());
                    }
                }
            }
        });
        this.chkBoxBrowseFrom = new Button(composite, 32);
        this.chkBoxBrowseFrom.setText(MESSAGE_FROM_LOCAL);
        this.chkBoxBrowseFrom.setSelection(false);
        data = new GridData();
        data.horizontalSpan = 2;
        this.chkBoxBrowseFrom.setLayoutData((Object)data);
        this.chkBoxCheetSheet = new Button(composite, 32);
        this.chkBoxCheetSheet.setText(MESSAGE_SHOW_CHEATSHEET);
        this.chkBoxCheetSheet.setSelection(ReportPlugin.readCheatSheetPreference());
        this.chkBoxCheetSheet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPlugin.writeCheatSheetPreference(WizardCustomTemplatePage.this.chkBoxCheetSheet.getSelection());
            }
        });
        this.chkBoxCheetSheet.setVisible(false);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    protected void updateChkBox() {
        String xmlPath = this.getReportPath().replaceFirst(".rptdesign", ".xml");
        File f = new File(xmlPath);
        this.chkBoxCheetSheet.setEnabled(f.exists());
    }

    public String getReportPath() {
        return this.inputText.getText();
    }

    protected boolean validatePage() {
        if (this.inputText.getText().length() > 0) {
            File f = new File(this.getReportPath());
            return f.exists() && f.isFile();
        }
        return false;
    }

    public boolean getShowCheatSheet() {
        return this.chkBoxCheetSheet.getSelection();
    }
}

