/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WizardReportSettingPage
extends WizardPage {
    private static final String LABEL_DISPLAY_NAME = Messages.getString((String)"PublishTemplateAction.wizard.page.label.displayName");
    private static final String LABEL_DESCRIPTION = Messages.getString((String)"PublishTemplateAction.wizard.page.label.description");
    private static final String LABEL_IMAGE = Messages.getString((String)"PublishTemplateAction.wizard.page.label.image");
    private static final String BTN_CHOOSE = Messages.getString((String)"PublishTemplateAction.wizard.page.btn.browse");
    private static final String BROWSE_TITLE = Messages.getString((String)"PublishTemplateAction.wizard.page.browse.title");
    private static final String PAGE_DESC = Messages.getString((String)"PublishTemplateAction.wizard.page.desc");
    private static final String PLUGIN_ID = "org.eclipse.birt.report.designer.ui.actions.PublishTemplateWizard";
    private static final String STR_EMPTY = "";
    private ReportDesignHandle module;
    private Text previewImageText;
    private Text descText;
    private Text nameText;
    private Status nameStatus;

    public WizardReportSettingPage(ReportDesignHandle handle) {
        super(STR_EMPTY);
        this.module = handle;
        this.nameStatus = new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        new Label(container, 0).setText(LABEL_DISPLAY_NAME);
        this.nameText = this.createText(container, 2, 1);
        if (this.module != null && this.module.getProperty("displayName") != null) {
            this.nameText.setText(this.module.getDisplayName());
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardReportSettingPage.this.checkStatus();
            }
        });
        new Label(container, 0).setText(LABEL_DESCRIPTION);
        this.descText = this.createText(container, 2, 5);
        if (this.module != null && this.module.getProperty("description") != null) {
            this.descText.setText((String)this.module.getProperty("description"));
        }
        this.descText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardReportSettingPage.this.checkStatus();
            }
        });
        new Label(container, 0).setText(LABEL_IMAGE);
        this.previewImageText = this.createText(container, 1, 1);
        if (this.module != null && this.module.getIconFile() != null) {
            this.previewImageText.setText(this.module.getIconFile());
        }
        this.previewImageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardReportSettingPage.this.checkStatus();
                WizardReportSettingPage.this.validate();
            }
        });
        Button chooseBtn = new Button(container, 0);
        chooseBtn.setText(BTN_CHOOSE);
        chooseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                dialog.setText(BROWSE_TITLE);
                dialog.setFilterExtensions(new String[]{"*.gif;*.jpg;*.png;*.ico;*.bmp"});
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                WizardReportSettingPage.this.previewImageText.setText(fileName);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.nameText.forceFocus();
        this.setControl((Control)container);
        UIUtil.bindHelp(this.getControl(), "org.eclipse.birt.cshelp.PublishTemplateWizard_ID");
    }

    public String getDisplayName() {
        return this.nameText.getText() == null ? STR_EMPTY : this.nameText.getText().trim();
    }

    public String getDescription() {
        return this.descText.getText() == null ? STR_EMPTY : this.descText.getText().trim();
    }

    public String getPreviewImagePath() {
        return this.previewImageText.getText() == null ? STR_EMPTY : this.previewImageText.getText().trim();
    }

    private Text createText(Composite container, int column, int row) {
        Text text;
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = column;
        if (row > 1) {
            text = new Text(container, 2114);
            gridData.heightHint = row * 20;
        } else {
            text = new Text(container, 2052);
        }
        text.setLayoutData((Object)gridData);
        return text;
    }

    private void validate() {
        System.out.println(URIUtil.getDirectory((String)this.previewImageText.getText()) + this.previewImageText.getText());
        if (this.previewImageText.getText().trim().length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public void checkStatus() {
        Status status = new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
        if (WizardReportSettingPage.isTextEmpty(this.nameText)) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"PublishTemplateAction.wizard.page.nameInfo"), null);
        }
        this.nameStatus = status;
        this.applyToStatusLine(this.findMostSevere());
        this.getWizard().getContainer().updateButtons();
    }

    private static boolean isTextEmpty(Text text) {
        String s = text.getText();
        return s == null || s.trim().length() <= 0;
    }

    private IStatus findMostSevere() {
        return this.nameStatus;
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = PAGE_DESC;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 4: {
                this.setErrorMessage(message);
                this.setMessage(message, 3);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    public boolean canFinish() {
        return !WizardReportSettingPage.isTextEmpty(this.nameText);
    }
}

