/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.js.JSDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.js.JSEditorInput;
import org.eclipse.birt.report.designer.internal.ui.dialogs.js.JSSourceViewerConfiguration;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.Operator;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ExpressionBuilder
extends TitleAreaDialog {
    private static final String DIALOG_TITLE = Messages.getString((String)"ExpressionBuidler.Dialog.Title");
    private static final String PROMRT_MESSAGE = Messages.getString((String)"ExpressionBuilder.Message.Prompt");
    private static final String LABEL_FUNCTIONS = Messages.getString((String)"ExpressionBuilder.Label.Functions");
    private static final String LABEL_SUB_CATEGORY = Messages.getString((String)"ExpressionBuilder.Label.SubCategory");
    private static final String LABEL_CATEGORY = Messages.getString((String)"ExpressionBuilder.Label.Category");
    private static final String LABEL_OPERATORS = Messages.getString((String)"ExpressionBuilder.Label.Operators");
    private static final String TOOL_TIP_TEXT_REDO = Messages.getString((String)"TextEditDialog.toolTipText.redo");
    private static final String TOOL_TIP_TEXT_UNDO = Messages.getString((String)"TextEditDialog.toolTipText.undo");
    private static final String TOOL_TIP_TEXT_DELETE = Messages.getString((String)"TextEditDialog.toolTipText.delete");
    private static final String TOOL_TIP_TEXT_PASTE = Messages.getString((String)"TextEditDialog.toolTipText.paste");
    private static final String TOOL_TIP_TEXT_CUT = Messages.getString((String)"TextEditDialog.toolTipText.cut");
    private static final String TOOL_TIP_TEXT_COPY = Messages.getString((String)"TextEditDialog.toolTipText.copy");
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            TableViewer target = null;
            if (event.getSource() == ExpressionBuilder.this.categoryTable) {
                target = ExpressionBuilder.this.subCategoryTable;
            } else if (event.getSource() == ExpressionBuilder.this.subCategoryTable) {
                target = ExpressionBuilder.this.functionTable;
            }
            if (target != null) {
                target.setInput(selection.getFirstElement());
            }
            if (event.getSource() == ExpressionBuilder.this.functionTable) {
                Table table = ExpressionBuilder.this.functionTable.getTable();
                if (table.getSelectionCount() == 1) {
                    ExpressionBuilder.this.messageLine.setText(table.getSelection()[0].getText());
                } else {
                    ExpressionBuilder.this.messageLine.setText("");
                }
            }
        }
    };
    private ITableLabelProvider tableLabelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return ExpressionBuilder.this.provider.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            return ExpressionBuilder.this.provider.getDisplayText(element);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            if (event.getSource() == ExpressionBuilder.this.functionTable) {
                Object[] inputArray;
                if (selection.getFirstElement() instanceof Object[] && (inputArray = (Object[])selection.getFirstElement()).length == 2 && inputArray[1] instanceof ReportItemHandle) {
                    ColumnBindingDialog dialog = new ColumnBindingDialog();
                    dialog.setInput((ReportItemHandle)inputArray[1]);
                    if (dialog.open() == 0) {
                        ExpressionBuilder.this.functionTable.refresh();
                    }
                    return;
                }
                String insertText = ExpressionBuilder.this.provider.getInsertText(selection.getFirstElement());
                if (insertText != null) {
                    ExpressionBuilder.this.insertText(insertText);
                }
                return;
            }
        }
    };
    private Composite buttonBar;
    private TableViewer categoryTable;
    private TableViewer subCategoryTable;
    private TableViewer functionTable;
    private IExpressionProvider provider;
    private SourceViewer sourceViewer;
    private String expression = null;
    private Label messageLine;
    private String title = DIALOG_TITLE;

    public ExpressionBuilder(Shell parentShell, String initExpression) {
        super(parentShell);
        this.expression = UIUtil.convertToGUIString(initExpression);
    }

    public ExpressionBuilder(String initExpression) {
        this(UIUtil.getDefaultShell(), initExpression);
    }

    public ExpressionBuilder() {
        this(null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createToolbar(composite);
        this.createExpressionField(composite);
        if (this.provider == null) {
            this.provider = new ExpressionProvider();
        }
        this.createOperatorsBar(composite);
        this.createMessageLine(composite);
        this.createListArea(composite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ExpressionBuilder_ID");
        return composite;
    }

    private void createMessageLine(Composite parent) {
        this.messageLine = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 6;
        this.messageLine.setLayoutData((Object)gridData);
    }

    private void createToolbar(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        toolBar.setLayoutData((Object)new GridData());
        ToolItem copy = new ToolItem(toolBar, 0);
        copy.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_COPY"));
        copy.setToolTipText(TOOL_TIP_TEXT_COPY);
        copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.sourceViewer.doOperation(4);
            }
        });
        ToolItem cut = new ToolItem(toolBar, 0);
        cut.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_CUT"));
        cut.setToolTipText(TOOL_TIP_TEXT_CUT);
        cut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.sourceViewer.doOperation(3);
            }
        });
        ToolItem paste = new ToolItem(toolBar, 0);
        paste.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_PASTE"));
        paste.setToolTipText(TOOL_TIP_TEXT_PASTE);
        paste.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.sourceViewer.doOperation(5);
            }
        });
        ToolItem delete = new ToolItem(toolBar, 0);
        delete.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_DELETE"));
        delete.setToolTipText(TOOL_TIP_TEXT_DELETE);
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.sourceViewer.doOperation(6);
            }
        });
        ToolItem undo = new ToolItem(toolBar, 0);
        undo.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_UNDO"));
        undo.setToolTipText(TOOL_TIP_TEXT_UNDO);
        undo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.sourceViewer.doOperation(1);
            }
        });
        ToolItem redo = new ToolItem(toolBar, 0);
        redo.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_REDO"));
        redo.setToolTipText(TOOL_TIP_TEXT_REDO);
        redo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.sourceViewer.doOperation(2);
            }
        });
    }

    private void createExpressionField(Composite parent) {
        Composite expressionArea = new Composite(parent, 0);
        expressionArea.setLayout((Layout)new GridLayout(2, false));
        expressionArea.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(expressionArea, 0x2000800);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
        this.sourceViewer = new SourceViewer(composite, (IVerticalRuler)ruler, 768);
        this.sourceViewer.configure((SourceViewerConfiguration)new JSSourceViewerConfiguration());
        if (this.expression != null) {
            JSEditorInput editorInput = new JSEditorInput(this.expression);
            JSDocumentProvider documentProvider = new JSDocumentProvider();
            try {
                documentProvider.connect(editorInput);
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e);
            }
            IDocument document = documentProvider.getDocument(editorInput);
            this.sourceViewer.setDocument(document);
        }
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.sourceViewer.getControl().setLayoutData((Object)gd);
        if (Platform.getOS().equals("win32")) {
            Font font = this.sourceViewer.getTextWidget().getFont();
            FontData data = font.getFontData()[0];
            Font newFont = FontManager.getFont((String)data.getName(), (int)(data.getHeight() + 1), (int)data.getStyle());
            this.sourceViewer.getTextWidget().setFont(newFont);
        }
        this.sourceViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (this.isUndoKeyPress(e)) {
                    ExpressionBuilder.this.sourceViewer.doOperation(1);
                } else if (this.isRedoKeyPress(e)) {
                    ExpressionBuilder.this.sourceViewer.doOperation(2);
                }
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }
        });
        this.sourceViewer.getTextWidget().addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                event.segments = UIUtil.getExpressionBidiSegments(event.lineText);
            }
        });
        this.buttonBar = new Composite(expressionArea, 0);
        this.buttonBar.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        this.buttonBar.setLayoutData((Object)new GridData(1040));
    }

    private void createOperatorsBar(Composite parent) {
        Operator[] operators = this.provider.getOperators();
        if (operators == null || operators.length == 0) {
            return;
        }
        Composite operatorsBar = new Composite(parent, 0);
        operatorsBar.setLayout((Layout)new GridLayout(2, false));
        operatorsBar.setLayoutData((Object)new GridData(768));
        Label lable = new Label(operatorsBar, 0);
        lable.setText(LABEL_OPERATORS);
        lable.setLayoutData((Object)new GridData(70, -1));
        Composite operatorsArea = new Composite(operatorsBar, 0);
        operatorsArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(operators.length, true));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                ExpressionBuilder.this.insertText((String)button.getData());
            }
        };
        for (int i = 0; i < operators.length; ++i) {
            Button button = new Button(operatorsArea, 8);
            button.setLayoutData((Object)new GridData(768));
            if (operators[i] != IExpressionProvider.OPERATOR_SEPARATOR) {
                button.setData((Object)operators[i].insertString);
                String text = operators[i].symbol;
                if (text.indexOf("&") != -1) {
                    text = text.replaceAll("&", "&&");
                }
                button.setText(text);
                button.addSelectionListener((SelectionListener)selectionAdapter);
                continue;
            }
            button.setVisible(false);
        }
    }

    private void createListArea(Composite parent) {
        Composite listArea = new Composite(parent, 0);
        listArea.setLayout((Layout)new GridLayout(3, true));
        listArea.setLayoutData((Object)new GridData(1808));
        new Label(listArea, 0).setText(LABEL_CATEGORY);
        new Label(listArea, 0).setText(LABEL_SUB_CATEGORY);
        new Label(listArea, 0).setText(LABEL_FUNCTIONS);
        int style = 67588;
        this.categoryTable = new TableViewer(listArea, style);
        this.subCategoryTable = new TableViewer(listArea, style);
        this.functionTable = new TableViewer(listArea, style);
        this.initTable(this.categoryTable);
        this.initTable(this.subCategoryTable);
        this.initTable(this.functionTable);
    }

    private void initTable(TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        table.setToolTipText(null);
        new TableColumn(table, 0).setWidth(200);
        table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == table) {
                    Point pt = new Point(event.x, event.y);
                    TableItem item = table.getItem(pt);
                    if (item == null) {
                        table.setToolTipText(null);
                    } else {
                        table.setToolTipText(ExpressionBuilder.this.provider.getTooltipText(item.getData()));
                    }
                }
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLabelProvider);
        tableViewer.setContentProvider((IContentProvider)new TableContentProvider(tableViewer));
        tableViewer.addSelectionChangedListener(this.selectionListener);
        tableViewer.addDoubleClickListener(this.doubleClickListener);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(this.buttonBar);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 1;
        composite.setLayoutData((Object)new GridData(1040));
        return composite;
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData;
        if (button.getText().equals(IDialogConstants.HELP_LABEL)) {
            gridData = new GridData(72);
            gridData.grabExcessVerticalSpace = true;
        } else {
            gridData = new GridData(2);
        }
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(DIALOG_TITLE);
        this.setMessage(PROMRT_MESSAGE);
        this.getShell().setText(this.title);
        this.categoryTable.setInput((Object)"Dummy");
        this.getShell().setDefaultButton(null);
        this.sourceViewer.getTextWidget().setFocus();
        return control;
    }

    protected void okPressed() {
        this.expression = this.sourceViewer.getTextWidget().getText().trim();
        super.okPressed();
    }

    public String getResult() {
        return this.expression;
    }

    public void setExpressionProvier(IExpressionProvider provider) {
        this.provider = provider;
    }

    public void setDialogTitle(String newTitle) {
        this.title = newTitle;
    }

    public String getDialogTitle() {
        return this.title;
    }

    protected void insertText(String text) {
        StyledText textWidget = this.sourceViewer.getTextWidget();
        if (!textWidget.isEnabled()) {
            return;
        }
        int selectionStart = textWidget.getSelection().x;
        textWidget.insert(text);
        textWidget.setSelection(selectionStart + text.length());
        textWidget.setFocus();
        if (text.endsWith("()")) {
            textWidget.setCaretOffset(textWidget.getCaretOffset() - 1);
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableViewer viewer;

        public TableContentProvider(TableViewer viewer) {
            this.viewer = viewer;
        }

        public Object[] getElements(Object inputElement) {
            if (this.viewer == ExpressionBuilder.this.categoryTable) {
                return ExpressionBuilder.this.provider.getCategory();
            }
            return ExpressionBuilder.this.provider.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (viewer == ExpressionBuilder.this.subCategoryTable) {
                ExpressionBuilder.this.functionTable.setInput(null);
            }
        }
    }
}

