/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.FormPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SortingHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.Spinner;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class GroupDialog
extends BaseDialog {
    private static final String GROUP_DLG_GROUP_FILTER_SORTING = Messages.getString((String)"GroupDialog.Label.FilterSorting");
    private static final String GROUP_DLG_GROUP_RANGE_LABEL = Messages.getString((String)"GroupDialog.Label.Range");
    private static final String GROUP_DLG_GROUP_INTERVAL_LABEL = Messages.getString((String)"GroupDialog.Label.Interval");
    private static final String GROUP_DLG_GROUP_KEY_LABEL = Messages.getString((String)"GroupDialog.Label.GroupOn");
    private static final String GROUP_DLG_GROUP_NAME_LABEL = Messages.getString((String)"GroupDialog.Label.Name");
    private static final String TAB_SORTING = Messages.getString((String)"GroupDialog.Tab.Sorting");
    private static final String TAB_FILTER = Messages.getString((String)"GroupDialog.Tab.Filter");
    private static final String GROUP_DLG_HEADER_FOOTER_LABEL = Messages.getString((String)"GroupDialog.Label.HeaderFooter");
    private static final String GROUP_DLG_INTERVAL_BASE_LABEL = Messages.getString((String)"GroupDialog.Label.IntervalBase");
    private static final String GROUP_DLG_AREA_MSG = Messages.getString((String)"GroupDialog.Dialog.GroupDetail");
    public static final String GROUP_DLG_TITLE_NEW = Messages.getString((String)"GroupDialog.Title.New");
    public static final String GROUP_DLG_TITLE_EDIT = Messages.getString((String)"GroupDialog.Title.Edit");
    public static final String GROUP_DLG_HIDE_DETAIL = Messages.getString((String)"GroupDialog.buttion.HideDetail");
    private List columnList;
    private GroupHandle inputGroup;
    private Text nameEditor;
    private Combo keyChooser;
    private Combo intervalType;
    private Spinner intervalRange;
    private Button ascending;
    private Button descending;
    private Button intervalBaseButton;
    private Text intervalBaseText;
    private Button hideDetail;
    private Text tocEditor;
    private static final IChoice[] intervalChoicesAll = DesignEngine.getMetaDataDictionary().getChoiceSet("interval").getChoices();
    private static final IChoice sortByAscending = DesignEngine.getMetaDataDictionary().getChoiceSet("sortDirection").findChoice("asc");
    private static final IChoice sortByDescending = DesignEngine.getMetaDataDictionary().getChoiceSet("sortDirection").findChoice("desc");
    private static final String SORT_GROUP_TITLE = DEUtil.getPropertyDefn((String)"TableGroup", (String)"sortDirection").getDisplayName();
    private static final IChoice[] pagebreakBeforeChoicesAll = DesignEngine.getMetaDataDictionary().getChoiceSet("pageBreakBefore").getChoices();
    private static final IChoice[] pagebreakAfterChoicesAll = DesignEngine.getMetaDataDictionary().getChoiceSet("pageBreakAfter").getChoices();
    private static final IChoice[] intervalChoicesString = GroupDialog.getIntervalChoicesString();
    private static final IChoice[] intervalChoicesDate = GroupDialog.getIntervalChoicesDate();
    private static final IChoice[] intervalChoicesNumeric = GroupDialog.getIntervalChoicesNumeric();
    private static IChoice[] intervalChoices = intervalChoicesAll;
    private String previoiusKeyExpression = "";
    private Button repeatHeaderButton;
    private Combo pagebreakAfterCombo;
    private Combo pagebreakBeforeCombo;

    public GroupDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite topComposite = (Composite)super.createDialogArea(parent);
        this.createTitleArea(topComposite);
        Composite composite = new Composite(topComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, true));
        this.createFieldArea(composite);
        this.createGroupArea(composite);
        this.createTOCArea(composite);
        this.createFilterSortingArea(topComposite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.GroupDialog_ID");
        return topComposite;
    }

    private void createTOCArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        composite.setLayoutData((Object)gd);
        new Label(composite, 0).setText(Messages.getString((String)"GroupDialog.Dialog.TOC"));
        Composite tocArea = new Composite(composite, 0);
        tocArea.setLayoutData((Object)new GridData(768));
        tocArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        this.tocEditor = new Text(tocArea, 2052);
        this.tocEditor.setLayoutData((Object)new GridData(768));
        Button exprButton = new Button(tocArea, 8);
        exprButton.setText("...");
        exprButton.setToolTipText(Messages.getString((String)"GroupDialog.toolTipText.openExprButton"));
        exprButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(GroupDialog.this.tocEditor.getText());
                expressionBuilder.setExpressionProvier(new ExpressionProvider((DesignElementHandle)GroupDialog.this.inputGroup));
                if (expressionBuilder.open() == 0) {
                    GroupDialog.this.tocEditor.setText(expressionBuilder.getResult());
                }
            }
        });
    }

    private void createTitleArea(Composite parent) {
        int margins = 2;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = margins;
        layout.marginWidth = margins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + margins * 3;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(GROUP_DLG_AREA_MSG);
    }

    private void createFieldArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        composite.setLayoutData((Object)gd);
        new Label(composite, 0).setText(GROUP_DLG_GROUP_NAME_LABEL);
        this.nameEditor = new Text(composite, 2052);
        this.nameEditor.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(GROUP_DLG_GROUP_KEY_LABEL);
        Composite keyArea = new Composite(composite, 0);
        keyArea.setLayoutData((Object)new GridData(768));
        keyArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        this.keyChooser = new Combo(keyArea, 4);
        this.keyChooser.setLayoutData((Object)new GridData(768));
        this.keyChooser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!GroupDialog.this.keyChooser.getText().trim().equals("")) {
                    GroupDialog.this.resetInterval();
                }
            }
        });
        Button exprButton = new Button(keyArea, 8);
        exprButton.setText("...");
        exprButton.setToolTipText(Messages.getString((String)"GroupDialog.toolTipText.openExprButton"));
        exprButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExpressionBuilder expressionBuilder = new ExpressionBuilder(GroupDialog.this.getKeyExpression());
                expressionBuilder.setExpressionProvier(new ExpressionProvider((DesignElementHandle)GroupDialog.this.inputGroup));
                if (expressionBuilder.open() == 0) {
                    GroupDialog.this.setKeyExpression(expressionBuilder.getResult().trim());
                }
            }
        });
        Composite intervalArea = new Composite(composite, 0);
        intervalArea.setLayoutData((Object)new GridData(768));
        intervalArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        Composite intervalTypeArea = new Composite(intervalArea, 0);
        intervalTypeArea.setLayoutData((Object)new GridData(768));
        intervalTypeArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(1, false));
        Composite intervalRangeArea = new Composite(intervalArea, 0);
        intervalRangeArea.setLayoutData((Object)new GridData(256));
        intervalRangeArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(1, false));
        new Label(intervalTypeArea, 0).setText(GROUP_DLG_GROUP_INTERVAL_LABEL);
        new Label(intervalRangeArea, 0).setText(GROUP_DLG_GROUP_RANGE_LABEL);
        this.intervalType = new Combo(intervalTypeArea, 12);
        this.intervalType.setLayoutData((Object)new GridData(768));
        for (int i = 0; i < intervalChoices.length; ++i) {
            this.intervalType.add(intervalChoices[i].getDisplayName());
        }
        this.intervalType.setData((Object)intervalChoices);
        this.intervalType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupDialog.this.intervalRange.setEnabled(GroupDialog.this.intervalType.getSelectionIndex() != 0);
                GroupDialog.this.intervalBaseButton.setEnabled(GroupDialog.this.intervalType.getSelectionIndex() != 0 && GroupDialog.this.getColumnType() != (class$java$lang$String == null ? (class$java$lang$String = GroupDialog.class$("java.lang.String")) : class$java$lang$String));
                GroupDialog.this.intervalBaseText.setEnabled(GroupDialog.this.intervalBaseButton.getEnabled() && GroupDialog.this.intervalBaseButton.getSelection());
            }
        });
        this.intervalRange = new Spinner(intervalRangeArea, 0);
        this.intervalRange.setLayoutData(new GridData(256));
        this.intervalRange.setMinimum(0.0);
        this.intervalRange.setMaximum(2.147483647E9);
        this.intervalRange.setStep(1.0);
        this.intervalBaseButton = new Button(composite, 32);
        this.intervalBaseButton.setText(GROUP_DLG_INTERVAL_BASE_LABEL);
        this.intervalBaseButton.setLayoutData((Object)new GridData(768));
        this.intervalBaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupDialog.this.intervalBaseText.setEnabled(GroupDialog.this.intervalBaseButton.getSelection());
            }
        });
        this.intervalBaseText = new Text(composite, 2052);
        this.intervalBaseText.setLayoutData((Object)new GridData(768));
        this.hideDetail = new Button(composite, 32);
        this.hideDetail.setLayoutData((Object)new GridData(768));
        this.hideDetail.setText(GROUP_DLG_HIDE_DETAIL);
    }

    private void createGroupArea(Composite parent) {
        int i;
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(770);
        layoutData.verticalSpan = 2;
        composite.setLayoutData((Object)layoutData);
        composite.setLayout((Layout)new GridLayout());
        Group sortingGroup = new Group(composite, 0);
        sortingGroup.setText(SORT_GROUP_TITLE);
        sortingGroup.setLayoutData((Object)new GridData(768));
        sortingGroup.setLayout((Layout)new FillLayout(512));
        Composite sortingGroupComposite = new Composite((Composite)sortingGroup, 0);
        sortingGroupComposite.setLayout((Layout)new GridLayout());
        this.ascending = new Button(sortingGroupComposite, 16);
        this.ascending.setText(sortByAscending.getDisplayName());
        this.descending = new Button(sortingGroupComposite, 16);
        this.descending.setText(sortByDescending.getDisplayName());
        Group pagebreakGroup = new Group(composite, 0);
        pagebreakGroup.setText(Messages.getString((String)"GroupDialog.PageBreak"));
        pagebreakGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        pagebreakGroup.setLayout((Layout)layout);
        new Label((Composite)pagebreakGroup, 0).setText(Messages.getString((String)"GroupDialog.PageBreakBefore"));
        this.pagebreakBeforeCombo = new Combo((Composite)pagebreakGroup, 0);
        for (i = 0; i < pagebreakBeforeChoicesAll.length; ++i) {
            this.pagebreakBeforeCombo.add(pagebreakBeforeChoicesAll[i].getDisplayName());
        }
        this.pagebreakBeforeCombo.setData((Object)pagebreakBeforeChoicesAll);
        new Label((Composite)pagebreakGroup, 0).setText(Messages.getString((String)"GroupDialog.PageBreakAfter"));
        this.pagebreakAfterCombo = new Combo((Composite)pagebreakGroup, 0);
        for (i = 0; i < pagebreakAfterChoicesAll.length; ++i) {
            this.pagebreakAfterCombo.add(pagebreakAfterChoicesAll[i].getDisplayName());
        }
        this.pagebreakAfterCombo.setData((Object)pagebreakAfterChoicesAll);
        this.repeatHeaderButton = new Button((Composite)pagebreakGroup, 32);
        this.repeatHeaderButton.setText(Messages.getString((String)"GroupDialog.RepeatHeader"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.repeatHeaderButton.setLayoutData((Object)data);
    }

    private void createFilterSortingArea(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(GROUP_DLG_GROUP_FILTER_SORTING);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(550, 250));
        ArrayList<GroupHandle> list = new ArrayList<GroupHandle>(1);
        list.add(this.inputGroup);
        TabFolder tab = new TabFolder((Composite)group, 128);
        tab.setLayoutData((Object)new GridData(1808));
        TabItem filterItem = new TabItem(tab, 0);
        FormPage filterPage = new FormPage((Composite)tab, 2, new FilterHandleProvider(){

            public int[] getColumnWidths() {
                return new int[]{200, 100, 100, 100};
            }
        });
        filterPage.setInput(list);
        filterItem.setText(TAB_FILTER);
        filterItem.setControl((Control)filterPage);
        TabItem sortItem = new TabItem(tab, 0);
        FormPage sortPage = new FormPage((Composite)tab, 2, new SortingHandleProvider(){

            public int[] getColumnWidths() {
                return new int[]{200, 100};
            }
        });
        sortPage.setInput(list);
        sortItem.setText(TAB_SORTING);
        sortItem.setControl((Control)sortPage);
    }

    protected boolean initDialog() {
        if (this.inputGroup.getName() != null) {
            this.nameEditor.setText(this.inputGroup.getName());
        }
        this.refreshColumnList();
        this.setKeyExpression(this.inputGroup.getKeyExpr());
        int index = this.getIntervalTypeIndex(this.inputGroup.getInterval());
        this.intervalType.select(index);
        if (index == 0) {
            this.intervalRange.setEnabled(false);
            this.intervalBaseButton.setEnabled(false);
            this.intervalBaseText.setEnabled(false);
        } else {
            this.intervalRange.setEnabled(true);
            this.intervalRange.setSelection(this.inputGroup.getIntervalRange());
            if (this.getColumnType() == String.class) {
                this.intervalBaseButton.setEnabled(false);
                this.intervalBaseText.setEnabled(false);
            } else {
                this.intervalBaseButton.setEnabled(true);
                this.intervalBaseButton.setSelection(this.inputGroup.getIntervalBase() != null);
                this.intervalBaseText.setEnabled(this.intervalBaseButton.getSelection());
                if (this.inputGroup.getIntervalBase() != null) {
                    this.intervalBaseText.setText(this.inputGroup.getIntervalBase());
                }
            }
        }
        if ("asc".equals(this.inputGroup.getSortDirection())) {
            this.ascending.setSelection(true);
        } else {
            this.descending.setSelection(true);
        }
        ArrayList<GroupHandle> list = new ArrayList<GroupHandle>(1);
        list.add(this.inputGroup);
        this.tocEditor.setText(UIUtil.convertToGUIString(this.inputGroup.getTocExpression()));
        index = this.getPagebreakBeforeIndex(this.inputGroup.getPageBreakBefore());
        this.pagebreakBeforeCombo.select(index);
        index = this.getPagebreakAfterIndex(this.inputGroup.getPageBreakAfter());
        this.pagebreakAfterCombo.select(index);
        if (this.inputGroup.repeatHeader()) {
            this.repeatHeaderButton.setSelection(true);
        }
        this.hideDetail.setSelection(this.inputGroup.hideDetail());
        return true;
    }

    private void refreshColumnList() {
        String selected = this.keyChooser.getText();
        this.keyChooser.removeAll();
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)this.inputGroup);
        Iterator itor = this.columnList.iterator();
        while (itor.hasNext()) {
            this.keyChooser.add(((ComputedColumnHandle)itor.next()).getName());
        }
        int newIndex = this.keyChooser.indexOf(selected);
        if (newIndex != -1) {
            this.keyChooser.select(newIndex);
        } else {
            this.keyChooser.setText(selected);
        }
    }

    private int getPagebreakAfterIndex(String pageBreakAfter) {
        int index = 0;
        for (int i = 0; i < pagebreakAfterChoicesAll.length; ++i) {
            if (!pagebreakAfterChoicesAll[i].getName().equals(pageBreakAfter)) continue;
            index = i;
            break;
        }
        return index;
    }

    private int getPagebreakBeforeIndex(String pageBreakBefore) {
        int index = 0;
        for (int i = 0; i < pagebreakBeforeChoicesAll.length; ++i) {
            if (!pagebreakBeforeChoicesAll[i].getName().equals(pageBreakBefore)) continue;
            index = i;
            break;
        }
        return index;
    }

    public void setInput(Object input) {
        Assert.isTrue((boolean)(input instanceof GroupHandle));
        this.inputGroup = (GroupHandle)input;
    }

    protected void okPressed() {
        try {
            this.inputGroup.setName(this.nameEditor.getText());
            String newToc = UIUtil.convertToModelString(this.tocEditor.getText(), true);
            if (!(newToc == this.inputGroup.getTocExpression() || newToc != null && newToc.equals(this.inputGroup.getTocExpression()))) {
                this.inputGroup.setTocExpression(newToc);
            }
            int index = this.keyChooser.getSelectionIndex();
            String oldKeyExpr = this.inputGroup.getKeyExpr();
            String newKeyExpr = this.getKeyExpression();
            this.inputGroup.setKeyExpr(newKeyExpr);
            if (newKeyExpr != null && newKeyExpr.length() != 0 && !newKeyExpr.equals(oldKeyExpr) && index != -1) {
                SlotHandle slotHandle = null;
                if (this.inputGroup instanceof ListGroupHandle) {
                    slotHandle = this.inputGroup.getHeader();
                } else if (this.inputGroup instanceof TableGroupHandle && this.inputGroup.getHeader().getCount() != 0) {
                    RowHandle rowHandle = (RowHandle)this.inputGroup.getHeader().get(0);
                    CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(0);
                    slotHandle = cellHandle.getContent();
                }
                if (slotHandle != null) {
                    DataItemHandle dataItemHandle = this.inputGroup.getElementFactory().newDataItem(null);
                    dataItemHandle.setResultSetColumn(((ComputedColumnHandle)this.columnList.get(index)).getName());
                    slotHandle.add((DesignElementHandle)dataItemHandle);
                }
            }
            index = this.intervalType.getSelectionIndex();
            this.inputGroup.setInterval(intervalChoices[index].getName());
            if (index != 0) {
                this.inputGroup.setIntervalRange(this.intervalRange.getSelection());
            } else {
                this.inputGroup.setProperty("intervalRange", null);
            }
            if (this.intervalBaseText.getEnabled()) {
                this.inputGroup.setIntervalBase(UIUtil.convertToModelString(this.intervalBaseText.getText(), false));
            } else {
                this.inputGroup.setIntervalBase(null);
            }
            this.inputGroup.setHideDetail(this.hideDetail.getSelection());
            if (this.ascending.getSelection()) {
                this.inputGroup.setSortDirection("asc");
            } else {
                this.inputGroup.setSortDirection("desc");
            }
            this.inputGroup.setPageBreakBefore(pagebreakBeforeChoicesAll[this.pagebreakBeforeCombo.getSelectionIndex()].getName());
            this.inputGroup.setPageBreakAfter(pagebreakAfterChoicesAll[this.pagebreakAfterCombo.getSelectionIndex()].getName());
            this.inputGroup.setRepeatHeader(this.repeatHeaderButton.getSelection());
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return;
        }
        this.setResult(this.inputGroup);
        super.okPressed();
    }

    private int getIntervalTypeIndex(String interval) {
        int index = 0;
        for (int i = 0; i < intervalChoices.length; ++i) {
            if (!intervalChoices[i].getName().equals(interval)) continue;
            index = i;
            break;
        }
        return index;
    }

    private void setKeyExpression(String key) {
        this.keyChooser.deselectAll();
        key = StringUtil.trimString((String)key);
        if (StringUtil.isBlank((String)key)) {
            this.keyChooser.setText("");
            return;
        }
        for (int i = 0; i < this.columnList.size(); ++i) {
            if (!key.equals(DEUtil.getExpression(this.columnList.get(i)))) continue;
            this.keyChooser.select(i);
            return;
        }
        this.keyChooser.setText(key);
    }

    private void resetInterval() {
        String currentKeyExpression = this.keyChooser.getText();
        if (this.previoiusKeyExpression.equals(currentKeyExpression)) {
            return;
        }
        intervalChoices = ExpressionUtility.isColumnExpression(currentKeyExpression) ? this.getSubIntervalChoice() : intervalChoicesAll;
        this.resetIntervalType(intervalChoices);
        this.previoiusKeyExpression = currentKeyExpression;
    }

    private IChoice[] getSubIntervalChoice() {
        Class columnType = this.getColumnType();
        if (columnType == null) {
            return intervalChoicesAll;
        }
        if (String.class.isAssignableFrom(columnType)) {
            return intervalChoicesString;
        }
        if (Date.class.isAssignableFrom(columnType)) {
            return intervalChoicesDate;
        }
        if (Number.class.isAssignableFrom(columnType)) {
            return intervalChoicesNumeric;
        }
        return intervalChoicesAll;
    }

    private static IChoice[] getIntervalChoicesString() {
        String[] str = new String[]{"none", "prefix"};
        return GroupDialog.getIntervalChoiceArray(str);
    }

    private static IChoice[] getIntervalChoicesDate() {
        String[] str = new String[]{"none", "year", "quarter", "month", "week", "day", "hour", "minute", "second"};
        return GroupDialog.getIntervalChoiceArray(str);
    }

    private static IChoice[] getIntervalChoicesNumeric() {
        String[] str = new String[]{"none", "interval"};
        return GroupDialog.getIntervalChoiceArray(str);
    }

    private static IChoice[] getIntervalChoiceArray(String[] str) {
        ArrayList<IChoice> choiceList = new ArrayList<IChoice>();
        block0: for (int i = 0; i < intervalChoicesAll.length; ++i) {
            for (int j = 0; j < str.length; ++j) {
                if (!intervalChoicesAll[i].getName().equals(str[j])) continue;
                choiceList.add(intervalChoicesAll[i]);
                continue block0;
            }
        }
        IChoice[] choice = new IChoice[choiceList.size()];
        return choiceList.toArray(choice);
    }

    private Class getColumnType() {
        for (int i = 0; i < this.columnList.size(); ++i) {
            Object dataSetItemModel = this.columnList.get(i);
            if (!(dataSetItemModel instanceof DataSetItemModel) || !((DataSetItemModel)dataSetItemModel).getDataSetColumnName().equals(this.keyChooser.getText())) continue;
            return DataType.getClass((int)((DataSetItemModel)dataSetItemModel).getDataType());
        }
        return null;
    }

    private void resetIntervalType(IChoice[] choice) {
        this.intervalType.removeAll();
        for (int i = 0; i < choice.length; ++i) {
            this.intervalType.add(choice[i].getDisplayName());
        }
        this.intervalType.setData((Object)choice);
        this.intervalType.select(0);
        this.intervalType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupDialog.this.intervalRange.setEnabled(GroupDialog.this.intervalType.getSelectionIndex() != 0);
                GroupDialog.this.intervalBaseButton.setEnabled(GroupDialog.this.intervalType.getSelectionIndex() != 0 && GroupDialog.this.getColumnType() != (class$java$lang$String == null ? (class$java$lang$String = GroupDialog.class$("java.lang.String")) : class$java$lang$String));
                GroupDialog.this.intervalBaseText.setEnabled(GroupDialog.this.intervalBaseButton.getEnabled() && GroupDialog.this.intervalBaseButton.getSelection());
            }
        });
        this.enableIntervalRangeAndBase(false);
    }

    private void enableIntervalRangeAndBase(boolean bool) {
        this.intervalRange.setEnabled(bool);
        this.intervalBaseButton.setEnabled(bool);
        this.intervalBaseText.setEnabled(bool);
    }

    private String getKeyExpression() {
        String exp = null;
        exp = this.keyChooser.getSelectionIndex() != -1 ? DEUtil.getExpression(this.columnList.get(this.keyChooser.getSelectionIndex())) : this.keyChooser.getText().trim();
        return exp;
    }
}

