/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ImportValueDialog;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.NewDataSetAction;
import org.eclipse.birt.report.designer.ui.dialogs.FormatBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ParameterDialog
extends BaseDialog {
    private static final String CHOICE_NO_DEFAULT = Messages.getString((String)"ParameterDialog.Choice.NoDefault");
    private static final String GROUP_PROPERTIES = Messages.getString((String)"ParameterDialog.Group.Properties");
    private static final String GROUP_MORE_OPTION = Messages.getString((String)"ParameterDialog.Group.MoreOption");
    private static final String LABEL_NAME = Messages.getString((String)"ParameterDialog.Label.Name");
    private static final String LABEL_DATETIME_PROMPT = Messages.getString((String)"ParameterDialog.Label.DateTImePrompt");
    private static final String LABEL_PROMPT_TEXT = Messages.getString((String)"ParameterDialog.Label.PromptText");
    private static final String LABEL_PARAM_DATA_TYPE = Messages.getString((String)"ParameterDialog.Label.DataType");
    private static final String LABEL_DISPALY_TYPE = Messages.getString((String)"ParameterDialog.Label.DisplayType");
    private static final String LABEL_DEFAULT_VALUE = Messages.getString((String)"ParameterDialog.Label.DefaultValue");
    private static final String LABEL_HELP_TEXT = Messages.getString((String)"ParameterDialog.Label.HelpText");
    private static final String LABEL_LIST_OF_VALUE = Messages.getString((String)"ParameterDialog.Label.ListOfValue");
    private static final String LABEL_VALUES = Messages.getString((String)"ParameterDialog.Label.Value");
    private static final String LABEL_FORMAT = Messages.getString((String)"ParameterDialog.Label.Format");
    private static final String LABEL_LIST_LIMIT = Messages.getString((String)"ParameterDialog.Label.Listlimit");
    private static final String LABEL_NULL = Messages.getString((String)"ParameterDialog.Label.Null");
    private static final String LABEL_SELECT_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Label.SelectDisplayText");
    private static final String LABEL_SELECT_VALUE_COLUMN = Messages.getString((String)"ParameterDialog.Label.SelectValueColumn");
    private static final String LABEL_SELECT_DATA_SET = Messages.getString((String)"ParameterDialog.Label.SelectDataSet");
    private static final String LABEL_PREVIEW = Messages.getString((String)"ParameterDialog.Label.Preview");
    private static final String CHECKBOX_ALLOW_NULL = Messages.getString((String)"ParameterDialog.CheckBox.AllowNull");
    private static final String CHECKBOX_ALLOW_BLANK = Messages.getString((String)"ParameterDialog.CheckBox.AllowBlank");
    private static final String CHECKBOX_DO_NOT_ECHO = Messages.getString((String)"ParameterDialog.CheckBox.DoNotEchoInput");
    private static final String CHECKBOX_SORT = Messages.getString((String)"ParameterDialog.CheckBox.Sort");
    private static final String CHECKBOX_HIDDEN = Messages.getString((String)"ParameterDialog.CheckBox.Hidden");
    private static final String BUTTON_LABEL_CHANGE_FORMAT = Messages.getString((String)"ParameterDialog.Button.ChangeFormat");
    private static final String BUTTON_LABEL_IMPORT = Messages.getString((String)"ParameterDialog.Button.ImportValue");
    private static final String BUTTON_LABEL_SET_DEFAULT = Messages.getString((String)"ParameterDialog.Button.SetDefault");
    private static final String BUTTON_LABEL_REMOVE_DEFAULT = Messages.getString((String)"ParameterDialog.Button.RemoveDefault");
    private static final String BUTTON_LABEL_DELETE = Messages.getString((String)"ParameterDialog.Button.Delete");
    private static final String BUTTON_CREATE_DATA_SET = Messages.getString((String)"ParameterDialog.Button.CreateDataSet");
    private static final String RADIO_DYNAMIC = Messages.getString((String)"ParameterDialog.Radio.Dynamic");
    private static final String RADIO_STATIC = Messages.getString((String)"ParameterDialog.Radio.Static");
    private static final String INPUT_PROPMT = Messages.getString((String)"ParameterDialog.Prompt.Input");
    private static final String ERROR_TITLE_INVALID_INPUT = Messages.getString((String)"ParameterDialog.ErrorTitle.InvalidInput");
    private static final String ERROR_TITLE_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorTitle.InvalidListLimit");
    private static final String ERROR_MSG_CANNOT_BE_BLANK = Messages.getString((String)"ParameterDialog.ErrorMessage.CanootBeBlank");
    private static final String ERROR_MSG_CANNOT_BE_NULL = Messages.getString((String)"ParameterDialog.ErrorMessage.CanootBeNull");
    private static final String ERROR_MSG_DUPLICATED_VALUE = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedValue");
    private static final String ERROR_MSG_DUPLICATED_LABEL = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedLabel");
    private static final String ERROR_MSG_MISMATCH_DATA_TYPE = Messages.getString((String)"ParameterDialog.ErrorMessage.MismatchDataType");
    private static final String ERROR_MSG_DUPLICATED_NAME = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedName");
    private static final String ERROR_MSG_NAME_IS_EMPTY = Messages.getString((String)"ParameterDialog.Errormessage.EmptyName");
    private static final String ERROR_MSG_NO_DEFAULT_VALUE = Messages.getString((String)"ParameterDialog.ErrorMessage.NoDefaultValue");
    private static final String ERROR_MSG_NO_AVAILABLE_COLUMN = Messages.getString((String)"ParameterDialog.ErrorMessage.NoAvailableColumn");
    private static final String ERROR_MSG_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorMessage.InvalidListLimit");
    private static final String FLAG_DEFAULT = Messages.getString((String)"ParameterDialog.Flag.Default");
    private static final String COLUMN_VALUE = Messages.getString((String)"ParameterDialog.Column.Value");
    private static final String COLUMN_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Column.DisplayText");
    private static final String COLUMN_IS_DEFAULT = Messages.getString((String)"ParameterDialog.Column.Default");
    private static final String BOOLEAN_TRUE = Messages.getString((String)"ParameterDialog.Boolean.True");
    private static final String BOOLEAN_FALSE = Messages.getString((String)"ParameterDialog.Boolean.False");
    private static final String PARAM_CONTROL_LIST = "list-box/List";
    private static final String PARAM_CONTROL_COMBO = "list-box/Combo";
    private static final String DISPLAY_NAME_CONTROL_LIST = Messages.getString((String)"ParameterDialog.DisplayLabel.List");
    private static final String DISPLAY_NAME_CONTROL_COMBO = Messages.getString((String)"ParameterDialog.DisplayLabel.Combo");
    private static final String NONE_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Label.None");
    private static final Image DEFAULT_ICON = ReportPlatformUIImages.getImage("Default");
    private static final Image ERROR_ICON = ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
    private static final String STANDARD_DATE_TIME_PATTERN = "MM/dd/yyyy hh:mm:ss a";
    private HashMap dirtyProperties = new HashMap(5);
    private ArrayList choiceList = new ArrayList();
    private static IChoiceSet dataType = DesignEngine.getMetaDataDictionary().getChoiceSet("paramType");
    private static IChoiceSet controlType = DesignEngine.getMetaDataDictionary().getChoiceSet("paramControl");
    private ScalarParameterHandle inputParameter;
    private boolean loading = true;
    private static final SelectionChoice dummyChoice = StructureFactory.createSelectionChoice();
    private Text nameEditor;
    private Text promptTextEditor;
    private Text defaultValueEditor;
    private Text helpTextEditor;
    private Text formatField;
    private Label promptMessageLine;
    private CLabel errorMessageLine;
    private Button allowNull;
    private Button allowBlank;
    private Button doNotEcho;
    private Button isHidden;
    private Button needSort;
    private Button importValue;
    private Button changeDefault;
    private Button delete;
    private Button changeFormat;
    private Button createDataSet;
    private Button dynamicRadio;
    private Button staticRadio;
    private Combo dataTypeChooser;
    private Combo controlTypeChooser;
    private Combo defaultValueChooser;
    private Combo dataSetChooser;
    private Combo columnChooser;
    private Combo displayTextChooser;
    private Label previewLabel;
    private TableViewer valueTable;
    private String lastDataType;
    private String lastControlType;
    private String formatCategroy;
    private String formatPattern;
    private String defaultValue;
    private Composite valueArea;
    private List columnList;
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = (ArrayList)inputElement;
            ArrayList elementsList = (ArrayList)list.clone();
            elementsList.add(dummyChoice);
            return elementsList.toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            SelectionChoice choice;
            if (ParameterDialog.this.valueTable.getColumnProperties().length == 4 && columnIndex == 1 && ParameterDialog.this.isDefaultChoice(choice = (SelectionChoice)element)) {
                return DEFAULT_ICON;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SelectionChoice choice = (SelectionChoice)element;
            int valueIndex = ParameterDialog.this.valueTable.getColumnProperties().length - 2;
            String text = null;
            if (ParameterDialog.this.valueTable.getColumnProperties().length == 4 && columnIndex == 1) {
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    text = FLAG_DEFAULT;
                }
            } else if (columnIndex == valueIndex) {
                text = choice == dummyChoice ? INPUT_PROPMT : choice.getValue();
            } else if (columnIndex == valueIndex + 1 && choice != dummyChoice && (text = choice.getLabel()) == null) {
                text = ParameterDialog.this.format(choice.getValue());
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ICellModifier cellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            return property != null && (element != dummyChoice || COLUMN_VALUE.equals(property));
        }

        public Object getValue(Object element, String property) {
            SelectionChoice choice = (SelectionChoice)element;
            if (choice == dummyChoice) {
                return "";
            }
            String value = null;
            if (COLUMN_VALUE.equals(property)) {
                value = choice.getValue();
            } else if (COLUMN_DISPLAY_TEXT.equals(property)) {
                value = choice.getLabel();
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            SelectionChoice choice = (SelectionChoice)element;
            String newValue = UIUtil.convertToModelString((String)value, false);
            if (COLUMN_VALUE.equals(property)) {
                String errorMessage = ParameterDialog.this.isValidValue(newValue);
                if (errorMessage != null) {
                    ExceptionHandler.openMessageBox(ERROR_TITLE_INVALID_INPUT, errorMessage, 2);
                    return;
                }
                if (choice.getLabel() == null && ParameterDialog.this.containValue(choice, newValue, COLUMN_DISPLAY_TEXT)) {
                    ExceptionHandler.openMessageBox(ERROR_TITLE_INVALID_INPUT, ERROR_MSG_DUPLICATED_LABEL, 2);
                    return;
                }
            }
            if (ParameterDialog.this.containValue(choice, newValue = ParameterDialog.this.convertToStandardFormat(newValue), property)) {
                if (COLUMN_DISPLAY_TEXT.equals(property)) {
                    ExceptionHandler.openMessageBox(ERROR_TITLE_INVALID_INPUT, ERROR_MSG_DUPLICATED_LABEL, 2);
                } else {
                    ExceptionHandler.openMessageBox(ERROR_TITLE_INVALID_INPUT, ERROR_MSG_DUPLICATED_VALUE, 2);
                }
                return;
            }
            if (choice == dummyChoice) {
                choice = StructureFactory.createSelectionChoice();
                ParameterDialog.this.choiceList.add(choice);
            }
            if (COLUMN_VALUE.equals(property)) {
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    ParameterDialog.this.defaultValue = newValue;
                }
                choice.setValue(newValue);
            } else if (COLUMN_DISPLAY_TEXT.equals(property)) {
                choice.setLabel(newValue);
            }
            ParameterDialog.this.refreshValueTable();
        }
    };
    private Text listLimit;

    public ParameterDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    public ParameterDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createPropertiesSection(composite);
        this.createMoreOptionSection(composite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ParameterDialog_ID");
        return composite;
    }

    private void createPropertiesSection(Composite composite) {
        Group propertiesSection = new Group(composite, 0);
        propertiesSection.setText(GROUP_PROPERTIES);
        propertiesSection.setLayout((Layout)new GridLayout(2, false));
        propertiesSection.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)propertiesSection, LABEL_NAME);
        this.nameEditor = new Text((Composite)propertiesSection, 2048);
        this.nameEditor.setLayoutData((Object)new GridData(768));
        this.nameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this.updateMessageLine();
            }
        });
        this.createLabel((Composite)propertiesSection, LABEL_PROMPT_TEXT);
        this.promptTextEditor = new Text((Composite)propertiesSection, 2048);
        this.promptTextEditor.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)propertiesSection, LABEL_PARAM_DATA_TYPE);
        this.dataTypeChooser = new Combo((Composite)propertiesSection, 12);
        this.dataTypeChooser.setLayoutData((Object)new GridData(768));
        this.dataTypeChooser.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(dataType));
        this.dataTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.changeDataType();
                if (ParameterDialog.this.allowBlank != null && !ParameterDialog.this.allowBlank.isDisposed()) {
                    if ("string".equals(ParameterDialog.this.getSelectedDataType())) {
                        ParameterDialog.this.allowBlank.setEnabled(true);
                    } else {
                        ParameterDialog.this.allowBlank.setEnabled(false);
                        ParameterDialog.this.allowBlank.setSelection(false);
                        ParameterDialog.this.checkBoxChange(ParameterDialog.this.allowBlank, CHECKBOX_ALLOW_BLANK);
                    }
                }
            }
        });
        this.createLabel((Composite)propertiesSection, LABEL_DISPALY_TYPE);
        this.controlTypeChooser = new Combo((Composite)propertiesSection, 12);
        this.controlTypeChooser.setLayoutData((Object)new GridData(768));
        this.controlTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.changeControlType();
            }
        });
        this.createLabel((Composite)propertiesSection, LABEL_LIST_OF_VALUE);
        Composite choiceArea = new Composite((Composite)propertiesSection, 0);
        choiceArea.setLayoutData((Object)new GridData(768));
        choiceArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, true));
        this.staticRadio = new Button(choiceArea, 16);
        this.staticRadio.setText(RADIO_STATIC);
        this.staticRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.switchParamterType();
            }
        });
        this.dynamicRadio = new Button(choiceArea, 16);
        this.dynamicRadio.setText(RADIO_DYNAMIC);
        this.dynamicRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.switchParamterType();
            }
        });
        this.valueArea = new Composite((Composite)propertiesSection, 0);
        this.valueArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 550;
        gd.horizontalSpan = 2;
        this.valueArea.setLayoutData((Object)gd);
        this.createLabel((Composite)propertiesSection, null);
        this.errorMessageLine = new CLabel((Composite)propertiesSection, 0);
        this.errorMessageLine.setLayoutData((Object)new GridData(768));
    }

    private void createMoreOptionSection(Composite composite) {
        Group moreOptionSection = new Group(composite, 0);
        moreOptionSection.setText(GROUP_MORE_OPTION);
        moreOptionSection.setLayout((Layout)new GridLayout(2, false));
        moreOptionSection.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)moreOptionSection, LABEL_HELP_TEXT);
        this.helpTextEditor = new Text((Composite)moreOptionSection, 2048);
        this.helpTextEditor.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)moreOptionSection, LABEL_FORMAT);
        Composite formatSection = new Composite((Composite)moreOptionSection, 0);
        formatSection.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        formatSection.setLayoutData((Object)new GridData(768));
        this.formatField = new Text(formatSection, 2060);
        this.formatField.setLayoutData((Object)new GridData(768));
        this.changeFormat = new Button(formatSection, 8);
        this.changeFormat.setText(BUTTON_LABEL_CHANGE_FORMAT);
        this.setButtonLayoutData(this.changeFormat);
        this.changeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.popupFormatBuilder(true);
            }
        });
        this.createLabel((Composite)moreOptionSection, null);
        Group previewArea = new Group((Composite)moreOptionSection, 0);
        previewArea.setLayoutData((Object)new GridData(768));
        previewArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        previewArea.setText(LABEL_PREVIEW);
        this.previewLabel = new Label((Composite)previewArea, 0);
        this.previewLabel.setAlignment(0x1000000);
        this.previewLabel.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)moreOptionSection, LABEL_LIST_LIMIT);
        Composite limitArea = new Composite((Composite)moreOptionSection, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        limitArea.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.verticalSpan = 1;
        limitArea.setLayoutData((Object)data);
        this.listLimit = new Text(limitArea, 2048);
        data = new GridData();
        data.widthHint = 80;
        this.listLimit.setLayoutData((Object)data);
        this.listLimit.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = "0123456789\u0000\b\u007f".indexOf(e.character) != -1;
            }
        });
        Label values = new Label(limitArea, 0);
        values.setText(Messages.getString((String)"ParameterDialog.Label.values"));
        values.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)moreOptionSection, null);
        Composite checkBoxArea = new Composite((Composite)moreOptionSection, 0);
        checkBoxArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        checkBoxArea.setLayoutData((Object)new GridData(1808));
        this.allowNull = new Button(checkBoxArea, 32);
        this.allowNull.setText(CHECKBOX_ALLOW_NULL);
        this.addCheckBoxListener(this.allowNull, CHECKBOX_ALLOW_NULL);
        this.allowBlank = new Button(checkBoxArea, 32);
        this.allowBlank.setText(CHECKBOX_ALLOW_BLANK);
        this.addCheckBoxListener(this.allowBlank, CHECKBOX_ALLOW_BLANK);
        this.doNotEcho = new Button(checkBoxArea, 32);
        this.doNotEcho.setText(CHECKBOX_DO_NOT_ECHO);
        this.addCheckBoxListener(this.doNotEcho, CHECKBOX_DO_NOT_ECHO);
        this.isHidden = new Button(checkBoxArea, 32);
        this.isHidden.setText(CHECKBOX_HIDDEN);
        this.addCheckBoxListener(this.isHidden, CHECKBOX_HIDDEN);
        this.needSort = new Button(checkBoxArea, 32);
        this.needSort.setText(CHECKBOX_SORT);
        this.addCheckBoxListener(this.needSort, CHECKBOX_SORT);
    }

    public void setInput(Object input) {
        Assert.isNotNull((Object)input);
        Assert.isLegal((boolean)(input instanceof ScalarParameterHandle));
        this.inputParameter = (ScalarParameterHandle)input;
    }

    protected boolean initDialog() {
        Assert.isNotNull((Object)this.inputParameter);
        this.nameEditor.setText(this.inputParameter.getName());
        if (!StringUtil.isBlank((String)this.inputParameter.getPromptText())) {
            this.promptTextEditor.setText(this.inputParameter.getPromptText());
        }
        this.helpTextEditor.setText(UIUtil.convertToGUIString(this.inputParameter.getHelpText()));
        if (this.inputParameter.getValueType().equals("static")) {
            this.staticRadio.setSelection(true);
            Iterator iter = this.inputParameter.getPropertyHandle("selectionList").iterator();
            while (iter.hasNext()) {
                SelectionChoiceHandle choiceHandle = (SelectionChoiceHandle)iter.next();
                this.choiceList.add(choiceHandle.getStructure());
            }
        } else {
            this.dynamicRadio.setSelection(true);
        }
        this.defaultValue = this.inputParameter.getDefaultValue();
        if (this.inputParameter.getPropertyHandle("listLimit").isSet()) {
            this.listLimit.setText(String.valueOf(this.inputParameter.getListlimit()));
        }
        this.changeDataType();
        this.dataTypeChooser.setText(dataType.findChoice(this.inputParameter.getDataType()).getDisplayName());
        this.switchParamterType();
        this.loading = false;
        return true;
    }

    private void initValueArea() {
        if (this.isStatic()) {
            if ("check-box".equals(this.getSelectedControlType())) {
                if (this.isValidValue(this.defaultValue) != null) {
                    this.defaultValue = null;
                    this.defaultValueChooser.select(0);
                } else if (Boolean.valueOf(this.defaultValue).booleanValue()) {
                    this.defaultValueChooser.select(1);
                } else {
                    this.defaultValueChooser.select(2);
                }
            } else if ("text-box".equals(this.getSelectedControlType()) && this.defaultValue != null) {
                this.defaultValueEditor.setText(this.defaultValue);
            }
            this.refreshValueTable();
        } else {
            this.refreshDataSets();
            if (this.inputParameter.getDataSetName() != null) {
                this.dataSetChooser.setText(this.inputParameter.getDataSetName());
            }
            this.refreshColumns(false);
            String columnName = this.getColumnName(this.inputParameter.getValueExpr());
            if (columnName != null) {
                this.columnChooser.setText(columnName);
            }
            if ((columnName = this.getColumnName(this.inputParameter.getLabelExpr())) != null) {
                this.displayTextChooser.setText(columnName);
            }
            if (this.defaultValue != null) {
                this.defaultValueEditor.setText(this.defaultValue);
            }
        }
        this.updateMessageLine();
    }

    private void initFormatField() {
        if ("decimal".equals(this.lastControlType) && "float".equals(this.getSelectedDataType()) || "float".equals(this.lastControlType) && "decimal".equals(this.getSelectedDataType())) {
            return;
        }
        IChoiceSet choiceSet = this.getFormatChoiceSet(this.getSelectedDataType());
        if (choiceSet == null) {
            this.formatPattern = null;
            this.formatCategroy = null;
        } else if (!this.loading || this.inputParameter.getCategory() == null && this.inputParameter.getPattern() == null) {
            if ("string".equals(this.getSelectedDataType())) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("dateTime".equals(this.getSelectedDataType())) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("decimal".equals(this.getSelectedDataType()) || "float".equals(this.getSelectedDataType())) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            }
            this.formatPattern = null;
        } else {
            this.formatCategroy = this.inputParameter.getCategory();
            if (this.formatCategroy == null) {
                this.formatCategroy = "Unformatted";
            }
            this.formatPattern = this.inputParameter.getPattern();
        }
        this.updateFormatField();
    }

    private void refreshCheckBoxArea() {
        if (this.dirtyProperties.containsKey(CHECKBOX_HIDDEN)) {
            this.isHidden.setSelection(this.getProperty(CHECKBOX_HIDDEN));
        } else {
            this.isHidden.setSelection(this.inputParameter.isHidden());
        }
        if (!"check-box".equals(this.getSelectedControlType())) {
            if (!"text-box".equals(this.getSelectedControlType())) {
                this.needSort.setEnabled(true);
                if (this.dirtyProperties.containsKey(CHECKBOX_SORT)) {
                    this.needSort.setSelection(this.getProperty(CHECKBOX_SORT));
                } else {
                    this.needSort.setSelection(!this.inputParameter.isFixedOrder());
                }
            } else {
                this.needSort.setEnabled(false);
                this.needSort.setSelection(false);
                this.checkBoxChange(this.needSort, CHECKBOX_SORT);
            }
            if ("text-box".equals(this.getSelectedControlType()) || PARAM_CONTROL_LIST.equals(this.getSelectedControlType())) {
                this.allowBlank.setEnabled(true);
                this.allowNull.setEnabled(true);
                this.doNotEcho.setEnabled(true);
                if (this.dirtyProperties.containsKey(CHECKBOX_ALLOW_BLANK)) {
                    this.allowBlank.setSelection(this.getProperty(CHECKBOX_ALLOW_BLANK));
                } else {
                    this.allowBlank.setSelection(this.inputParameter.allowBlank());
                }
                if (this.dirtyProperties.containsKey(CHECKBOX_ALLOW_NULL)) {
                    this.allowNull.setSelection(this.getProperty(CHECKBOX_ALLOW_NULL));
                } else {
                    this.allowNull.setSelection(this.inputParameter.allowNull());
                }
            } else {
                this.allowBlank.setEnabled(false);
                this.allowNull.setEnabled(false);
            }
            if ("text-box".equals(this.getSelectedControlType())) {
                this.doNotEcho.setEnabled(true);
                if (this.dirtyProperties.containsKey(CHECKBOX_DO_NOT_ECHO)) {
                    this.doNotEcho.setSelection(this.getProperty(CHECKBOX_DO_NOT_ECHO));
                } else {
                    this.doNotEcho.setSelection(this.inputParameter.isConcealValue());
                }
            } else {
                this.doNotEcho.setEnabled(false);
            }
        }
        if (!"string".equals(this.getSelectedDataType())) {
            this.allowBlank.setEnabled(false);
            this.allowBlank.setSelection(false);
            this.checkBoxChange(this.allowBlank, CHECKBOX_ALLOW_BLANK);
        }
    }

    private void refreshDataSets() {
        String[] newList;
        String selectedDataSetName = this.dataSetChooser.getText();
        String[] oldList = this.dataSetChooser.getItems();
        if (oldList.length != (newList = ChoiceSetFactory.getDataSets()).length) {
            this.dataSetChooser.setItems(newList);
            if (StringUtil.isBlank((String)selectedDataSetName)) {
                this.dataSetChooser.select(0);
                this.refreshColumns(false);
            } else {
                this.dataSetChooser.setText(selectedDataSetName);
            }
        }
    }

    private void refreshColumns(boolean onlyFilter) {
        Iterator iter;
        if (this.columnChooser == null) {
            return;
        }
        if (!onlyFilter) {
            DataSetHandle dataSetHandle = this.inputParameter.getModuleHandle().findDataSet(this.dataSetChooser.getText());
            try {
                this.columnList = DataUtil.getColumnList(dataSetHandle);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
            this.displayTextChooser.removeAll();
            this.displayTextChooser.add(NONE_DISPLAY_TEXT);
            iter = this.columnList.iterator();
            while (iter.hasNext()) {
                this.displayTextChooser.add(((ResultSetColumnHandle)iter.next()).getColumnName());
            }
            this.displayTextChooser.setText(NONE_DISPLAY_TEXT);
        }
        String originalSelection = this.columnChooser.getText();
        this.columnChooser.removeAll();
        iter = this.columnList.iterator();
        while (iter.hasNext()) {
            ResultSetColumnHandle cachedColumn = (ResultSetColumnHandle)iter.next();
            if (!this.matchDataType(cachedColumn)) continue;
            this.columnChooser.add(cachedColumn.getColumnName());
        }
        if (this.columnChooser.indexOf(originalSelection) != -1) {
            this.columnChooser.setText(originalSelection);
        } else if (this.columnChooser.getItemCount() > 0) {
            this.columnChooser.select(0);
        }
        this.columnChooser.setEnabled(this.columnChooser.getItemCount() > 0);
        this.updateMessageLine();
    }

    private boolean matchDataType(ResultSetColumnHandle column) {
        String type = this.getSelectedDataType();
        if (type.equals("string") || "any".equals(column.getDataType())) {
            return true;
        }
        if ("date-time".equals(column.getDataType())) {
            return type.equals("dateTime");
        }
        if ("decimal".equals(column.getDataType())) {
            return type.equals("decimal");
        }
        if ("float".equals(column.getDataType())) {
            return type.equals("float");
        }
        if ("integer".equals(column.getDataType())) {
            return type.equals("float") || type.equals("decimal");
        }
        return false;
    }

    private String getInputControlType() {
        String type = null;
        type = this.inputParameter.getControlType() == null ? "text-box" : ("list-box".equals(this.inputParameter.getControlType()) ? (this.inputParameter.isMustMatch() ? PARAM_CONTROL_COMBO : PARAM_CONTROL_LIST) : this.inputParameter.getControlType());
        return type;
    }

    private String getSelectedDataType() {
        String type = null;
        if (StringUtil.isBlank((String)this.dataTypeChooser.getText())) {
            type = this.inputParameter.getDataType();
        } else {
            IChoice choice = dataType.findChoiceByDisplayName(this.dataTypeChooser.getText());
            type = dataType.findChoiceByDisplayName(this.dataTypeChooser.getText()).getName();
            type = choice.getName();
        }
        return type;
    }

    private String getSelectedControlType() {
        String displayText = this.controlTypeChooser.getText();
        if (StringUtil.isBlank((String)displayText)) {
            return this.getInputControlType();
        }
        if (DISPLAY_NAME_CONTROL_COMBO.equals(displayText)) {
            return PARAM_CONTROL_COMBO;
        }
        if (DISPLAY_NAME_CONTROL_LIST.equals(displayText)) {
            return PARAM_CONTROL_LIST;
        }
        return controlType.findChoiceByDisplayName(displayText).getName();
    }

    private void changeDataType() {
        String type = this.getSelectedDataType();
        if (type.equals(this.lastDataType)) {
            return;
        }
        if (this.buildControlTypeList(type)) {
            this.changeControlType();
        }
        this.lastDataType = type;
        this.initFormatField();
        if (this.isStatic()) {
            this.makeUniqueAndValid();
            this.refreshValueTable();
        } else {
            this.refreshColumns(true);
        }
        this.updateMessageLine();
    }

    private boolean buildControlTypeList(String type) {
        String[] choices = this.isStatic() ? ("boolean".equals(type) ? new String[3] : new String[4]) : new String[2];
        if (this.controlTypeChooser.getItemCount() != choices.length) {
            String originalSelection = this.controlTypeChooser.getText();
            if (this.isStatic()) {
                if ("boolean".equals(type)) {
                    choices[0] = controlType.findChoice("check-box").getDisplayName();
                } else {
                    choices[0] = controlType.findChoice("text-box").getDisplayName();
                    choices[1] = DISPLAY_NAME_CONTROL_LIST;
                }
                choices[choices.length - 2] = DISPLAY_NAME_CONTROL_COMBO;
                choices[choices.length - 1] = controlType.findChoice("radio-button").getDisplayName();
            } else {
                choices[0] = DISPLAY_NAME_CONTROL_COMBO;
                choices[1] = DISPLAY_NAME_CONTROL_LIST;
            }
            this.controlTypeChooser.setItems(choices);
            if (originalSelection.length() == 0) {
                this.controlTypeChooser.setText(this.getInputControlDisplayName());
            } else {
                int index = this.controlTypeChooser.indexOf(originalSelection);
                if (index == -1) {
                    this.controlTypeChooser.select(0);
                    return true;
                }
                this.controlTypeChooser.setText(originalSelection);
            }
        }
        return false;
    }

    private void makeUniqueAndValid() {
        Iterator iter = this.choiceList.iterator();
        while (iter.hasNext()) {
            SelectionChoice choice = (SelectionChoice)iter.next();
            if (this.isValidValue(choice.getValue()) == null && !this.containValue(choice, choice.getValue(), COLUMN_VALUE)) continue;
            iter.remove();
        }
    }

    private void changeControlType() {
        String type;
        if (this.isStatic() && !(type = this.getSelectedControlType()).equals(this.lastControlType)) {
            if ("check-box".equals(type)) {
                this.clearArea(this.valueArea);
                this.switchToCheckBox();
            } else if (PARAM_CONTROL_COMBO.equals(type) || PARAM_CONTROL_LIST.equals(type) || "radio-button".equals(type)) {
                if (!(PARAM_CONTROL_COMBO.equals(this.lastControlType) || PARAM_CONTROL_LIST.equals(this.lastControlType) || "radio-button".equals(this.lastControlType))) {
                    this.clearArea(this.valueArea);
                    this.switchToList();
                }
            } else if ("text-box".equals(type)) {
                this.clearArea(this.valueArea);
                this.switchToText();
            }
            this.valueArea.layout();
            this.initValueArea();
            this.lastControlType = type;
        }
        this.refreshCheckBoxArea();
        this.updateMessageLine();
        boolean radioEnable = false;
        if (PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) || PARAM_CONTROL_LIST.equals(this.getSelectedControlType())) {
            radioEnable = true;
        }
        if (radioEnable != this.staticRadio.isEnabled()) {
            this.staticRadio.setEnabled(radioEnable);
            this.dynamicRadio.setEnabled(radioEnable);
        }
    }

    private void switchParamterType() {
        this.clearArea(this.valueArea);
        this.lastControlType = null;
        if (this.isStatic()) {
            this.switchToStatic();
        } else {
            this.switchToDynamic();
        }
        this.buildControlTypeList(this.getSelectedDataType());
        this.valueArea.layout();
        this.initValueArea();
        this.refreshCheckBoxArea();
    }

    private void switchToCheckBox() {
        this.createLabel(this.valueArea, LABEL_DEFAULT_VALUE);
        this.defaultValueChooser = new Combo(this.valueArea, 2056);
        this.defaultValueChooser.add(CHOICE_NO_DEFAULT);
        this.defaultValueChooser.add(BOOLEAN_TRUE);
        this.defaultValueChooser.add(BOOLEAN_FALSE);
        this.defaultValueChooser.setLayoutData((Object)new GridData(768));
        this.defaultValueChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (ParameterDialog.this.defaultValueChooser.getSelectionIndex()) {
                    case 0: {
                        ParameterDialog.this.defaultValue = null;
                        break;
                    }
                    case 1: {
                        ParameterDialog.this.defaultValue = Boolean.toString(true);
                        break;
                    }
                    case 2: {
                        ParameterDialog.this.defaultValue = Boolean.toString(false);
                    }
                }
            }
        });
    }

    private void switchToList() {
        this.createLabel(this.valueArea, LABEL_VALUES);
        Composite tableArea = new Composite(this.valueArea, 0);
        tableArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        tableArea.setLayoutData((Object)new GridData(1808));
        Table table = new Table(tableArea, 67588);
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    ParameterDialog.this.deleteRow();
                }
            }
        });
        String[] columns = new String[]{null, COLUMN_IS_DEFAULT, COLUMN_VALUE, COLUMN_DISPLAY_TEXT};
        int[] columnWidth = new int[]{20, 70, 145, 145};
        CellEditor[] cellEditors = new CellEditor[]{null, null, new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
        for (int i = 0; i < columns.length; ++i) {
            TableColumn column = new TableColumn(table, 16384);
            column.setResizable(columns[i] != null);
            if (columns[i] != null) {
                column.setText(columns[i]);
            }
            column.setWidth(columnWidth[i]);
        }
        this.valueTable = new TableViewer(table);
        this.valueTable.setCellEditors(cellEditors);
        this.valueTable.setColumnProperties(columns);
        this.valueTable.setContentProvider((IContentProvider)this.contentProvider);
        this.valueTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.valueTable.setCellModifier(this.cellModifier);
        this.valueTable.setInput((Object)this.choiceList);
        this.valueTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ParameterDialog.this.updateTableButtons();
            }
        });
        Composite buttonBar = new Composite(tableArea, 0);
        buttonBar.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(4, false));
        buttonBar.setLayoutData((Object)new GridData(768));
        this.importValue = new Button(buttonBar, 8);
        this.importValue.setText(BUTTON_LABEL_IMPORT);
        this.setButtonLayoutData(this.importValue);
        this.importValue.setEnabled(!this.inputParameter.getModuleHandle().getVisibleDataSets().isEmpty());
        this.importValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String type = ParameterDialog.this.getSelectedDataType();
                ImportValueDialog dialog = new ImportValueDialog(type);
                if (dialog.open() == 0) {
                    String[] importValues = (String[])dialog.getResult();
                    for (int i = 0; i < importValues.length; ++i) {
                        if (ParameterDialog.this.containValue(null, importValues[i], COLUMN_VALUE)) continue;
                        SelectionChoice choice = StructureFactory.createSelectionChoice();
                        choice.setValue(importValues[i]);
                        ParameterDialog.this.choiceList.add(choice);
                    }
                    ParameterDialog.this.refreshValueTable();
                }
            }
        });
        this.changeDefault = new Button(buttonBar, 2);
        this.changeDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionChoice choice = (SelectionChoice)((IStructuredSelection)ParameterDialog.this.valueTable.getSelection()).getFirstElement();
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    ParameterDialog.this.defaultValue = null;
                } else {
                    ParameterDialog.this.defaultValue = choice.getValue();
                }
                ParameterDialog.this.refreshValueTable();
                ParameterDialog.this.updateMessageLine();
                ParameterDialog.this.updateButtons();
                ParameterDialog.this.changeDefault.getParent().layout();
            }
        });
        this.delete = new Button(buttonBar, 8);
        this.delete.setText(BUTTON_LABEL_DELETE);
        this.setButtonLayoutData(this.delete);
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.deleteRow();
            }
        });
        this.createPromptLine(tableArea);
        this.updateTableButtons();
    }

    private void switchToText() {
        this.createDefaultEditor();
        this.createLabel(this.valueArea, null);
        this.createPromptLine(this.valueArea);
    }

    private void switchToStatic() {
        this.changeControlType();
        this.listLimit.setEditable(false);
    }

    private void switchToDynamic() {
        Composite composite = new Composite(this.valueArea, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(3, false));
        this.createLabel(composite, LABEL_SELECT_DATA_SET);
        this.dataSetChooser = new Combo(composite, 2056);
        this.dataSetChooser.setLayoutData((Object)new GridData(768));
        this.dataSetChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.refreshColumns(false);
            }
        });
        this.createDataSet = new Button(composite, 8);
        this.createDataSet.setText(BUTTON_CREATE_DATA_SET);
        this.setButtonLayoutData(this.createDataSet);
        this.createDataSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new NewDataSetAction().run();
                ParameterDialog.this.refreshDataSets();
            }
        });
        this.createLabel(composite, LABEL_SELECT_VALUE_COLUMN);
        this.columnChooser = new Combo(composite, 2056);
        this.columnChooser.setLayoutData((Object)new GridData(768));
        this.columnChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ParameterDialog.this.updateButtons();
            }
        });
        this.createLabel(composite, null);
        this.createLabel(composite, LABEL_SELECT_DISPLAY_TEXT);
        this.displayTextChooser = new Combo(composite, 2056);
        this.displayTextChooser.setLayoutData((Object)new GridData(768));
        this.createLabel(composite, null);
        this.createDefaultEditor();
        this.listLimit.setEditable(true);
    }

    private void createDefaultEditor() {
        this.createLabel(this.valueArea, LABEL_DEFAULT_VALUE);
        this.defaultValueEditor = new Text(this.valueArea, 2048);
        this.defaultValueEditor.setLayoutData((Object)new GridData(768));
        this.defaultValueEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this.defaultValue = UIUtil.convertToModelString(ParameterDialog.this.defaultValueEditor.getText(), false);
                if (ParameterDialog.this.isStatic()) {
                    ParameterDialog.this.refreshValueTable();
                }
                ParameterDialog.this.updateFormatField();
                ParameterDialog.this.updateMessageLine();
            }
        });
    }

    private void createPromptLine(Composite parent) {
        this.promptMessageLine = new Label(parent, 0);
        this.promptMessageLine.setLayoutData((Object)new GridData(768));
    }

    protected void okPressed() {
        try {
            this.inputParameter.setName(this.nameEditor.getText());
            this.inputParameter.setPromptText(UIUtil.convertToModelString(this.promptTextEditor.getText(), true));
            String newControlType = this.getSelectedControlType();
            if (PARAM_CONTROL_COMBO.equals(newControlType)) {
                newControlType = "list-box";
                this.inputParameter.setMustMatch(true);
            } else if (PARAM_CONTROL_LIST.equals(newControlType)) {
                newControlType = "list-box";
                this.inputParameter.setMustMatch(false);
            } else {
                this.inputParameter.setProperty("mustMatch", null);
            }
            this.inputParameter.setControlType(newControlType);
            this.inputParameter.setDefaultValue(this.defaultValue);
            this.inputParameter.setDataType(dataType.findChoiceByDisplayName(this.dataTypeChooser.getText()).getName());
            PropertyHandle selectionChioceList = this.inputParameter.getPropertyHandle("selectionList");
            selectionChioceList.setValue(null);
            if (this.isStatic()) {
                this.inputParameter.setValueType("static");
                if (!"text-box".equals(newControlType) && !"check-box".equals(newControlType)) {
                    Iterator iter = this.choiceList.iterator();
                    while (iter.hasNext()) {
                        SelectionChoice choice = (SelectionChoice)iter.next();
                        if (this.isValidValue(choice.getValue()) != null) continue;
                        selectionChioceList.addItem((IStructure)choice);
                    }
                }
                this.inputParameter.setDataSetName(null);
                this.inputParameter.setValueExpr(null);
                this.inputParameter.setLabelExpr(null);
            } else {
                this.inputParameter.setValueType("dynamic");
                this.inputParameter.setDataSetName(this.dataSetChooser.getText());
                this.inputParameter.setValueExpr(this.getExpression(this.columnChooser.getText()));
                this.inputParameter.setLabelExpr(this.getExpression(this.displayTextChooser.getText()));
            }
            this.inputParameter.setHelpText(UIUtil.convertToModelString(this.helpTextEditor.getText(), false));
            this.inputParameter.setCategory(this.formatCategroy);
            this.inputParameter.setPattern(this.formatPattern);
            if (this.isStatic() && (PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) || "radio-button".equals(this.getSelectedControlType())) && !this.containValue(null, this.defaultValue, COLUMN_VALUE)) {
                this.defaultValue = null;
            }
            if (this.dirtyProperties.containsKey(CHECKBOX_HIDDEN)) {
                this.inputParameter.setHidden(this.getProperty(CHECKBOX_HIDDEN));
            }
            if (PARAM_CONTROL_LIST.equals(this.getSelectedControlType()) || "text-box".equals(this.getSelectedControlType())) {
                if (this.dirtyProperties.containsKey(CHECKBOX_ALLOW_BLANK)) {
                    this.inputParameter.setAllowBlank(this.getProperty(CHECKBOX_ALLOW_BLANK));
                }
                if (this.dirtyProperties.containsKey(CHECKBOX_ALLOW_NULL)) {
                    this.inputParameter.setAllowNull(this.getProperty(CHECKBOX_ALLOW_NULL));
                }
            } else {
                this.inputParameter.setProperty("allowBlank", null);
                this.inputParameter.setProperty("allowNull", null);
            }
            if ("text-box".equals(this.getSelectedControlType())) {
                if (this.dirtyProperties.containsKey(CHECKBOX_DO_NOT_ECHO)) {
                    this.inputParameter.setConcealValue(this.getProperty(CHECKBOX_DO_NOT_ECHO));
                }
            } else {
                this.inputParameter.setProperty("concealValue", null);
            }
            if ("text-box".equals(newControlType) || "check-box".equals(newControlType)) {
                this.inputParameter.setProperty("fixedOrder", null);
            } else if (this.dirtyProperties.containsKey(CHECKBOX_SORT)) {
                this.inputParameter.setFixedOrder(!this.getProperty(CHECKBOX_SORT));
            }
            if (!this.isStatic() && !StringUtil.isBlank((String)this.listLimit.getText())) {
                try {
                    this.inputParameter.setListlimit(Integer.parseInt(this.listLimit.getText()));
                }
                catch (NumberFormatException ex) {
                    ExceptionHandler.openErrorMessageBox(ERROR_TITLE_INVALID_LIST_LIMIT, MessageFormat.format(ERROR_MSG_INVALID_LIST_LIMIT, Integer.toString(Integer.MAX_VALUE)));
                }
            } else {
                this.inputParameter.setProperty("listLimit", null);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return;
        }
        this.setResult(this.inputParameter);
        super.okPressed();
    }

    private void createLabel(Composite parent, String content) {
        Label label = new Label(parent, 0);
        if (content != null) {
            label.setText(content);
        }
        this.setLabelLayoutData(label);
    }

    private void setLabelLayoutData(Label label) {
        GridData gd = new GridData();
        if (label.getText().equals(LABEL_VALUES)) {
            gd.verticalAlignment = 1;
        }
        label.setLayoutData((Object)gd);
    }

    private void addCheckBoxListener(final Button checkBox, final String key) {
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.checkBoxChange(checkBox, key);
            }
        });
    }

    protected void checkBoxChange(Button checkBox, String key) {
        this.dirtyProperties.put(key, new Boolean(checkBox.getSelection()));
        if (CHECKBOX_ALLOW_BLANK.equals(key) || CHECKBOX_ALLOW_NULL.equals(key)) {
            if (this.isStatic()) {
                this.makeUniqueAndValid();
                this.refreshValueTable();
            }
            this.updateMessageLine();
        }
    }

    private void clearArea(Composite area) {
        Control[] children = area.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].dispose();
        }
    }

    private void updateTableButtons() {
        boolean isDefault;
        boolean isEnable = true;
        SelectionChoice selectedChoice = null;
        if (this.valueTable.getSelection().isEmpty()) {
            isEnable = false;
        } else {
            selectedChoice = (SelectionChoice)((IStructuredSelection)this.valueTable.getSelection()).getFirstElement();
            if (selectedChoice == dummyChoice) {
                isEnable = false;
            }
        }
        boolean bl = isDefault = isEnable && this.isDefaultChoice(selectedChoice);
        if (isDefault) {
            this.changeDefault.setText(BUTTON_LABEL_REMOVE_DEFAULT);
        } else {
            this.changeDefault.setText(BUTTON_LABEL_SET_DEFAULT);
        }
        this.changeDefault.setSelection(isDefault);
        this.changeDefault.setEnabled(isEnable);
        this.delete.setEnabled(isEnable);
    }

    private void updateButtons() {
        boolean canFinish;
        boolean bl = canFinish = !StringUtil.isBlank((String)this.nameEditor.getText());
        if (canFinish) {
            if (this.errorMessageLine != null && !this.errorMessageLine.isDisposed()) {
                boolean bl2 = canFinish = this.errorMessageLine.getImage() == null;
            }
            if (this.columnChooser != null && !this.isStatic()) {
                canFinish &= this.getExpression(this.columnChooser.getText()) != null;
            }
        }
        this.getOkButton().setEnabled(canFinish);
    }

    private void updateMessageLine() {
        String errorMessage = this.validateName();
        if (errorMessage == null) {
            if (!this.isStatic() && this.columnChooser != null && this.columnChooser.getItemCount() == 0) {
                errorMessage = ERROR_MSG_NO_AVAILABLE_COLUMN;
            } else if (this.defaultValue == null && (PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) || "radio-button".equals(this.getSelectedControlType()))) {
                errorMessage = ERROR_MSG_NO_DEFAULT_VALUE;
            }
        }
        if (errorMessage != null) {
            this.errorMessageLine.setText(errorMessage);
            this.errorMessageLine.setImage(ERROR_ICON);
        } else {
            this.errorMessageLine.setText("");
            this.errorMessageLine.setImage(null);
        }
        if (this.promptMessageLine != null && !this.promptMessageLine.isDisposed()) {
            if ("dateTime".equals(this.getSelectedDataType())) {
                this.promptMessageLine.setText(LABEL_DATETIME_PROMPT);
            } else {
                this.promptMessageLine.setText("");
            }
        }
        this.updateButtons();
    }

    private String validateName() {
        String name = this.nameEditor.getText().trim();
        if (name.length() == 0) {
            return ERROR_MSG_NAME_IS_EMPTY;
        }
        if (!name.equals(this.inputParameter.getName()) && this.inputParameter.getModuleHandle().findParameter(name) != null) {
            return ERROR_MSG_DUPLICATED_NAME;
        }
        return null;
    }

    private void refreshValueTable() {
        if (this.valueTable != null && !this.valueTable.getTable().isDisposed()) {
            this.valueTable.refresh();
            this.updateTableButtons();
        }
    }

    private void deleteRow() {
        int index = this.valueTable.getTable().getSelectionIndex();
        SelectionChoice choice = (SelectionChoice)((IStructuredSelection)this.valueTable.getSelection()).getFirstElement();
        if (this.isDefaultChoice(choice)) {
            this.defaultValue = null;
        }
        this.choiceList.remove(choice);
        this.valueTable.refresh();
        if (--index < 0 && this.valueTable.getTable().getItemCount() > 1) {
            index = 0;
        }
        StructuredSelection selection = null;
        selection = index != -1 ? new StructuredSelection(this.valueTable.getTable().getItem(index).getData()) : StructuredSelection.EMPTY;
        this.valueTable.setSelection((ISelection)selection);
        this.updateTableButtons();
    }

    private boolean getProperty(String key) {
        return (Boolean)this.dirtyProperties.get(key);
    }

    private String format(String string) {
        if (this.canBeNull() && string == null) {
            return LABEL_NULL;
        }
        if (StringUtil.isBlank((String)string) || this.formatCategroy == null) {
            return string;
        }
        try {
            String pattern = this.formatPattern;
            if (this.formatPattern == null) {
                if ("Custom".equals(this.formatCategroy) || "Custom".equals(this.formatCategroy) || "Custom".equals(this.formatCategroy)) {
                    return string;
                }
                pattern = this.formatCategroy;
            }
            if ("dateTime".equals(this.getSelectedDataType())) {
                DateFormatter formatter = new DateFormatter(STANDARD_DATE_TIME_PATTERN);
                Date date = formatter.parse(string);
                formatter.applyPattern(pattern);
                string = formatter.format(date);
            } else if ("float".equals(this.getSelectedDataType())) {
                string = new NumberFormatter(pattern).format(DataTypeUtil.toDouble((Object)string).doubleValue());
            } else if ("decimal".equals(this.getSelectedDataType())) {
                string = new NumberFormatter(pattern).format(DataTypeUtil.toBigDecimal((Object)string));
            } else if ("string".equals(this.getSelectedDataType())) {
                string = new StringFormatter(pattern).format(string);
            }
        }
        catch (BirtException e) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return string;
    }

    private String isValidValue(String value) {
        if (this.canBeNull()) {
            if (value == null || value.length() == 0) {
                return null;
            }
        } else if (value == null || value.length() == 0) {
            return ERROR_MSG_CANNOT_BE_NULL;
        }
        if (this.canBeBlank()) {
            if (StringUtil.isBlank((String)value)) {
                return null;
            }
        } else if (StringUtil.isBlank((String)value)) {
            return ERROR_MSG_CANNOT_BE_BLANK;
        }
        try {
            this.getValue(value);
        }
        catch (BirtException e) {
            return ERROR_MSG_MISMATCH_DATA_TYPE;
        }
        return null;
    }

    private boolean isEqual(String value1, String value2) {
        Object v1 = null;
        Object v2 = null;
        try {
            v1 = this.getValue(value1);
            v2 = this.getValue(value2);
        }
        catch (BirtException e) {
            // empty catch block
        }
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof Double && v2 instanceof Double) {
            return ((Double)v1).compareTo(v2) == 0;
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo(v2) == 0;
        }
        return v1.equals(v2);
    }

    private Object getValue(String value) throws BirtException {
        if ("boolean".equals(this.getSelectedDataType())) {
            return DataTypeUtil.toBoolean((Object)value);
        }
        if ("decimal".equals(this.getSelectedDataType())) {
            return DataTypeUtil.toBigDecimal((Object)value);
        }
        if ("dateTime".equals(this.getSelectedDataType())) {
            return DataTypeUtil.toDate((String)value, (ULocale)ULocale.US);
        }
        if ("float".equals(this.getSelectedDataType())) {
            return DataTypeUtil.toDouble((Object)value);
        }
        return value;
    }

    private IChoiceSet getFormatChoiceSet(String type) {
        IChoiceSet choiceSet = null;
        if ("string".equals(type)) {
            choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("stringFormat");
        } else if ("dateTime".equals(type)) {
            choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("dateTimeFormat");
        } else if ("decimal".equals(type) || "float".equals(type)) {
            choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("numberFormat");
        }
        return choiceSet;
    }

    private void updateFormatField() {
        String previewString;
        String displayFormat;
        String type = this.getSelectedDataType();
        IChoiceSet choiceSet = this.getFormatChoiceSet(this.getSelectedDataType());
        if (choiceSet == null) {
            displayFormat = DesignEngine.getMetaDataDictionary().getChoiceSet("stringFormat").findChoice("Unformatted").getDisplayName();
            previewString = "True";
        } else {
            displayFormat = choiceSet.findChoice(this.formatCategroy).getDisplayName();
            if (this.defaultValue != null) {
                previewString = this.format(this.defaultValue);
            } else {
                if (this.formatCategroy == "Custom" || this.formatCategroy == "Custom" || this.formatCategroy == "Custom") {
                    displayFormat = displayFormat + ": " + this.formatPattern;
                }
                previewString = type.equals("dateTime") ? new DateFormatter("Custom".equals(this.formatCategroy) ? this.formatPattern : this.formatCategroy, ULocale.getDefault()).format(new Date()) : (type.equals("string") ? new StringFormatter(this.formatCategroy != "Custom" ? this.formatCategroy : this.formatPattern, ULocale.getDefault()).format(Messages.getString((String)"ParameterDialog.Label.Sample")) : new NumberFormatter(this.formatCategroy != "Custom" ? this.formatCategroy : this.formatPattern, ULocale.getDefault()).format(1.2345678901234E8));
            }
        }
        this.formatField.setText(displayFormat);
        this.previewLabel.setText(this.convertNullString(previewString));
        this.changeFormat.setEnabled(choiceSet != null);
    }

    private String convertNullString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private boolean containValue(SelectionChoice selectedChoice, String newValue, String property) {
        Iterator iter = this.choiceList.iterator();
        while (iter.hasNext()) {
            SelectionChoice choice = (SelectionChoice)iter.next();
            if (choice == selectedChoice) continue;
            String value = null;
            if (COLUMN_VALUE.equals(property)) {
                value = choice.getValue();
                if (!this.isEqual(value, newValue)) continue;
                return true;
            }
            if (!COLUMN_DISPLAY_TEXT.equals(property)) continue;
            value = choice.getLabel();
            if (value == null) {
                value = choice.getValue();
            }
            if (value == null) {
                value = LABEL_NULL;
            }
            if (!value.equals(newValue)) continue;
            return true;
        }
        return false;
    }

    private void popupFormatBuilder(boolean refresh) {
        String type = this.getSelectedDataType();
        if ("boolean".equals(type)) {
            return;
        }
        int style = "string".equals(type) ? 1 : ("dateTime".equals(type) ? 3 : 2);
        FormatBuilder formatBuilder = new FormatBuilder(style);
        formatBuilder.setInputFormat(this.formatCategroy, this.formatPattern);
        formatBuilder.setPreviewText(this.defaultValue);
        if (formatBuilder.open() == 0) {
            this.formatCategroy = ((String[])formatBuilder.getResult())[0];
            this.formatPattern = ((String[])formatBuilder.getResult())[1];
            this.updateFormatField();
            if (refresh) {
                this.refreshValueTable();
            }
        }
    }

    private boolean canBeBlank() {
        boolean canBeBlank = false;
        if (PARAM_CONTROL_LIST.equals(this.getSelectedControlType()) || "text-box".equals(this.getSelectedControlType())) {
            canBeBlank = this.dirtyProperties.containsKey(CHECKBOX_ALLOW_BLANK) ? ((Boolean)this.dirtyProperties.get(CHECKBOX_ALLOW_BLANK)).booleanValue() : this.inputParameter.allowBlank();
        }
        return canBeBlank;
    }

    private boolean canBeNull() {
        boolean canBeNull = false;
        if (PARAM_CONTROL_LIST.equals(this.getSelectedControlType()) || "text-box".equals(this.getSelectedControlType())) {
            canBeNull = this.dirtyProperties.containsKey(CHECKBOX_ALLOW_NULL) ? ((Boolean)this.dirtyProperties.get(CHECKBOX_ALLOW_NULL)).booleanValue() : this.inputParameter.allowNull();
        }
        return canBeNull;
    }

    private boolean isDefaultChoice(SelectionChoice choice) {
        String choiceValue = choice.getValue();
        String defaultValue = this.convertToStandardFormat(this.defaultValue);
        if (choice != dummyChoice) {
            if (this.canBeNull() && choiceValue == null && defaultValue == null) {
                return true;
            }
            return choiceValue != null && this.isEqual(choiceValue, defaultValue);
        }
        return false;
    }

    private boolean isStatic() {
        return this.staticRadio.getSelection();
    }

    private String convertToStandardFormat(String string) {
        if (string != null && "dateTime".equals(this.getSelectedDataType())) {
            try {
                string = new DateFormatter(STANDARD_DATE_TIME_PATTERN).format(DataTypeUtil.toDate((String)string, (ULocale)ULocale.US));
            }
            catch (BirtException birtException) {
                // empty catch block
            }
        }
        return string;
    }

    private String getExpression(String columnName) {
        Iterator iter = this.columnList.iterator();
        while (iter.hasNext()) {
            ResultSetColumnHandle cachedColumn = (ResultSetColumnHandle)iter.next();
            if (!cachedColumn.getColumnName().equals(columnName)) continue;
            return DEUtil.getExpression((Object)cachedColumn);
        }
        return null;
    }

    private String getColumnName(String expression) {
        Iterator iter = this.columnList.iterator();
        while (iter.hasNext()) {
            ResultSetColumnHandle cachedColumn = (ResultSetColumnHandle)iter.next();
            if (!DEUtil.getExpression((Object)cachedColumn).equals(expression)) continue;
            return cachedColumn.getColumnName();
        }
        return null;
    }

    private String getInputControlDisplayName() {
        String type = this.getInputControlType();
        String displayName = null;
        if (controlType.findChoice(type) != null) {
            displayName = controlType.findChoice(type).getDisplayName();
        } else if (PARAM_CONTROL_COMBO.equals(type)) {
            displayName = DISPLAY_NAME_CONTROL_COMBO;
        } else if (PARAM_CONTROL_LIST.equals(type)) {
            displayName = DISPLAY_NAME_CONTROL_LIST;
        }
        return displayName;
    }
}

