/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class TemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Text templateText;
    public static final String TITLE_LABEL = Messages.getString((String)"report.designer.ui.preferences.template.title");
    public static final String TEMPLATE_IMAGE_LABEL = Messages.getString((String)"report.designer.ui.preferences.template.templatefolder");
    public static final String BROWSER_BUTTON = Messages.getString((String)"report.designer.ui.preferences.template.select");
    public static final String OPEN_DIALOG_TITLE = Messages.getString((String)"report.designer.ui.preferences.template.openDialogTitle");
    public static final String DIRCTORY = "templates";

    public TemplatePreferencePage() {
    }

    public TemplatePreferencePage(String title) {
        super(title);
    }

    public TemplatePreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.Preference_BIRT_Template_ID");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        mainComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        mainComposite.setLayout((Layout)layout);
        Label title = new Label(mainComposite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        title.setLayoutData((Object)data);
        title.setText(TITLE_LABEL);
        new Label(mainComposite, 0);
        new Label(mainComposite, 0);
        this.createBrowse(mainComposite);
        return mainComposite;
    }

    private void createBrowse(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(2));
        label.setText(TEMPLATE_IMAGE_LABEL);
        this.templateText = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.templateText.setLayoutData((Object)data);
        this.templateText.setText(ReportPlugin.getDefault().getTemplatePreference());
        this.templateText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.indexOf(";") < 0;
            }
        });
        new Label(composite, 0);
        Button browser = new Button(composite, 8);
        browser.setText(BROWSER_BUTTON);
        data = new GridData();
        browser.setLayoutData((Object)data);
        browser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                dialog.setText(OPEN_DIALOG_TITLE);
                String folderName = dialog.open();
                if (folderName == null) {
                    return;
                }
                if (!(folderName = folderName.replace('\\', '/')).endsWith("/")) {
                    folderName = folderName + "/";
                }
                TemplatePreferencePage.this.templateText.setText(folderName);
            }
        });
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ReportPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.templateText.setText(ReportPlugin.getDefault().getDefaultTemplatePreference());
    }

    public boolean performOk() {
        ReportPlugin.getDefault().setTemplatePreference(this.templateText.getText());
        return super.performOk();
    }
}

