/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalActionFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributesBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.DefaultPageGenerator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class AttributeView
extends ViewPart
implements INullSelectionListener,
IColleague {
    public static final String ID = "org.eclipse.birt.report.designer.ui.attributes.AttributeView";
    protected List PART_IDS = Arrays.asList("org.eclipse.birt.report.designer.ui.editors.ReportEditor", "org.eclipse.birt.report.designer.ui.editors.LibraryReportEditor", "org.eclipse.birt.report.designer.ui.editors.TemplateEditor", "org.eclipse.ui.views.ContentOutline");
    protected TabFolder tabFolder;
    private ISelection selection;
    private AttributesBuilder builder;
    private IPartListener partListener;
    private int tabIndex = 0;
    private String tabText;
    private RestoreLibraryPropertiesAction restoreLibraryPropertiesAction;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (AttributeView.this.tabFolder != null && !AttributeView.this.changingSelection) {
                AttributeView.this.tabIndex = AttributeView.this.tabFolder.getSelectionIndex();
                if (AttributeView.this.tabFolder.getSelection().length > 0) {
                    AttributeView.this.tabText = AttributeView.this.tabFolder.getSelection()[0].getText();
                }
            }
        }
    };
    private boolean changingSelection = false;

    public SelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    public void resetLocalProperties(int ret) {
        try {
            DEUtil.getGroupElementHandle((List)this.getModelList((ISelection)new StructuredSelection(SessionHandleAdapter.getInstance().getMediator().getCurrentState().getSelectionObject()))).clearLocalProperties();
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void createPartControl(Composite parent) {
        this.addActions();
        this.tabFolder = new TabFolder(parent, 128);
        this.tabFolder.addSelectionListener(this.selectionListener);
        this.builder = new AttributesBuilder();
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part != null && AttributeView.this.PART_IDS.contains(part.getSite().getId())) {
                    AttributeView.this.resetTabFolder(null);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                Control control;
                if (part != null && AttributeView.ID.equals(part.getSite().getId()) && (control = Display.getCurrent().getFocusControl()) != null) {
                    control.notifyListeners(16, null);
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        IWorkbenchPage page = this.getSite().getPage();
        page.addSelectionListener((ISelectionListener)this);
        page.addPartListener(this.partListener);
        this.selection = page.getSelection();
        SessionHandleAdapter.getInstance().getMediator().addGlobalColleague((IColleague)this);
    }

    private void addActions() {
        if (this.restoreLibraryPropertiesAction == null) {
            this.restoreLibraryPropertiesAction = new RestoreLibraryPropertiesAction(this);
        }
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.restoreLibraryPropertiesAction);
    }

    private void showPropertiesPage() {
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() != null) {
            this.handleGlobalAction();
            this.builder.createPages(this.tabFolder, this.getModelList((ISelection)new StructuredSelection(SessionHandleAdapter.getInstance().getMediator().getCurrentState().getSelectionObject())));
            this.selectStickyTab();
            this.setPartName(this.builder.getTypeInfo());
        }
    }

    public void setFocus() {
        this.tabFolder.setFocus();
        if (this.selection != null) {
            this.showPropertiesPage();
            this.selection = null;
        }
    }

    private void resetTabFolder(ISelection selection) {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() != null) {
            this.handleGlobalAction();
            this.builder.createPages(this.tabFolder, this.getModelList(selection));
            this.selectStickyTab();
        }
        this.setPartName(this.builder.getTypeInfo());
    }

    private boolean hasLocalProperties(ISelection selection) {
        GroupElementHandle groupHandle = DEUtil.getGroupElementHandle((List)this.getModelList(selection));
        return groupHandle.hasLocalPropertiesForExtendedElements();
    }

    private void selectStickyTab() {
        TabItem[] items = this.tabFolder.getItems();
        boolean tabFound = false;
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getText().equals(this.tabText)) continue;
            this.tabFolder.setSelection(i);
            tabFound = true;
            break;
        }
        if (!tabFound) {
            if (this.tabIndex > this.tabFolder.getItemCount() - 1) {
                this.tabFolder.setSelection(this.tabFolder.getItemCount() - 1);
            } else {
                this.tabFolder.setSelection(this.tabIndex);
            }
        }
    }

    private List getModelList(ISelection selection) {
        List<Object> list = new ArrayList();
        if (selection == null) {
            return list;
        }
        if (!(selection instanceof StructuredSelection)) {
            return list;
        }
        StructuredSelection structured = (StructuredSelection)selection;
        if (structured.getFirstElement() instanceof ReportElementEditPart) {
            boolean bool = false;
            Iterator it = structured.iterator();
            while (it.hasNext()) {
                ReportElementEditPart object = (ReportElementEditPart)((Object)it.next());
                if (object instanceof DummyEditpart) {
                    list.add(object.getModel());
                    bool = true;
                }
                if (bool) continue;
                list.add(object.getModel());
            }
        } else {
            list = structured.toList();
        }
        return list;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() != null && part != null && !ReportPlugin.getDefault().containIgnoreViewID(part.getSite().getId())) {
            selection = new StructuredSelection();
            this.handleSelectionChanged(selection);
        }
    }

    public void dispose() {
        IWorkbenchPage page = this.getSite().getPage();
        page.removeSelectionListener((ISelectionListener)this);
        page.removePartListener(this.partListener);
        SessionHandleAdapter.getInstance().getMediator().removeGlobalColleague((IColleague)this);
        super.dispose();
    }

    public void init(IViewSite site) throws PartInitException {
        site.setSelectionProvider(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return null;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
        super.init(site);
    }

    private void handleGlobalAction() {
        for (int i = 0; i < GlobalActionFactory.GLOBAL_STACK_ACTIONS.length; ++i) {
            String id = GlobalActionFactory.GLOBAL_STACK_ACTIONS[i];
            this.getViewSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createStackAction(id, SessionHandleAdapter.getInstance().getCommandStack()));
        }
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType())) {
            this.handleSelectionChanged((ISelection)new StructuredSelection(request.getSelectionModelList()));
        }
    }

    public void handleSelectionChanged(ISelection selection) {
        this.selection = null;
        if (!this.tabFolder.isVisible()) {
            this.selection = selection;
            return;
        }
        this.restoreLibraryPropertiesAction.setEnabled(this.hasLocalProperties(selection));
        this.showPropertiesPage();
    }

    static class ModelClassWrapper {
        private GroupElementHandle groupElementHandle;

        public ModelClassWrapper(List modelList) {
            this.groupElementHandle = DEUtil.getMultiSelectionHandle((List)modelList);
        }

        public String getTypeMessage() {
            if (this.groupElementHandle.getElements().get(0) instanceof DesignElementHandle) {
                return DEUtil.getDisplayLabel((Object)((DesignElementHandle)this.groupElementHandle.getElements().get(0)));
            }
            return "";
        }

        public String getExtendsString() {
            DesignElementHandle handle = (DesignElementHandle)this.groupElementHandle.getElements().get(0);
            String name = DEUtil.getDisplayLabel((Object)handle);
            String extendsFrom = handle.getExtends().getDisplayLabel();
            String libName = handle.getExtends().getRoot().getDisplayLabel();
            return Messages.getFormattedString((String)"AttributeView.view.message.Emptypage", (Object[])new Object[]{name, extendsFrom, libName, name});
        }

        public Object getElement() {
            if (this.groupElementHandle != null) {
                return this.groupElementHandle.getElements().get(0);
            }
            return new Object();
        }
    }

    static class MessageAttributePage
    extends Composite {
        private List model;

        public MessageAttributePage(Composite parent, int style, List input) {
            super(parent, style);
            this.model = input;
            this.buildUI();
        }

        private void buildUI() {
            FillLayout layout = new FillLayout();
            this.setLayout((Layout)layout);
            Label label = new Label((Composite)this, 16576);
            String extendsString = "";
            if (this.model.get(0) instanceof ModelClassWrapper) {
                extendsString = ((ModelClassWrapper)this.model.get(0)).getExtendsString();
            }
            label.setText(extendsString);
        }
    }

    static class MessagePageGenerator
    extends DefaultPageGenerator {
        MessagePageGenerator() {
        }

        public void createTabItems(TabFolder tabFolder, List input) {
            super.createTabItems(tabFolder, input);
            Composite pane = new Composite((Composite)tabFolder, 0);
            pane.setLayout((Layout)new FillLayout());
            new MessageAttributePage(pane, 0, input);
            TabItem tabItem = new TabItem(tabFolder, 0);
            if (input.get(0) instanceof ModelClassWrapper) {
                tabItem.setText(((ModelClassWrapper)input.get(0)).getTypeMessage());
            }
            tabItem.setControl((Control)pane);
        }
    }

    public class RestoreLibraryPropertiesAction
    extends Action {
        AttributeView view;

        RestoreLibraryPropertiesAction(AttributeView view) {
            this.view = view;
            this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor("Enable Resotre Properties"));
            this.setEnabled(false);
            this.setToolTipText(Messages.getString((String)"AttributeView.toolbar.tooltip.RestoreLibraryPropertiesAction.RestoreMsg"));
        }

        public void run() {
            MessageDialog prefDialog;
            int ret;
            if (this.view != null && (ret = (prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"AttributeView.dialg.Message.Warning"), null, Messages.getString((String)"AttributeView.dialg.Message.PromptMsg"), 2, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0)).open()) != 2 && ret == 0) {
                AttributeView.this.resetLocalProperties(ret);
                AttributeView.this.showPropertiesPage();
                this.setEnabled(false);
            }
        }
    }
}

