/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BaseAttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BindingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BookMarkExpressionPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BordersPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.CategoryPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.CellPaddingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.FontPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.FormPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.HighlightsPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.HyperLinkPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ItemMarginPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.NamedExpressionsPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.SectionPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.TOCExpressionPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.UserPropertiesPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.VisibilityPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.ICategoryPage;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPage;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ICategoryProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class AttributesUtil {
    public static final String FONT = "font";
    public static final String PADDING = "padding";
    public static final String BORDER = "border";
    public static final String MARGIN = "margin";
    public static final String HYPERLINK = "hyperlink";
    public static final String SECTION = "section";
    public static final String VISIBILITY = "visibility";
    public static final String TOC = "toc";
    public static final String BOOKMARK = "bookmark";
    public static final String USERPROPERTIES = "userproperties";
    public static final String NAMEDEXPRESSIONS = "namedexpressions";
    public static final String EVENTHANDLER = "eventhandler";
    private static Map categoryMap = new HashMap();
    private static Map paneClassMap = new HashMap();

    public static void addCategory(String id, String displayLabelKey, Class pageClass) {
        Assert.isNotNull((Object)id);
        categoryMap.put(id, displayLabelKey);
        paneClassMap.put(id, pageClass);
    }

    public static Object buildGeneralPage(Composite parent, String[] standardCategories, String[] customCategories, PageWrapper[] customPageWrappers) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        form.getBody().setLayout((Layout)new FillLayout());
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        form.setLayoutData((Object)new GridData(1808));
        BaseAttributePage basicPage = new BaseAttributePage(form.getBody(), 0);
        ArrayList<String> categoryList = new ArrayList<String>();
        ArrayList<PageWrapper> paneClassList = new ArrayList<PageWrapper>();
        if (standardCategories == null) {
            if (customCategories != null && customPageWrappers != null) {
                for (int i = 0; i < customCategories.length; ++i) {
                    categoryList.add(customCategories[i]);
                    paneClassList.add(customPageWrappers[i]);
                }
            }
        } else {
            int i;
            int customIndex = 0;
            for (i = 0; i < standardCategories.length; ++i) {
                if (standardCategories[i] == null) {
                    if (customCategories == null || customPageWrappers == null || customCategories.length <= customIndex) continue;
                    categoryList.add(customCategories[customIndex]);
                    paneClassList.add(customPageWrappers[customIndex]);
                    ++customIndex;
                    continue;
                }
                Object cat = categoryMap.get(standardCategories[i]);
                if (!(cat instanceof String)) continue;
                categoryList.add((String)cat);
                paneClassList.add((PageWrapper)paneClassMap.get(standardCategories[i]));
            }
            if (customCategories != null && customPageWrappers != null && customCategories.length > customIndex) {
                for (i = customIndex; i < customCategories.length; ++i) {
                    categoryList.add(customCategories[customIndex]);
                    paneClassList.add(customPageWrappers[customIndex]);
                    ++customIndex;
                }
            }
        }
        String[] cats = categoryList.toArray(new String[0]);
        Object[] clss = paneClassList.toArray(new Object[0]);
        basicPage.setCategoryProvider(new ExtendedCategoryProvider(cats, clss));
        return basicPage;
    }

    public static String getGeneralPageDisplayName() {
        return Messages.getString((String)"CategoryPageGenerator.TabItem.Attributes");
    }

    public static Object buildBindingPage(Composite parent) {
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        BindingPage page = new BindingPage(parent, 0);
        page.setLayoutData(new GridData(1808));
        return page;
    }

    public static String getBindingPageDisplayName() {
        return Messages.getString((String)"TablePageGenerator.TabItem.Binding");
    }

    public static Object buildFilterPage(Composite parent) {
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        FormPage page = new FormPage(parent, 2, new FilterHandleProvider());
        page.setLayoutData(new GridData(1808));
        return page;
    }

    public static String getFilterPageDisplayName() {
        return Messages.getString((String)"TablePageGenerator.TabItem.Filters");
    }

    public static Object buildHighlightPage(Composite parent) {
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        HighlightsPage page = new HighlightsPage(parent, 0);
        page.setLayoutData(new GridData(1808));
        return page;
    }

    public static String getHighlightPageDisplayName() {
        return Messages.getString((String)"TablePageGenerator.TabItem.Highlights");
    }

    public static void setPageInput(Object page, List input) {
        if (page instanceof TabPage) {
            ((TabPage)((Object)page)).setInput(input);
        }
    }

    public static void handleError(Throwable e) {
        ExceptionHandler.handle(e);
    }

    static {
        AttributesUtil.addCategory(FONT, "GridPageGenerator.List.Font", FontPage.class);
        AttributesUtil.addCategory(PADDING, "DataPageGenerator.List.Padding", CellPaddingPage.class);
        AttributesUtil.addCategory(BORDER, "DataPageGenerator.List.Borders", BordersPage.class);
        AttributesUtil.addCategory(MARGIN, "DataPageGenerator.List.Margin", ItemMarginPage.class);
        AttributesUtil.addCategory(HYPERLINK, "DataPageGenerator.List.HyperLink", HyperLinkPage.class);
        AttributesUtil.addCategory(SECTION, "DataPageGenerator.List.Section", SectionPage.class);
        AttributesUtil.addCategory(VISIBILITY, "DataPageGenerator.List.Visibility", VisibilityPage.class);
        AttributesUtil.addCategory(TOC, "DataPageGenerator.List.TOC", TOCExpressionPage.class);
        AttributesUtil.addCategory(BOOKMARK, "DataPageGenerator.List.Bookmark", BookMarkExpressionPage.class);
        AttributesUtil.addCategory(USERPROPERTIES, "ReportPageGenerator.List.UserProperties", UserPropertiesPage.class);
        AttributesUtil.addCategory(NAMEDEXPRESSIONS, "ReportPageGenerator.List.NamedExpressions", NamedExpressionsPage.class);
    }

    public static abstract class PageWrapper {
        TabPage getPage(Composite parent) {
            AttributePage page = new AttributePage(this, parent, 0){
                private final /* synthetic */ PageWrapper this$0;
                {
                    this.this$0 = this$0;
                    super(x0, x1);
                }

                protected void buildUI() {
                    this.this$0.buildContent(this, this.propertiesMap);
                }

                public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
                    super.elementChanged(focus, ev);
                    this.this$0.elementChanged(ev);
                }

                public void setInput(List elements) {
                    super.setInput(elements);
                    this.this$0.setInput(elements);
                }

                public void dispose() {
                    this.this$0.dispose();
                    super.dispose();
                }
            };
            return page;
        }

        public abstract void buildContent(Composite var1, Map var2);

        public void setInput(List elements) {
        }

        public void elementChanged(NotificationEvent ev) {
        }

        public void dispose() {
        }
    }

    static class ExtendedCategoryProvider
    implements ICategoryProvider {
        private String[] categories;
        private Object[] paneObjects;

        ExtendedCategoryProvider(String[] categories, Object[] paneObjects) {
            Assert.isNotNull((Object)categories);
            Assert.isNotNull((Object)paneObjects);
            Assert.isLegal((categories.length == paneObjects.length ? 1 : 0) != 0);
            this.categories = categories;
            this.paneObjects = paneObjects;
        }

        public ICategoryPage[] getCategories() {
            ArrayList<ICategoryPage> pageList = new ArrayList<ICategoryPage>(this.categories.length);
            for (int i = 0; i < this.categories.length; ++i) {
                String displayLabel = Messages.getString((String)this.categories[i]);
                Object pane = this.paneObjects[i];
                if (pane instanceof Class) {
                    pageList.add(new CategoryPage(displayLabel, (Class)pane));
                    continue;
                }
                if (!(pane instanceof PageWrapper)) continue;
                pageList.add(new ICategoryPage(this, displayLabel, pane){
                    private final /* synthetic */ String val$displayLabel;
                    private final /* synthetic */ Object val$pane;
                    private final /* synthetic */ ExtendedCategoryProvider this$0;
                    {
                        this.this$0 = this$0;
                        this.val$displayLabel = val$displayLabel;
                        this.val$pane = val$pane;
                    }

                    public String getDisplayLabel() {
                        return this.val$displayLabel;
                    }

                    public TabPage createControl(Composite parent, int style) {
                        return ((PageWrapper)this.val$pane).getPage(parent);
                    }
                });
            }
            return pageList.toArray(new ICategoryPage[0]);
        }
    }
}

