/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.DbType;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.JdbcSQLSourceViewerConfiguration;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLEditorAction;
import org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLPartitionScanner;
import org.eclipse.birt.report.data.oda.jdbc.ui.provider.IMetaDataProvider;
import org.eclipse.birt.report.data.oda.jdbc.ui.provider.JdbcMetaDataProvider;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DbObject;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Procedure;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ProcedureParameter;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SQLDataSetEditorPage
extends DataSetWizardPage
implements SelectionListener {
    private transient Document doc = null;
    private SourceViewer viewer = null;
    private Hashtable htActions = new Hashtable();
    private TreeItem rootNode = null;
    private Text searchTxt = null;
    private boolean isSchemaSupported = false;
    private boolean expandDbObjectsTree = false;
    private Tree availableDbObjectsTree = null;
    private IMetaDataProvider metaDataProvider = null;
    private JdbcSQLSourceViewerConfiguration sourceViewerConfiguration = null;
    private Image schemaImage;
    private Image tableImage;
    private Image viewImage;
    private Image dataBaseImage;
    private Image columnImage;
    protected ArrayList schemaList;
    protected ArrayList tableList;
    private ComboViewer filterComboViewer = null;
    private Combo schemaCombo = null;
    private Label schemaLabel = null;
    Connection jdbcConnection = null;
    boolean validConnection = false;
    private Button identifierQuoteStringCheckBox = null;
    private static String TABLE_ICON = "org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLDataSetEditorPage.TableIcon";
    private static String VIEW_ICON = "org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLDataSetEditorPage.ViewIcon";
    private static String PAGE_ICON = "org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLDataSetEditorPage.PageIcon";
    private static String SCHEMA_ICON = "org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLDataSetEditorPage.SchemaIcon";
    private static String DATABASE_ICON = "org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLDataSetEditorPage.DbIcon";
    private static String COLUMN_ICON = "org.eclipse.birt.report.data.oda.jdbc.ui.editors.SQLDataSetEditorPage.ColumnIcon";
    private String cachedSearchTxt = "";
    private String formerQueryTxt = "";
    private String cachedDbType = "";
    private int cachedSchemaComboIndex = -1;
    private DataSourceDesign prevDataSourceDesign;
    private DataSetDesign dataSetDesign;
    private static String DEFAULT_MESSAGE = JdbcPlugin.getResourceString("dataset.new.query");

    public SQLDataSetEditorPage(String pageName) {
        super(pageName);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
        Utility.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_JDBCDataset_ID");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    private Control createPageControl(Composite parent) {
        SashForm SashForm2 = new SashForm(parent, 256);
        SashForm2.setLayoutData((Object)new GridData(1808));
        this.initialize();
        this.initJdbcInfo();
        this.createTableSelectionComposite((Composite)SashForm2);
        this.populateAvailableDbObjects();
        this.createTextualQueryComposite((Composite)SashForm2);
        this.setSashFormWeights(SashForm2);
        return SashForm2;
    }

    private void initializeControl() {
        DEFAULT_MESSAGE = JdbcPlugin.getResourceString("dataset.new.query");
        this.setMessage(DEFAULT_MESSAGE, 0);
        this.refreshPage();
        this.prepareUI();
    }

    private void initialize() {
        this.tableImage = JFaceResources.getImage((String)TABLE_ICON);
        this.viewImage = JFaceResources.getImage((String)VIEW_ICON);
        this.schemaImage = JFaceResources.getImage((String)SCHEMA_ICON);
        this.dataBaseImage = JFaceResources.getImage((String)DATABASE_ICON);
        this.columnImage = JFaceResources.getImage((String)COLUMN_ICON);
    }

    protected void initJdbcInfo() {
        this.createMetaDataProvider();
        this.prevDataSourceDesign = this.getDataSetDesign().getDataSourceDesign();
        this.jdbcConnection = this.connectMetadataProvider(this.metaDataProvider, this.prevDataSourceDesign);
        this.validConnection = this.jdbcConnection != null;
        try {
            if (this.jdbcConnection != null) {
                this.isSchemaSupported = this.metaDataProvider.isSchemaSupported();
            }
        }
        catch (Exception e) {
            ExceptionHandler.showException(this.getShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
    }

    private void createTableSelectionComposite(Composite parent) {
        Composite tablescomposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        tablescomposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        tablescomposite.setLayoutData((Object)data);
        Label dataSourceLabel = new Label(tablescomposite, 16384);
        dataSourceLabel.setText(JdbcPlugin.getResourceString("tablepage.label.availableItems"));
        GridData data2 = new GridData();
        dataSourceLabel.setLayoutData((Object)data2);
        this.availableDbObjectsTree = new Tree(tablescomposite, 2050);
        data2 = new GridData(1808);
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        data2.heightHint = 150;
        this.availableDbObjectsTree.setLayoutData((Object)data2);
        this.availableDbObjectsTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SQLDataSetEditorPage.this.populateEventData((TypedEvent)e);
                SQLDataSetEditorPage.this.insertText((String)e.data);
            }
        });
        this.availableDbObjectsTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget.getClass() != null) {
                    this.handleAvailabeTreeSelection();
                }
            }

            private void handleAvailabeTreeSelection() {
                TreeItem[] items = SQLDataSetEditorPage.this.availableDbObjectsTree.getSelection();
                for (int i = 0; i < items.length; ++i) {
                    if (!items[i].getGrayed()) continue;
                    SQLDataSetEditorPage.this.availableDbObjectsTree.setRedraw(false);
                    SQLDataSetEditorPage.this.availableDbObjectsTree.deselectAll();
                    SQLDataSetEditorPage.this.availableDbObjectsTree.setRedraw(true);
                    SQLDataSetEditorPage.this.availableDbObjectsTree.redraw();
                }
            }
        });
        Group selectTableGroup = new Group(tablescomposite, 4);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 3;
        groupLayout.verticalSpacing = 10;
        selectTableGroup.setLayout((Layout)groupLayout);
        GridData data3 = new GridData(768);
        selectTableGroup.setLayoutData((Object)data3);
        this.schemaLabel = new Label((Composite)selectTableGroup, 16384);
        this.schemaLabel.setText(JdbcPlugin.getResourceString("tablepage.label.schema"));
        this.schemaCombo = new Combo((Composite)selectTableGroup, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.schemaCombo.setLayoutData((Object)gd);
        this.enableSchemaComponent(this.isSchemaSupported);
        Label FilterLabel = new Label((Composite)selectTableGroup, 16384);
        FilterLabel.setText(JdbcPlugin.getResourceString("tablepage.label.filter"));
        this.searchTxt = new Text((Composite)selectTableGroup, 2048);
        GridData data4 = new GridData(768);
        data4.horizontalSpan = 2;
        this.searchTxt.setLayoutData((Object)data4);
        Label selectTypeLabel = new Label((Composite)selectTableGroup, 0);
        selectTypeLabel.setText(JdbcPlugin.getResourceString("tablepage.label.selecttype"));
        this.filterComboViewer = new ComboViewer((Composite)selectTableGroup, 8);
        this.setFilterComboContents(this.filterComboViewer);
        this.filterComboViewer.getControl().setLayoutData((Object)new GridData(768));
        Button findButton = new Button((Composite)selectTableGroup, 0);
        findButton.setText(JdbcPlugin.getResourceString("tablepage.button.filter"));
        findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3.access$300(this.this$1).populateAvailableDbObjects();
                    }
                });
            }

            static /* synthetic */ SQLDataSetEditorPage access$300(3 x0) {
                return x0.SQLDataSetEditorPage.this;
            }
        });
        this.setupIdentifierQuoteStringCheckBox(selectTableGroup);
        this.setRootElement();
        this.addDragSupportToTree();
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (design != null && this.doc != null) {
            design.setQueryText(this.doc.get());
        }
        if (!this.formerQueryTxt.equals(design.getQueryText())) {
            this.savePage(design);
            this.formerQueryTxt = design.getQueryText();
        }
        return design;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePage(DataSetDesign design) {
        IConnection conn = null;
        try {
            OdaJdbcDriver jdbcDriver = new OdaJdbcDriver();
            conn = jdbcDriver.getConnection(null);
            Properties prop = new Properties();
            DataSourceDesign dataSourceDesign = design.getDataSourceDesign();
            if (dataSourceDesign != null) {
                prop.put("odaDriverClass", dataSourceDesign.getPublicProperties().getProperty("odaDriverClass") == null ? "" : dataSourceDesign.getPublicProperties().getProperty("odaDriverClass"));
                prop.put("odaURL", dataSourceDesign.getPublicProperties().getProperty("odaURL") == null ? "" : dataSourceDesign.getPublicProperties().getProperty("odaURL"));
                prop.put("odaUser", dataSourceDesign.getPublicProperties().getProperty("odaUser") == null ? "" : dataSourceDesign.getPublicProperties().getProperty("odaUser"));
                prop.put("odaPassword", dataSourceDesign.getPublicProperties().getProperty("odaPassword") == null ? "" : dataSourceDesign.getPublicProperties().getProperty("odaPassword"));
            }
            conn.open(prop);
            IQuery query = conn.newQuery(design.getOdaExtensionDataSetId());
            query.setMaxRows(1);
            query.prepare(design.getQueryText());
            IParameterMetaData paramMetaData = query.getParameterMetaData();
            this.mergeParameterMetaData(design, paramMetaData);
            query.executeQuery();
            IResultSetMetaData metadata = query.getMetaData();
            this.setResultSetMetaData(design, metadata);
            this.closeConnection(conn);
        }
        catch (OdaException e) {
            try {
                design.setResultSets(null);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
        }
    }

    private void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        if (columns != null) {
            ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
            resultSetDefn.setResultSetColumns(columns);
            dataSetDesign.setPrimaryResultSet(resultSetDefn);
            dataSetDesign.getResultSets().setDerivedMetaData(true);
        } else {
            dataSetDesign.setResultSets(null);
        }
    }

    private void mergeParameterMetaData(DataSetDesign dataSetDesign, IParameterMetaData md) throws OdaException {
        DataSetParameters parameters = dataSetDesign.getParameters();
        DataSetParameters dataSetParameter = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)md, (ParameterMode)ParameterMode.IN_LITERAL);
        if (parameters == null || parameters.getParameterDefinitions().size() == 0) {
            if (dataSetParameter != null) {
                Iterator iter = dataSetParameter.getParameterDefinitions().iterator();
                while (iter.hasNext()) {
                    ParameterDefinition defn = (ParameterDefinition)iter.next();
                    this.proccessParamDefn(defn, dataSetParameter);
                }
            }
            dataSetDesign.setParameters(dataSetParameter);
        } else {
            int designParamSize = 0;
            if (dataSetParameter != null) {
                designParamSize = dataSetParameter.getParameterDefinitions().size();
            }
            int dataParamSize = parameters.getParameterDefinitions().size();
            while (designParamSize > dataParamSize) {
                ParameterDefinition defn = (ParameterDefinition)dataSetParameter.getParameterDefinitions().get(dataParamSize);
                this.proccessParamDefn(defn, parameters);
                parameters.getParameterDefinitions().add((Object)defn);
                --designParamSize;
            }
        }
    }

    private void proccessParamDefn(ParameterDefinition defn, DataSetParameters parameters) {
        if (defn.getAttributes().getName() == null || defn.getAttributes().getName().trim().equals("")) {
            defn.getAttributes().setName(this.getUniqueName(parameters));
        }
        if (defn.getAttributes().getNativeDataTypeCode() == 0) {
            defn.getAttributes().setNativeDataTypeCode(1);
        }
    }

    protected final String getUniqueName(DataSetParameters parameters) {
        int n = 1;
        String prefix = "param";
        StringBuffer buf = new StringBuffer();
        while (buf.length() == 0) {
            Iterator iter;
            buf.append(prefix).append(n++);
            if (parameters == null || (iter = parameters.getParameterDefinitions().iterator()) == null) continue;
            while (iter.hasNext() && buf.length() > 0) {
                ParameterDefinition parameter = (ParameterDefinition)iter.next();
                if (!buf.toString().equalsIgnoreCase(parameter.getAttributes().getName())) continue;
                buf.setLength(0);
            }
        }
        return buf.toString();
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    private void setSashFormWeights(SashForm sashForm) {
        int leftWidth = sashForm.getChildren()[0].computeSize((int)-1, (int)-1).x;
        int totalWidth = sashForm.computeSize((int)-1, (int)-1).x;
        if ((double)leftWidth / (double)totalWidth > 0.4) {
            sashForm.setWeights(new int[]{40, 60});
        } else {
            sashForm.setWeights(new int[]{leftWidth, totalWidth - leftWidth});
        }
    }

    private void setupIdentifierQuoteStringCheckBox(Group group) {
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.identifierQuoteStringCheckBox = new Button((Composite)group, 32);
        this.identifierQuoteStringCheckBox.setText(JdbcPlugin.getResourceString("tablepage.button.dnd"));
        this.identifierQuoteStringCheckBox.setSelection(false);
        this.identifierQuoteStringCheckBox.setLayoutData((Object)layoutData);
    }

    private void enableSchemaComponent(boolean b) {
        if (b) {
            this.schemaCombo.setEnabled(true);
            this.schemaLabel.setEnabled(true);
        } else {
            this.schemaCombo.removeAll();
            this.schemaCombo.setEnabled(false);
            this.schemaLabel.setEnabled(false);
        }
    }

    private void setFilterComboContents(ComboViewer filterComboViewer) {
        if (filterComboViewer == null) {
            return;
        }
        ArrayList<DbType> dbTypeList = new ArrayList<DbType>();
        DbType tableType = new DbType(0, JdbcPlugin.getResourceString("tablepage.text.tabletype"));
        DbType viewType = new DbType(1, JdbcPlugin.getResourceString("tablepage.text.viewtype"));
        DbType allType = new DbType(2, JdbcPlugin.getResourceString("tablepage.text.All"));
        DbType procedureType = new DbType(3, JdbcPlugin.getResourceString("tablepage.text.procedure"));
        dbTypeList.add(allType);
        dbTypeList.add(tableType);
        dbTypeList.add(viewType);
        if (this.metaDataProvider.isProcedureSupported()) {
            dbTypeList.add(procedureType);
        }
        filterComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement != null) {
                    return ((ArrayList)inputElement).toArray();
                }
                return new DbType[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        filterComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object inputElement) {
                DbType dbType = (DbType)inputElement;
                return dbType.getName();
            }
        });
        filterComboViewer.setInput(dbTypeList);
        filterComboViewer.getCombo().select(0);
    }

    protected void populateAvailableDbObjects() {
        DataSetDesign dataSetDesign = this.getDataSetDesign();
        DataSourceDesign curDataSourceDesign = dataSetDesign.getDataSourceDesign();
        if (curDataSourceDesign == this.prevDataSourceDesign && (this.cachedSearchTxt == this.searchTxt.getText() || this.cachedSearchTxt != null && this.cachedSearchTxt.equals(this.searchTxt.getText())) && (this.cachedDbType == this.getSelectedDbType() || this.cachedDbType != null && this.cachedDbType.equals(this.getSelectedDbType()))) {
            if (this.schemaList != null && this.schemaList.size() > 0) {
                if (this.cachedSchemaComboIndex == this.schemaCombo.getSelectionIndex()) {
                    return;
                }
            } else {
                return;
            }
        }
        this.RemoveAllAvailableDbObjects();
        this.setRootElement();
        this.setRefreshInfo();
        if (this.isSchemaSupported) {
            this.populateSchemaList();
        } else {
            this.populateTableList();
        }
        this.addFetchDbObjectListener();
        if (this.rootNode != null) {
            this.selectNode(this.rootNode);
        }
    }

    private DataSetDesign getDataSetDesign() {
        if (this.dataSetDesign == null) {
            this.dataSetDesign = this.getInitializationDesign();
        }
        return this.dataSetDesign;
    }

    protected void populateSchemaList() {
        if (this.rootNode != null) {
            this.removeTreeItem(this.rootNode);
        }
        this.getAvailableSchema();
        if (this.schemaCombo.getItemCount() < 1) {
            this.schemaCombo.add(JdbcPlugin.getResourceString("tablepage.text.All"));
            this.schemaCombo.select(0);
            if (this.schemaList != null) {
                Iterator it = this.schemaList.iterator();
                while (it.hasNext()) {
                    this.schemaCombo.add(it.next().toString());
                }
            }
        }
        ArrayList targetSchemaList = new ArrayList();
        ArrayList<DbObject> schemaObjectList = new ArrayList<DbObject>();
        if (this.schemaList != null) {
            int numberOfSchema = 0;
            Preferences preferences = JdbcPlugin.getDefault().getPluginPreferences();
            if (preferences.contains("user_max_num_of_schema")) {
                numberOfSchema = preferences.getInt("user_max_num_of_schema");
            } else {
                numberOfSchema = 20;
                preferences.setValue("user_max_num_of_schema", numberOfSchema);
            }
            this.cachedSchemaComboIndex = this.schemaCombo.getSelectionIndex();
            if (this.schemaCombo.getSelectionIndex() == 0) {
                targetSchemaList = this.schemaList;
            } else {
                targetSchemaList.add(this.schemaCombo.getItem(this.schemaCombo.getSelectionIndex()));
                numberOfSchema = 1;
            }
            for (int i = 0; i < targetSchemaList.size() && i < numberOfSchema; ++i) {
                String schemaName = (String)targetSchemaList.get(i);
                DbObject schemaObj = new DbObject(schemaName, schemaName, 6, this.schemaImage);
                schemaObjectList.add(schemaObj);
            }
            TreeItem[] items = Utility.createTreeItems(this.rootNode, schemaObjectList, 0, this.schemaImage);
            if (items != null && items.length > 0) {
                this.availableDbObjectsTree.showItem(items[0]);
            }
        }
    }

    protected void setRootElement() {
        this.rootNode = new TreeItem(this.availableDbObjectsTree, 0);
        this.rootNode.setImage(this.dataBaseImage);
        DataSourceDesign dataSourceHandle = this.getDataSetDesign().getDataSourceDesign();
        this.rootNode.setText(dataSourceHandle.getName());
    }

    private void RemoveAllAvailableDbObjects() {
        if (this.availableDbObjectsTree != null) {
            this.availableDbObjectsTree.removeAll();
        }
    }

    private void getAvailableSchema() {
        if (this.isSchemaSupported) {
            ResultSet schemas = this.metaDataProvider.getAllSchema();
            this.schemaList = this.createSchemaList(schemas);
        }
    }

    protected void populateTableList(String schemaName, TreeItem schemaTreeItem) {
        String dbtype;
        if (schemaTreeItem != null) {
            this.removeTreeItem(schemaTreeItem);
        }
        String namePattern = null;
        String[] tableType = null;
        this.cachedSearchTxt = this.searchTxt.getText();
        namePattern = this.getTailoredSearchText(this.searchTxt.getText());
        this.cachedDbType = dbtype = this.getSelectedDbType();
        if (dbtype != null && ("TABLE".equalsIgnoreCase(dbtype) || "VIEW".equalsIgnoreCase(dbtype))) {
            tableType = new String[]{dbtype};
        }
        String catalogName = this.metaDataProvider.getCatalog();
        ArrayList<DbObject> tableList = new ArrayList<DbObject>();
        ResultSet tablesRs = null;
        ArrayList procedureRs = null;
        if (schemaName != null && schemaName.trim().length() > 0) {
            if (this.metaDataProvider.isProcedureSupported()) {
                procedureRs = this.metaDataProvider.getAllProcedure(catalogName, schemaName, namePattern);
            }
            if (!"PROCEDURE".equalsIgnoreCase(dbtype)) {
                tablesRs = this.metaDataProvider.getAlltables(catalogName, schemaName, namePattern, tableType);
            }
            tableList = new ArrayList();
            try {
                Image image = this.tableImage;
                if (tablesRs != null) {
                    int numberOfTable;
                    Preferences preferences = JdbcPlugin.getDefault().getPluginPreferences();
                    if (preferences.contains("user_max_num_of_table_each_schema")) {
                        numberOfTable = preferences.getInt("user_max_num_of_table_each_schema");
                    } else {
                        numberOfTable = 100;
                        preferences.setValue("user_max_num_of_table_each_schema", numberOfTable);
                    }
                    int count = 0;
                    while (tablesRs.next() && count < numberOfTable) {
                        String tableName = tablesRs.getString("TABLE_NAME");
                        String type = tablesRs.getString("TABLE_TYPE");
                        if (type.equalsIgnoreCase("SYSTEM TABLE")) continue;
                        int dbType = 2;
                        if (type.equalsIgnoreCase("TABLE")) {
                            image = this.tableImage;
                            dbType = 2;
                        } else if (type.equalsIgnoreCase("VIEW")) {
                            image = this.viewImage;
                            dbType = 3;
                        }
                        DbObject dbObject = new DbObject(this.getTableNameWithSchema(schemaName, tableName), tableName, dbType, image);
                        tableList.add(dbObject);
                        ++count;
                    }
                }
                if (this.needToCreateProcedureNode(dbtype, procedureRs)) {
                    String fullyQualifiedTableName = "STORED PROCEDURES";
                    if (schemaName != null && schemaName.trim().length() > 0) {
                        fullyQualifiedTableName = schemaName + "." + "STORED PROCEDURES";
                    }
                    DbObject dbObject = new DbObject(fullyQualifiedTableName, "STORED PROCEDURES", 4, this.tableImage);
                    tableList.add(dbObject);
                }
                if (schemaTreeItem != null) {
                    TreeItem[] item = Utility.createTreeItems(schemaTreeItem, tableList, 0, null);
                    if (this.expandDbObjectsTree && item != null && item.length > 0) {
                        this.availableDbObjectsTree.showItem(item[0]);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private String getTableNameWithSchema(String schemaName, String tableName) {
        String tableNameWithSchema = tableName;
        if (schemaName != null && schemaName.trim().length() > 0) {
            tableNameWithSchema = schemaName + "." + tableName;
        }
        return tableNameWithSchema;
    }

    protected void populateTableList() {
        String dbtype;
        if (this.rootNode != null) {
            this.removeTreeItem(this.rootNode);
        }
        ResultSet tablesRs = null;
        ArrayList procedureRs = null;
        String catalogName = this.metaDataProvider.getCatalog();
        this.tableList = new ArrayList();
        String namePattern = null;
        String[] tableType = null;
        this.cachedSearchTxt = this.searchTxt.getText();
        namePattern = this.getTailoredSearchText(this.searchTxt.getText());
        this.cachedDbType = dbtype = this.getSelectedDbType();
        if (dbtype != null && ("TABLE".equalsIgnoreCase(dbtype) || "VIEW".equalsIgnoreCase(dbtype))) {
            tableType = new String[]{dbtype};
        }
        if (this.metaDataProvider.isProcedureSupported()) {
            procedureRs = this.metaDataProvider.getAllProcedure(catalogName, null, namePattern);
        }
        if (!"PROCEDURE".equalsIgnoreCase(dbtype)) {
            tablesRs = this.metaDataProvider.getAlltables(catalogName, null, namePattern, tableType);
        }
        if (tablesRs == null && procedureRs == null) {
            return;
        }
        try {
            TreeItem[] item;
            Image image = this.tableImage;
            if (tablesRs != null) {
                int numberOfTable;
                Preferences preferences = JdbcPlugin.getDefault().getPluginPreferences();
                if (preferences.contains("user_max_num_of_table_each_schema")) {
                    numberOfTable = preferences.getInt("user_max_num_of_table_each_schema");
                } else {
                    numberOfTable = 100;
                    preferences.setValue("user_max_num_of_table_each_schema", numberOfTable);
                }
                int count = 0;
                while (tablesRs.next() && count < numberOfTable) {
                    String tableName = tablesRs.getString("TABLE_NAME");
                    String type = tablesRs.getString("TABLE_TYPE");
                    if (type.equalsIgnoreCase("SYSTEM TABLE")) continue;
                    int dbType = 2;
                    if (type.equalsIgnoreCase("TABLE")) {
                        image = this.tableImage;
                        dbType = 2;
                    } else if (type.equalsIgnoreCase("VIEW")) {
                        image = this.viewImage;
                        dbType = 3;
                    }
                    DbObject dbObject = new DbObject(this.getTableNameWithSchema(null, tableName), tableName, dbType, image);
                    this.tableList.add(dbObject);
                    ++count;
                }
            }
            if (this.needToCreateProcedureNode(dbtype, procedureRs)) {
                String fullyQualifiedTableName = "STORED PROCEDURES";
                DbObject dbObject = new DbObject(fullyQualifiedTableName, "STORED PROCEDURES", 4, this.tableImage);
                this.tableList.add(dbObject);
            }
            if ((item = Utility.createTreeItems(this.rootNode, this.tableList, 0, null)) != null && item.length > 0) {
                this.availableDbObjectsTree.showItem(item[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTailoredSearchText(String namePattern) {
        if (namePattern != null) {
            if (namePattern.lastIndexOf(37) == -1) {
                namePattern = namePattern + "%";
            }
        } else {
            namePattern = "%";
        }
        return namePattern;
    }

    private boolean needToCreateProcedureNode(String dbtype, ArrayList procedureRs) {
        return procedureRs != null && procedureRs.size() > 0 && ("ALL".equalsIgnoreCase(dbtype) || "PROCEDURE".equalsIgnoreCase(dbtype));
    }

    protected Connection connectMetadataProvider(IMetaDataProvider metadata, DataSourceDesign dataSourceDesign) {
        return metadata.connect(dataSourceDesign);
    }

    protected void createMetaDataProvider() {
        if (this.metaDataProvider == null) {
            this.metaDataProvider = new JdbcMetaDataProvider(null);
        }
    }

    protected void resetJdbcInfo(DataSourceDesign curDataSourceDesign) {
        if (this.metaDataProvider != null) {
            this.metaDataProvider.closeConnection();
            this.metaDataProvider = null;
            this.createMetaDataProvider();
            this.jdbcConnection = this.connectMetadataProvider(this.metaDataProvider, curDataSourceDesign);
            this.tableList = null;
            this.schemaList = null;
            this.schemaCombo.removeAll();
        }
        try {
            if (this.jdbcConnection != null) {
                this.isSchemaSupported = this.metaDataProvider.isSchemaSupported();
            }
        }
        catch (Exception e) {
            ExceptionHandler.showException(this.getShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
    }

    private void setRefreshInfo() {
        if (this.rootNode == null) {
            return;
        }
        TreeItem item = new TreeItem(this.rootNode, 0);
        item.setText(JdbcPlugin.getResourceString("tablepage.refreshing"));
    }

    private void selectNode(TreeItem item) {
        TreeItem[] selectedItem = new TreeItem[]{item};
        this.availableDbObjectsTree.setSelection(selectedItem);
        this.availableDbObjectsTree.setFocus();
    }

    private ArrayList createSchemaList(ResultSet schemaRs) {
        if (schemaRs == null) {
            return null;
        }
        ArrayList<String> schemas = new ArrayList<String>();
        ArrayList<String> allSchemas = new ArrayList<String>();
        try {
            while (schemaRs.next()) {
                allSchemas.add(schemaRs.getString("TABLE_SCHEM"));
            }
            ResultSet rs = null;
            Iterator it = allSchemas.iterator();
            while (it.hasNext()) {
                String schema = it.next().toString();
                rs = this.metaDataProvider.getAlltables(this.metaDataProvider.getCatalog(), schema, "%", new String[]{"TABLE", "VIEW"});
                boolean hasNonSystemTable = false;
                if (rs != null) {
                    while (rs.next()) {
                        if ("SYSTEM TABLE".equalsIgnoreCase(rs.getString("TABLE_TYPE"))) continue;
                        hasNonSystemTable = true;
                        break;
                    }
                }
                if (!hasNonSystemTable) continue;
                schemas.add(schema);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return schemas;
    }

    private String getSelectedDbType() {
        IStructuredSelection selection = (IStructuredSelection)this.filterComboViewer.getSelection();
        String type = "ALL";
        if (selection != null && selection.getFirstElement() != null) {
            DbType dbType = (DbType)selection.getFirstElement();
            switch (dbType.getType()) {
                case 0: {
                    type = "TABLE";
                    break;
                }
                case 1: {
                    type = "VIEW";
                    break;
                }
                case 3: {
                    type = "PROCEDURE";
                }
            }
        }
        return type;
    }

    protected boolean isSchemaNode(TreeItem item) {
        return item != null && this.isSchemaSupported && item.getParentItem() == this.rootNode;
    }

    private void refreshPage() {
        DataSourceDesign curDataSourceDesign = this.getDataSetDesign().getDataSourceDesign();
        if (curDataSourceDesign != this.prevDataSourceDesign) {
            this.RemoveAllAvailableDbObjects();
            this.resetJdbcInfo(curDataSourceDesign);
            this.enableSchemaComponent(this.isSchemaSupported);
            this.setRootElement();
            this.sourceViewerConfiguration.getContentAssistProcessor().setDataSourceHandle(curDataSourceDesign);
            this.populateAvailableDbObjects();
            this.prevDataSourceDesign = curDataSourceDesign;
        }
    }

    private void addFetchDbObjectListener() {
        this.availableDbObjectsTree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                BusyIndicator.showWhile((Display)item.getDisplay(), (Runnable)new Runnable(this, event){
                    private final /* synthetic */ Event val$event;
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                    }

                    public void run() {
                        7.access$400(this.this$1, this.val$event);
                    }
                });
            }

            private void showTable(Event event) {
                TreeItem item = (TreeItem)event.item;
                if (item == null) {
                    return;
                }
                if (item == SQLDataSetEditorPage.this.rootNode) {
                    return;
                }
                if (SQLDataSetEditorPage.this.isSchemaNode(item)) {
                    SQLDataSetEditorPage.this.populateTableList(item.getText(), item);
                    return;
                }
                String tableName = Utility.getTreeItemsName(item);
                String catalogName = SQLDataSetEditorPage.this.metaDataProvider.getCatalog();
                String schemaName = null;
                String schemaSeparator = ".";
                if (SQLDataSetEditorPage.this.metaDataProvider.isSchemaSupported()) {
                    int index = -1;
                    index = tableName.lastIndexOf(schemaSeparator);
                    if (index != -1) {
                        schemaName = tableName.substring(0, index);
                        tableName = tableName.substring(index + 1);
                    }
                }
                if (item.getData() instanceof DbObject) {
                    DbObject obj = (DbObject)item.getData();
                    if (obj.getType() == 2 || obj.getType() == 3) {
                        ArrayList columnList = SQLDataSetEditorPage.this.metaDataProvider.getColumns(catalogName, schemaName, tableName, null);
                        TreeItem[] items = item.getItems();
                        if (items != null) {
                            for (int i = 0; i < items.length; ++i) {
                                items[i].dispose();
                            }
                        }
                        Utility.createTreeItems(item, columnList, 0, SQLDataSetEditorPage.this.columnImage);
                    } else if (obj.getType() == 4) {
                        ArrayList procedureList = SQLDataSetEditorPage.this.metaDataProvider.getAllProcedure(catalogName, schemaName, SQLDataSetEditorPage.this.getTailoredSearchText(SQLDataSetEditorPage.this.searchTxt.getText()));
                        TreeItem[] items = item.getItems();
                        if (items != null) {
                            for (int i = 0; i < items.length; ++i) {
                                items[i].dispose();
                            }
                        }
                        Utility.createTreeItems(item, procedureList, 0, SQLDataSetEditorPage.this.columnImage);
                    }
                } else if (item.getData() instanceof Procedure) {
                    Procedure obj = (Procedure)item.getData();
                    ArrayList columnList = SQLDataSetEditorPage.this.metaDataProvider.getProcedureColumns(obj.getCatalog(), schemaName, tableName, SQLDataSetEditorPage.this.getTailoredSearchText(null));
                    TreeItem[] items = item.getItems();
                    if (items != null) {
                        for (int i = 0; i < items.length; ++i) {
                            items[i].dispose();
                        }
                    }
                    Utility.createTreeItems(item, columnList, 0, SQLDataSetEditorPage.this.columnImage);
                }
            }

            static /* synthetic */ void access$400(7 x0, Event x1) {
                x0.showTable(x1);
            }
        });
    }

    public void addDragSupportToTree() {
        DragSource dragSource = new DragSource((Control)this.availableDbObjectsTree, 1);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = SQLDataSetEditorPage.this.availableDbObjectsTree.getSelection();
                if (selection.length > 0) {
                    if (selection[0].getData() instanceof DbObject) {
                        if (((DbObject)selection[0].getData()).getType() == 4) {
                            event.doit = false;
                            return;
                        }
                    } else if (selection[0].getData() instanceof ProcedureParameter) {
                        event.doit = false;
                        return;
                    }
                } else if (selection.length <= 0 || selection[0].getData() == null) {
                    event.doit = false;
                    return;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    SQLDataSetEditorPage.this.populateEventData((TypedEvent)event);
                }
            }
        });
    }

    private void populateEventData(TypedEvent event) {
        TreeItem[] selection = this.availableDbObjectsTree.getSelection();
        if (selection.length > 0) {
            String data = "";
            for (int i = 0; i < selection.length; ++i) {
                Object obj = selection[i].getData();
                data = obj instanceof DbObject ? data + this.getDnDString(((DbObject)obj).getName()) : (obj instanceof Procedure ? data + this.getDnDString(((Procedure)obj).getProcedureNameWithSchema()) : data + this.getDnDString(obj));
                data = data + (i != selection.length - 1 ? "," : "");
            }
            event.data = data;
        }
    }

    private Object getDnDString(Object obj) {
        if (!this.identifierQuoteStringCheckBox.getSelection() || !(obj instanceof String)) {
            return obj;
        }
        String identifierQuoteString = "";
        String dndString = (String)obj;
        try {
            identifierQuoteString = this.metaDataProvider.getMetaData().getIdentifierQuoteString();
        }
        catch (SQLException e) {
            identifierQuoteString = " ";
        }
        if (!identifierQuoteString.equals(" ")) {
            if (dndString.indexOf(".") == -1) {
                return identifierQuoteString + dndString + identifierQuoteString;
            }
            String[] str = dndString.split("[.]");
            dndString = "";
            for (int i = 0; i < str.length; ++i) {
                dndString = dndString + identifierQuoteString + str[i] + identifierQuoteString + ".";
            }
            return dndString.substring(0, dndString.lastIndexOf("."));
        }
        return dndString;
    }

    public void addDropSupportToViewer() {
        final StyledText text = this.viewer.getTextWidget();
        DropTarget dropTarget = new DropTarget((Control)text, 17);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                text.setFocus();
                if (event.detail == 16) {
                    event.detail = 1;
                }
                if (event.detail != 1) {
                    event.detail = 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.dragEnter(event);
            }

            public void drop(DropTargetEvent event) {
                if (event.data instanceof String) {
                    SQLDataSetEditorPage.this.insertText((String)event.data);
                }
            }
        });
    }

    private void insertText(String text) {
        if (text == null) {
            return;
        }
        StyledText textWidget = this.viewer.getTextWidget();
        int selectionStart = textWidget.getSelection().x;
        textWidget.insert(text);
        textWidget.setSelection(selectionStart + text.length());
        textWidget.setFocus();
    }

    private int[] getBidiLineSegments(String lineText) {
        int[] seg = null;
        if (lineText != null && lineText.length() > 0 && !new Bidi(lineText, 0).isLeftToRight()) {
            int i;
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] splits = lineText.split("\\p{Punct}");
            for (i = 0; i < splits.length; ++i) {
                if (splits[i].equals("")) continue;
                list.add(splits[i]);
            }
            splits = list.toArray();
            seg = new int[splits.length + 1];
            for (i = 0; i < splits.length; ++i) {
                seg[i + 1] = lineText.indexOf((String)splits[i], seg[i]) + ((String)splits[i]).length();
            }
        }
        return seg;
    }

    private void createTextualQueryComposite(Composite parent) {
        Composite composite = new Composite(parent, 0x2000004);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn lineNumbers = new LineNumberRulerColumn();
        ruler.addDecorator(0, (IVerticalRulerColumn)lineNumbers);
        this.viewer = new SourceViewer(composite, (IVerticalRuler)ruler, 768);
        this.sourceViewerConfiguration = new JdbcSQLSourceViewerConfiguration(this.getDataSetDesign());
        this.viewer.configure((SourceViewerConfiguration)this.sourceViewerConfiguration);
        this.doc = new Document(this.getQueryText());
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(), new String[]{"single_line_comment1", "single_line_comment2", "multi_line_comment", "__dftl_partition_content_type"});
        partitioner.connect((IDocument)this.doc);
        this.doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.viewer.setDocument((IDocument)this.doc);
        this.viewer.getTextWidget().setFont(JFaceResources.getTextFont());
        this.viewer.getTextWidget().addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                event.segments = SQLDataSetEditorPage.this.getBidiLineSegments(event.lineText);
            }
        });
        this.attachMenus(this.viewer);
        GridData data = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)data);
        this.addDropSupportToViewer();
        if (this.isExternalEditorConfigured()) {
            Button btnExternalEditor = new Button(composite, 0);
            btnExternalEditor.setText("Edit with external editor");
            btnExternalEditor.addSelectionListener((SelectionListener)this);
        }
        this.viewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (this.isUndoKeyPress(e)) {
                    SQLDataSetEditorPage.this.viewer.doOperation(1);
                } else if (this.isRedoKeyPress(e)) {
                    SQLDataSetEditorPage.this.viewer.doOperation(2);
                }
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private final boolean isExternalEditorConfigured() {
        return false;
    }

    private final void attachMenus(SourceViewer viewer) {
        StyledText widget = viewer.getTextWidget();
        MenuManager manager = new MenuManager();
        Separator separator = new Separator("undo");
        manager.add((IContributionItem)separator);
        separator = new Separator("copy");
        manager.add((IContributionItem)separator);
        separator = new Separator("select");
        manager.add((IContributionItem)separator);
        manager.appendToGroup("undo", (IAction)this.getAction("undo", viewer, JdbcPlugin.getResourceString("sqleditor.action.undo"), 1));
        manager.appendToGroup("undo", (IAction)this.getAction("redo", viewer, JdbcPlugin.getResourceString("sqleditor.action.redo"), 2));
        manager.appendToGroup("copy", (IAction)this.getAction("cut", viewer, JdbcPlugin.getResourceString("sqleditor.action.cut"), 3));
        manager.appendToGroup("copy", (IAction)this.getAction("copy", viewer, JdbcPlugin.getResourceString("sqleditor.action.copy"), 4));
        manager.appendToGroup("copy", (IAction)this.getAction("paste", viewer, JdbcPlugin.getResourceString("sqleditor.action.paste"), 5));
        manager.appendToGroup("select", (IAction)this.getAction("selectall", viewer, JdbcPlugin.getResourceString("sqleditor.action.selectAll"), 7));
        Menu menu = manager.createContextMenu((Control)widget);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Enumeration elements = SQLDataSetEditorPage.this.htActions.elements();
                while (elements.hasMoreElements()) {
                    SQLEditorAction action = (SQLEditorAction)((Object)elements.nextElement());
                    action.update();
                }
            }
        });
        widget.setMenu(menu);
    }

    private final SQLEditorAction getAction(String id, SourceViewer viewer, String name, int operation) {
        SQLEditorAction action = (SQLEditorAction)((Object)this.htActions.get(id));
        if (action == null) {
            action = new SQLEditorAction(viewer, name, operation);
            this.htActions.put(id, action);
        }
        return action;
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        DEFAULT_MESSAGE = JdbcPlugin.getResourceString("dataset.editor.page.query");
        this.setMessage(DEFAULT_MESSAGE);
        this.refreshPage();
        this.prepareUI();
    }

    private void prepareUI() {
        String[] lines;
        String queryText;
        StyledText styledText = this.viewer.getTextWidget();
        this.formerQueryTxt = queryText = styledText.getText();
        if (queryText != null && queryText.equalsIgnoreCase(this.getQueryPresetTextString()) && (lines = this.getQueryPresetTextArray()) != null && lines.length > 0) {
            styledText.setSelection(lines[0].length() + 1, lines[0].length() + 1);
        }
        styledText.setFocus();
    }

    private String getQueryText() {
        String queryText = this.getDataSetDesign().getQueryText();
        if (queryText != null && queryText.trim().length() > 0) {
            return queryText;
        }
        return this.getQueryPresetTextString();
    }

    private String getQueryPresetTextString() {
        String[] lines = this.getQueryPresetTextArray();
        String result = "";
        if (lines != null && lines.length > 0) {
            for (int i = 0; i < lines.length; ++i) {
                result = result + lines[i] + (i == lines.length - 1 ? " " : " \n");
            }
        }
        return result;
    }

    private String[] getQueryPresetTextArray() {
        String[] lines = this.getDataSetDesign().getOdaExtensionDataSetId().equals("org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet") ? new String[]{"{call procedure-name(arg1,arg2, ...)}"} : new String[]{"select", "from"};
        return lines;
    }

    protected void cleanup() {
        if (this.metaDataProvider != null) {
            this.metaDataProvider.closeConnection();
        }
    }

    public void setDatabaseObjectTreeExpansion(boolean expand) {
        this.expandDbObjectsTree = expand;
    }

    private void removeTreeItem(TreeItem treeItem) {
        if (treeItem.isDisposed()) {
            return;
        }
        TreeItem[] items = treeItem.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].isDisposed()) continue;
            items[i].dispose();
        }
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    static {
        try {
            ImageRegistry reg = JFaceResources.getImageRegistry();
            reg.put(TABLE_ICON, ImageDescriptor.createFromFile((Class)JdbcPlugin.class, (String)"icons/table.gif"));
            reg.put(VIEW_ICON, ImageDescriptor.createFromFile((Class)JdbcPlugin.class, (String)"icons/view.gif"));
            reg.put(PAGE_ICON, ImageDescriptor.createFromFile((Class)JdbcPlugin.class, (String)"icons/create_join_wizard.gif"));
            reg.put(SCHEMA_ICON, ImageDescriptor.createFromFile((Class)JdbcPlugin.class, (String)"icons/schema.gif"));
            reg.put(DATABASE_ICON, ImageDescriptor.createFromFile((Class)JdbcPlugin.class, (String)"icons/data_source.gif"));
            reg.put(COLUMN_ICON, ImageDescriptor.createFromFile((Class)JdbcPlugin.class, (String)"icons/column.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

