/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.dialogs.JdbcDriverManagerDialog;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverInfo;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JDBCDriverInfoManager;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JDBCDriverInformation;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JdbcDriverConfigUtil;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.ui.PlatformUI;

public class JdbcToolKit {
    private static List jdbcDriverInfos = null;
    private static HashMap driverNameMap = null;
    private static Hashtable file2Drivers = null;
    private static final Class DriverClass = Driver.class;

    public static void resetJdbcDriverNames() {
        jdbcDriverInfos = null;
        driverNameMap = null;
        file2Drivers = null;
    }

    public static void getJdbcDriverFromFile(List fileList) {
        URLClassLoader urlClassLoader = JdbcToolKit.createClassLoader(fileList);
        jdbcDriverInfos.addAll(JdbcToolKit.getJDBCDriverInfoList(fileList, urlClassLoader));
    }

    public static List getJdbcDriversFromODADir(String driverName) {
        if (jdbcDriverInfos != null) {
            if (!driverNameMap.containsValue(jdbcDriverInfos.get(0))) {
                jdbcDriverInfos.remove(0);
            }
            if (JdbcDriverManagerDialog.needResetPreferences()) {
                JdbcToolKit.resetPreferences();
                JdbcDriverManagerDialog.resetDriverChangedStatus();
            }
            return jdbcDriverInfos;
        }
        jdbcDriverInfos = new ArrayList();
        driverNameMap = new HashMap();
        file2Drivers = new Hashtable();
        JdbcToolKit.addDriversFromFiles();
        String ODBCJDBCDriverName = "sun.jdbc.odbc.JdbcOdbcDriver";
        JDBCDriverInformation ODBCJDBCInfo = null;
        JDBCDriverInformation[] driverInfos = JDBCDriverInfoManager.getDrivers();
        for (int i = 0; i < driverInfos.length; ++i) {
            JDBCDriverInformation newInfo = driverInfos[i];
            JDBCDriverInformation existing = (JDBCDriverInformation)driverNameMap.get(newInfo.getDriverClassName());
            if (existing == null) {
                if (newInfo.getDriverClassName().equalsIgnoreCase("sun.jdbc.odbc.JdbcOdbcDriver")) {
                    ODBCJDBCInfo = newInfo;
                    continue;
                }
                jdbcDriverInfos.add(newInfo);
                driverNameMap.put(newInfo.getDriverClassName(), newInfo);
                continue;
            }
            existing.setDisplayName(newInfo.getDisplayName());
            existing.setUrlFormat(newInfo.getUrlFormat());
        }
        if (ODBCJDBCInfo != null) {
            jdbcDriverInfos.add(ODBCJDBCInfo);
            driverNameMap.put(ODBCJDBCInfo.getDriverClassName(), ODBCJDBCInfo);
        }
        JdbcToolKit.resetPreferences();
        return jdbcDriverInfos;
    }

    private static void resetPreferences() {
        Map preferenceMap = Utility.getPreferenceStoredMap("JDBC Driver Map");
        Iterator itr = jdbcDriverInfos.iterator();
        while (itr.hasNext()) {
            JDBCDriverInformation info = (JDBCDriverInformation)itr.next();
            Object ob = preferenceMap.get(info.toString());
            if (ob == null) continue;
            DriverInfo driverInfo = (DriverInfo)ob;
            if (driverInfo.getDisplayName() != null && driverInfo.getDisplayName().length() >= 0) {
                info.setDisplayName(driverInfo.getDisplayName());
            }
            if (driverInfo.getUrlTemplate() == null || driverInfo.getUrlTemplate().length() < 0) continue;
            info.setUrlFormat(driverInfo.getUrlTemplate());
        }
    }

    private static List getJDBCDriverInfoList(List fileList, URLClassLoader urlClassLoader) {
        ArrayList<JDBCDriverInformation> driverList = new ArrayList<JDBCDriverInformation>();
        for (int i = 0; i < fileList.size(); ++i) {
            String[] resourceNames = JdbcToolKit.getAllResouceNames((File)fileList.get(i));
            ArrayList<JDBCDriverInformation> subDriverList = new ArrayList<JDBCDriverInformation>();
            for (int j = 0; j < resourceNames.length; ++j) {
                JDBCDriverInformation info;
                Class aClass;
                String resourceName = resourceNames[j];
                if (!resourceName.endsWith(".class") || !JdbcToolKit.isImplementedDriver(aClass = JdbcToolKit.loadClass(urlClassLoader, resourceName = JdbcToolKit.modifyResourceName(resourceName))) || (info = JDBCDriverInformation.newInstance(aClass)) == null) continue;
                driverList.add(info);
                subDriverList.add(info);
            }
            file2Drivers.put(((File)fileList.get(i)).getName(), subDriverList);
        }
        return driverList;
    }

    public static void addToDriverList(List fileList) {
        if (fileList != null && fileList.size() != 0) {
            JdbcToolKit.getJdbcDriverFromFile(fileList);
        }
    }

    public static void removeFromDriverList(List fileList) {
        for (int i = 0; i < fileList.size(); ++i) {
            String fileName = ((File)fileList.get(i)).getName();
            jdbcDriverInfos.removeAll((List)file2Drivers.get(fileName));
            file2Drivers.remove(fileName);
        }
    }

    public static List getDriverList() {
        return jdbcDriverInfos;
    }

    private static String modifyResourceName(String resourceName) {
        resourceName = resourceName.replaceAll("/", ".").substring(0, resourceName.length() - 6);
        return resourceName;
    }

    private static void addDriversFromFiles() {
        List jdbcDriverFiles = JdbcDriverConfigUtil.getDriverFiles();
        if (jdbcDriverFiles == null || jdbcDriverFiles.size() == 0) {
            return;
        }
        URLClassLoader urlClassLoader = JdbcToolKit.createClassLoader(jdbcDriverFiles);
        List driverList = JdbcToolKit.getJDBCDriverInfoList(jdbcDriverFiles, urlClassLoader);
        jdbcDriverInfos.addAll(driverList);
        for (int i = 0; i < driverList.size(); ++i) {
            JDBCDriverInformation info = (JDBCDriverInformation)driverList.get(i);
            driverNameMap.put(info.getDriverClassName(), info);
        }
    }

    private static URLClassLoader createClassLoader(List jdbcDriverFiles) {
        URL[] urlList = new URL[jdbcDriverFiles.size()];
        for (int i = 0; i < jdbcDriverFiles.size(); ++i) {
            try {
                urlList[i] = new URL("file", null, ((File)jdbcDriverFiles.get(i)).getAbsolutePath());
                continue;
            }
            catch (MalformedURLException e) {
                ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
            }
        }
        URLClassLoader urlClassLoader = new URLClassLoader(urlList, ClassLoader.getSystemClassLoader());
        return urlClassLoader;
    }

    private static Class loadClass(URLClassLoader urlClassLoader, String resourceName) {
        Class<?> aClass = null;
        try {
            aClass = urlClassLoader.loadClass(resourceName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aClass;
    }

    private static boolean isImplementedDriver(Class aClass) {
        return aClass != null && JdbcToolKit.implementsSQLDriverClass(aClass) && !Modifier.isAbstract(aClass.getModifiers());
    }

    private static String[] getAllResouceNames(File jarFile) {
        ArrayList<String> jarEntries = new ArrayList<String>();
        try {
            ZipFile zf = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) continue;
                jarEntries.add(ze.getName());
            }
            zf.close();
        }
        catch (IOException e1) {
        }
        catch (Exception e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
        return jarEntries.toArray(new String[jarEntries.size()]);
    }

    private static boolean implementsSQLDriverClass(Class aClass) {
        return DriverClass.isAssignableFrom(aClass);
    }
}

