/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ProfileExtensionProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ConnectAction
implements IObjectActionDelegate,
ISelectionProvider {
    private IConnectionProfile mProfile = null;
    private Shell mShell;

    public static void connectAndRefresh(IConnectionProfile profile, TreeViewer viewer) {
        profile.connect();
        viewer.refresh((Object)profile);
        viewer.setExpandedState((Object)profile, true);
    }

    public static Job connect(IConnectionProfile profile, ITreeContentProvider contentProvider) {
        ConnectionProfile.ConnectJob connectJob = new ConnectionProfile.ConnectJob((ConnectionProfile)profile);
        connectJob.schedule();
        return connectJob;
    }

    public ConnectAction() {
    }

    public ConnectAction(Shell shell) {
        this();
        this.mShell = shell;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.mShell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.mProfile != null) {
            PropertyDialogAction propertyDialogAction = new PropertyDialogAction(this.mShell, (ISelectionProvider)this);
            propertyDialogAction.selectionChanged((IStructuredSelection)this.getSelection());
            if (!this.mProfile.arePropertiesComplete() && propertyDialogAction.isApplicableForSelection()) {
                PreferenceDialog dialog = propertyDialogAction.createDialog();
                String initialPage = this.getInitialPropertyPageID();
                if (initialPage != null) {
                    ((IWorkbenchPreferenceContainer)dialog).openPage(initialPage, null);
                }
                if (dialog.open() == 1) {
                    return;
                }
            }
            this.mProfile.connect(null);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mProfile = null;
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.getFirstElement() instanceof IConnectionProfile) {
            IConnectionProfile profile = (IConnectionProfile)sel.getFirstElement();
            action.setEnabled(!profile.isConnected());
            this.mProfile = profile;
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.mProfile);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    protected String getInitialPropertyPageID() {
        if (!this.mProfile.arePropertiesComplete(this.mProfile.getProviderId())) {
            return ((ConnectionProfileProvider)this.mProfile.getProvider()).getPropertiesPersistenceHook().getConnectionPropertiesPageID();
        }
        Iterator it = this.mProfile.getProfileExtensions().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String extID = (String)entry.getKey();
            if (this.mProfile.arePropertiesComplete(extID)) continue;
            return ((ProfileExtensionProvider)entry.getValue()).getPropertiesPersistenceHook().getConnectionPropertiesPageID();
        }
        return null;
    }
}

