/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.browsers.embedded;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class EmbeddedBrowser {
    private static final String BROWSER_X = "browser.x";
    private static final String BROWSER_Y = "browser.y";
    private static final String BROWSER_WIDTH = "browser.w";
    private static final String BROWSER_HEIGTH = "browser.h";
    private static final String BROWSER_MAXIMIZED = "browser.maximized";
    private Preferences store;
    private static String initialTitle = EmbeddedBrowser.getWindowTitle();
    private Shell shell;
    private Browser browser;
    private int x;
    private int y;
    private int w;
    private int h;
    private long modalRequestTime = 0L;

    public EmbeddedBrowser() {
        this.store = ViewerPlugin.getDefault().getPluginPreferences();
        this.shell = new Shell();
        EmbeddedBrowser.initializeShell(this.shell);
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point point = EmbeddedBrowser.this.shell.getLocation();
                    EmbeddedBrowser.this.x = point.x;
                    EmbeddedBrowser.this.y = point.y;
                }
            }

            public void controlResized(ControlEvent controlEvent) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point point = EmbeddedBrowser.this.shell.getSize();
                    EmbeddedBrowser.this.w = point.x;
                    EmbeddedBrowser.this.h = point.y;
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_X, Integer.toString(EmbeddedBrowser.this.x));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_Y, Integer.toString(EmbeddedBrowser.this.y));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_WIDTH, Integer.toString(EmbeddedBrowser.this.w));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_HEIGTH, Integer.toString(EmbeddedBrowser.this.h));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_MAXIMIZED, new Boolean(EmbeddedBrowser.this.shell.getMaximized()).toString());
            }
        });
        this.browser = new Browser((Composite)this.shell, 0);
        this.initialize(this.shell.getDisplay(), this.browser);
        this.x = this.store.getInt(BROWSER_X);
        this.y = this.store.getInt(BROWSER_Y);
        this.w = this.store.getInt(BROWSER_WIDTH);
        this.h = this.store.getInt(BROWSER_HEIGTH);
        if (this.w == 0 || this.h == 0) {
            this.w = 1024;
            this.h = 768;
            this.x = this.shell.getLocation().x;
            this.y = this.shell.getLocation().y;
        }
        EmbeddedBrowser.setSafeBounds(this.shell, this.x, this.y, this.w, this.h);
        if (this.store.getBoolean(BROWSER_MAXIMIZED)) {
            this.shell.setMaximized(true);
        }
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point point = EmbeddedBrowser.this.shell.getLocation();
                    EmbeddedBrowser.this.x = point.x;
                    EmbeddedBrowser.this.y = point.y;
                }
            }

            public void controlResized(ControlEvent controlEvent) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point point = EmbeddedBrowser.this.shell.getSize();
                    EmbeddedBrowser.this.w = point.x;
                    EmbeddedBrowser.this.h = point.y;
                }
            }
        });
        this.shell.open();
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent locationEvent) {
                EmbeddedBrowser.this.modalRequestTime = 0L;
                if (locationEvent.location != null && locationEvent.location.startsWith("javascript://needModal")) {
                    EmbeddedBrowser.this.modalRequestTime = System.currentTimeMillis();
                }
            }

            public void changed(LocationEvent locationEvent) {
            }
        });
    }

    public EmbeddedBrowser(WindowEvent windowEvent, Shell shell) {
        this.shell = shell == null ? new Shell() : new Shell(shell, 34912);
        EmbeddedBrowser.initializeShell(this.shell);
        Browser browser = new Browser((Composite)this.shell, 0);
        this.initialize(this.shell.getDisplay(), browser);
        windowEvent.browser = browser;
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent locationEvent) {
                EmbeddedBrowser.this.modalRequestTime = 0L;
                if (locationEvent.location != null && locationEvent.location.startsWith("javascript://needModal")) {
                    EmbeddedBrowser.this.modalRequestTime = System.currentTimeMillis();
                }
            }

            public void changed(LocationEvent locationEvent) {
            }
        });
    }

    private static void initializeShell(Shell shell) {
        shell.setText(initialTitle);
        Image[] imageArray = EmbeddedBrowser.createImages();
        if (imageArray != null) {
            shell.setImages(imageArray);
        }
        shell.setLayout((Layout)new FillLayout());
    }

    private void initialize(Display display, Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent windowEvent) {
                if (System.currentTimeMillis() - EmbeddedBrowser.this.modalRequestTime <= 1000L) {
                    new EmbeddedBrowser(windowEvent, EmbeddedBrowser.this.shell);
                } else {
                    new EmbeddedBrowser(windowEvent, null);
                }
            }
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent windowEvent) {
                Browser browser = (Browser)windowEvent.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent windowEvent) {
                Browser browser = (Browser)windowEvent.widget;
                Shell shell = browser.getShell();
                if (windowEvent.location != null) {
                    shell.setLocation(windowEvent.location);
                }
                if (windowEvent.size != null) {
                    Point point = windowEvent.size;
                    shell.setSize(shell.computeSize(point.x, point.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent windowEvent) {
                Browser browser = (Browser)windowEvent.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent titleEvent) {
                if (titleEvent.title != null && titleEvent.title.length() > 0) {
                    Browser browser = (Browser)titleEvent.widget;
                    Shell shell = browser.getShell();
                    shell.setText(titleEvent.title);
                }
            }
        });
    }

    public void displayUrl(String string) {
        this.browser.setUrl(string);
        this.shell.setMinimized(false);
        this.shell.forceActive();
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    private static String getWindowTitle() {
        return ViewerPlugin.getResourceString("viewer.browserTitle");
    }

    private static Image[] createImages() {
        String[] stringArray = EmbeddedBrowser.getProductImageURLs();
        if (stringArray != null) {
            ArrayList<Image> arrayList = new ArrayList<Image>();
            for (int i = 0; i < stringArray.length; ++i) {
                URL uRL;
                block5: {
                    if ("".equals(stringArray[i])) continue;
                    uRL = null;
                    try {
                        uRL = new URL(stringArray[i]);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Bundle bundle;
                        IProduct iProduct = Platform.getProduct();
                        if (iProduct == null || (bundle = iProduct.getDefiningBundle()) == null) break block5;
                        uRL = Platform.find((Bundle)bundle, (IPath)new Path(stringArray[i]));
                    }
                }
                Image image = null;
                if (uRL != null) {
                    image = ImageDescriptor.createFromURL((URL)uRL).createImage();
                }
                if (image == null) continue;
                arrayList.add(image);
            }
            return arrayList.toArray(new Image[arrayList.size()]);
        }
        return new Image[0];
    }

    private static String[] getProductImageURLs() {
        IProduct iProduct = Platform.getProduct();
        if (iProduct != null) {
            String string = iProduct.getProperty("windowImages");
            if (string != null && string.length() > 0) {
                return string.split(",\\s*");
            }
            string = iProduct.getProperty("windowImage");
            if (string != null && string.length() > 0) {
                return new String[]{string};
            }
        }
        return null;
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    private static void setSafeBounds(Shell shell, int n, int n2, int n3, int n4) {
        Rectangle rectangle = shell.getDisplay().getClientArea();
        n3 = Math.min(rectangle.width, n3);
        n4 = Math.min(rectangle.height, n4);
        n = Math.min(n + n3, rectangle.x + rectangle.width) - n3;
        n2 = Math.min(n2 + n4, rectangle.y + rectangle.height) - n4;
        n = Math.max(n, rectangle.x);
        n2 = Math.max(n2, rectangle.y);
        shell.setBounds(n, n2, n3, n4);
    }

    public void setLocation(int n, int n2) {
        this.shell.setLocation(n, n2);
    }

    public void setSize(int n, int n2) {
        this.shell.setSize(this.w, this.h);
    }
}

