/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.utilities.ViewerClassPathHelper;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ViewerClassLoaderWrapper
extends URLClassLoader {
    private static final String BIRTPLUNINID = "org.eclipse.birt";
    private String plugin;
    private Bundle bundle;
    private Set othersBundles = new HashSet();

    public ViewerClassLoaderWrapper(String string) {
        super(new URL[0]);
        this.plugin = string;
        this.bundle = Platform.getBundle((String)string);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        try {
            return this.bundle.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Iterator iterator = this.othersBundles.iterator();
            while (iterator.hasNext()) {
                try {
                    String string2 = (String)iterator.next();
                    Bundle bundle = this.findBundle(string2);
                    if (bundle == null) continue;
                    return bundle.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            throw new ClassNotFoundException("class not fond name is " + string);
        }
    }

    private Bundle findBundle(String string) {
        Bundle[] bundleArray = ViewerPlugin.getDefault().getBundles();
        for (int i = 0; i < bundleArray.length; ++i) {
            if (!bundleArray[i].getSymbolicName().equals(string)) continue;
            return bundleArray[i];
        }
        return null;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        return super.loadClass(string, bl);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        return super.findClass(string);
    }

    public URL getResource(String string) {
        return this.bundle.getResource(string);
    }

    public URL[] getURLs() {
        Set set = this.getPluginClasspath(this.plugin);
        return set.toArray(new URL[set.size()]);
    }

    private Set getPluginClasspath(String string) {
        HashSet hashSet = new HashSet();
        this.addPluginWithPrereqs(string, hashSet);
        HashSet<URL> hashSet2 = new HashSet<URL>();
        this.addScriptClasspath(this.othersBundles);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            try {
                String[] stringArray;
                URL uRL;
                Bundle bundle = Platform.getBundle((String)string2);
                if (bundle == null) continue;
                String string3 = (String)bundle.getHeaders().get("Bundle-ClassPath");
                ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)string3);
                if (manifestElementArray != null) {
                    for (int i = 0; i < manifestElementArray.length; ++i) {
                        String string4 = manifestElementArray[i].getValue();
                        uRL = bundle.getEntry(string4);
                        if (uRL == null) continue;
                        try {
                            hashSet2.add(Platform.asLocalURL((URL)uRL));
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if ((stringArray = ViewerClassPathHelper.getDevClassPath(string)) == null) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    uRL = bundle.getEntry(stringArray[i]);
                    if (uRL == null) continue;
                    try {
                        hashSet2.add(Platform.asLocalURL((URL)uRL));
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (BundleException bundleException) {
            }
        }
        return hashSet2;
    }

    private void addScriptClasspath(Set set) {
        List list = this.getAllBirtPlunInAndDependon();
        this.addItemToSet(set, list);
        list = this.getAllBirtPlunIn();
        int n = list.size();
        list = this.getAllDependonPlunIn(list);
        this.addItemToSet(set, list);
        while (list.size() > 0) {
            list = this.getAllDependonPlunIn(list);
            this.addItemToSet(set, list);
        }
    }

    private void addItemToSet(Set set, List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (set.contains(list.get(i))) continue;
            set.add(list.get(i));
        }
    }

    private List getAllBirtPlunInAndDependon() {
        ArrayList arrayList = new ArrayList();
        Bundle[] bundleArray = ViewerPlugin.getDefault().getBundles();
        for (int i = 0; i < bundleArray.length; ++i) {
            String string = bundleArray[i].getSymbolicName();
            if (string.indexOf(BIRTPLUNINID) < 0 || string.indexOf(this.plugin) >= 0) continue;
            HashSet hashSet = new HashSet();
            this.addPluginWithPrereqs(string, hashSet, this.plugin);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (arrayList.contains(e)) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    private void addPluginWithPrereqs(String string, Set set, String string2) {
        if (set.contains(string)) {
            return;
        }
        String[] stringArray = this.getDirectPrereqs(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(string2) >= 0) continue;
            this.addPluginWithPrereqs(stringArray[i], set);
        }
        set.add(string);
    }

    private List getAllBirtPlunIn() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Bundle[] bundleArray = ViewerPlugin.getDefault().getBundles();
        for (int i = 0; i < bundleArray.length; ++i) {
            String string = bundleArray[i].getSymbolicName();
            if (string.indexOf(BIRTPLUNINID) < 0 || string.indexOf(this.plugin) >= 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private List getAllDependonPlunIn(List list) {
        ArrayList arrayList = new ArrayList();
        Bundle[] bundleArray = ViewerPlugin.getDefault().getBundles();
        block0: for (int i = 0; i < bundleArray.length; ++i) {
            String[] stringArray;
            Bundle bundle = bundleArray[i];
            String string = bundle.getSymbolicName();
            if (list.contains(string) || (stringArray = this.getDirectPrereqs(string)) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                for (int k = 0; k < list.size(); ++k) {
                    if (!stringArray[j].equals(list.get(k)) || string.indexOf(this.plugin) >= 0) continue;
                    list.add(string);
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    private void addPluginWithPrereqs(String string, Set set) {
        if (set.contains(string)) {
            return;
        }
        String[] stringArray = this.getDirectPrereqs(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPluginWithPrereqs(stringArray[i], set);
        }
        set.add(string);
    }

    private String[] getDirectPrereqs(String string) {
        try {
            String string2;
            ManifestElement[] manifestElementArray;
            Bundle bundle = Platform.getBundle((String)string);
            if (bundle != null && (manifestElementArray = ManifestElement.parseHeader((String)"Require-Bundle", (String)(string2 = (String)bundle.getHeaders().get("Require-Bundle")))) != null) {
                String[] stringArray = new String[manifestElementArray.length];
                for (int i = 0; i < manifestElementArray.length; ++i) {
                    stringArray[i] = manifestElementArray[i].getValue();
                }
                return stringArray;
            }
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        return new String[0];
    }
}

