/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers.models;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.MySafeRunnable;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class TemplateDescriptor
implements Comparable {
    public static final String TEMPLATE_TAG = "driverExtension";
    public static final String PLUGIN_LOC = "\\[\\%PLUGIN_LOC\\%\\]";
    private static final String EXTENSION_POINT_NAME = "driverExtension";
    private static final String DRIVERTEMPLATE_ELEMENT_TAG = "driverTemplate";
    private static final String CREATEDEFAULT_TAG = "createDefault";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PARENTCATEGORY_ATTRIBUTE = "parentCategory";
    private static final String JARLIST_ATTRIBUTE = "jarList";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String EMPTYJARLISTOK_TAG = "emptyJarListIsOK";
    private static TemplateDescriptor[] fgDriverTemplateDescriptors;
    private IConfigurationElement fElement;

    protected TemplateDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isNotNull((Object)this.getId(), (String)DriverMgmtMessages.getString("TemplateDescriptor.msg.id_missing"));
        Assert.isNotNull((Object)this.getName(), (String)DriverMgmtMessages.getString("TemplateDescriptor.msg.name_missing"));
    }

    public static TemplateDescriptor[] getDriverTemplateDescriptors() {
        if (fgDriverTemplateDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), "driverExtension");
            fgDriverTemplateDescriptors = TemplateDescriptor.createDriverTemplateDescriptors(elements);
        }
        return fgDriverTemplateDescriptors;
    }

    public static TemplateDescriptor getDriverTemplateDescriptor(String id) {
        if (fgDriverTemplateDescriptors == null) {
            fgDriverTemplateDescriptors = TemplateDescriptor.getDriverTemplateDescriptors();
        }
        for (int i = 0; i < fgDriverTemplateDescriptors.length; ++i) {
            TemplateDescriptor desc = fgDriverTemplateDescriptors[i];
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public CategoryDescriptor getParent() {
        List<CategoryDescriptor> col = Arrays.asList(CategoryDescriptor.getCategoryDescriptors());
        Iterator itr = col.iterator();
        while (itr.hasNext()) {
            CategoryDescriptor cat = (CategoryDescriptor)itr.next();
            if (!cat.getId().equals(this.getParentCategory())) continue;
            return cat;
        }
        return null;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getParentCategory() {
        return this.fElement.getAttribute(PARENTCATEGORY_ATTRIBUTE);
    }

    public String getJarList() {
        String jarList = this.fElement.getAttribute(JARLIST_ATTRIBUTE);
        if (jarList == null) {
            jarList = new String();
        }
        if (!jarList.matches(".*\\[\\%PLUGIN_LOC\\%\\].*")) {
            return jarList;
        }
        try {
            String pluginID = this.fElement.getDeclaringExtension().getNamespaceIdentifier();
            String pluginLoc = FileLocator.resolve((URL)Platform.getBundle((String)pluginID).getEntry("")).getFile();
            if (pluginLoc.charAt(0) == '/') {
                pluginLoc = pluginLoc.substring(1);
            }
            if (pluginLoc.charAt(pluginLoc.length() - 1) == '/') {
                pluginLoc = pluginLoc.substring(0, pluginLoc.length() - 1);
            }
            jarList = jarList.replaceAll(PLUGIN_LOC, pluginLoc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jarList;
    }

    public boolean getCreateDefaultFlag() {
        if (this.fElement.getAttribute(CREATEDEFAULT_TAG) != null) {
            Boolean flag = Boolean.valueOf(this.fElement.getAttribute(CREATEDEFAULT_TAG));
            return flag;
        }
        return true;
    }

    public boolean getEmptyJarListIsOKFlag() {
        if (this.fElement.getAttribute(EMPTYJARLISTOK_TAG) != null) {
            Boolean flag = Boolean.valueOf(this.fElement.getAttribute(EMPTYJARLISTOK_TAG));
            return flag;
        }
        return false;
    }

    public IConfigurationElement getElement() {
        return this.fElement;
    }

    public String getName() {
        String name = this.fElement.getAttribute(NAME_ATTRIBUTE);
        if (name == null && this.getId() != null) {
            name = this.getId();
        }
        return name;
    }

    public IConfigurationElement[] getProperties() {
        IConfigurationElement[] propertyRoot = this.fElement.getChildren("properties");
        if (propertyRoot != null && propertyRoot.length == 1) {
            IConfigurationElement[] childElements = propertyRoot[0].getChildren("property");
            return childElements;
        }
        return new IConfigurationElement[0];
    }

    public String getPropertyValue(String propName) {
        String value = "";
        IConfigurationElement[] props = this.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getAttribute(NAME_ATTRIBUTE) == null) continue;
            String name = props[i].getAttribute(NAME_ATTRIBUTE);
            String tempvalue = props[i].getAttribute(VALUE_ATTRIBUTE);
            if (!name.equals(propName)) continue;
            value = tempvalue;
            break;
        }
        return value;
    }

    public String getPropertyIDFromName(String propName) {
        String id = new String();
        IConfigurationElement[] props = this.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getAttribute(NAME_ATTRIBUTE) == null || !propName.equals(props[i].getAttribute(NAME_ATTRIBUTE))) continue;
            id = props[i].getAttribute(ID_ATTRIBUTE);
            break;
        }
        return id;
    }

    public String getDescription() {
        String description = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (description == null) {
            description = "";
        }
        return description;
    }

    public int compareTo(Object o) {
        if (o instanceof TemplateDescriptor) {
            return Collator.getInstance().compare(this.getName(), ((TemplateDescriptor)o).getName());
        }
        return Integer.MIN_VALUE;
    }

    private static TemplateDescriptor[] createDriverTemplateDescriptors(IConfigurationElement[] elements) {
        ArrayList<TemplateDescriptor> result = new ArrayList<TemplateDescriptor>(5);
        HashSet<String> descIds = new HashSet<String>(5);
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            if (!DRIVERTEMPLATE_ELEMENT_TAG.equals(element.getName())) continue;
            TemplateDescriptor[] desc = new TemplateDescriptor[1];
            SafeRunner.run((ISafeRunnable)new MySafeRunnable(desc, element));
            if (desc[0] == null || descIds.contains(desc[0].getId())) continue;
            result.add(desc[0]);
            descIds.add(desc[0].getId());
        }
        Collections.sort(result);
        return result.toArray(new TemplateDescriptor[result.size()]);
    }

    public boolean hasVisibleProperties() {
        IConfigurationElement[] templateprops = this.getProperties();
        if (templateprops != null && templateprops.length > 0) {
            for (int i = 0; i < templateprops.length; ++i) {
                IConfigurationElement prop = templateprops[i];
                String visible = prop.getAttribute("visible");
                if (visible != null && !visible.equals("true")) continue;
                return true;
            }
        }
        return false;
    }
}

