/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.ProfileExtensionProvider;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;
import org.eclipse.datatools.connectivity.internal.security.SecurityManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConnectionProfileMgmt {
    public static final String FILENAME = "ServerProfiles.dat";
    public static final String DEFAULTCP_FILENAME = "WorkSpaceServerConnectionProfiles.xml";
    private static final String ROOTNAME = "DataTools.ServerProfiles";
    private static final String CHILDNAME = "profile";
    private static final String PROFILENAME = "name";
    private static final String PROFILEDESC = "desc";
    private static final String PROFILEAUTOCONNECT = "autoconnect";
    private static final String PROFILEPARENT = "parent";
    private static final String PROVIDERID = "providerID";
    private static final String PROPKEYS = "keys";
    private static final String PROPPREFIX = "prop_";
    private static final String PROPDELIM = " ";
    private static final String LITERAL_YES = "Yes";
    private static final String LITERAL_NO = "No";
    private static final String PROFILEID = "id";
    private static IPath storageLocation = null;
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder documentBuilder = null;
    private static TransformerFactory transFactory = null;
    private static Transformer transformer = null;

    private static String keysToString(Enumeration enu) {
        StringBuffer keys = new StringBuffer();
        while (enu.hasMoreElements()) {
            keys.append((String)enu.nextElement() + PROPDELIM);
        }
        return keys.toString();
    }

    private static Properties keysToProperties(Element elem) {
        Properties props = new Properties();
        String keys = elem.getAttribute(PROPKEYS);
        StringTokenizer st = new StringTokenizer(keys, PROPDELIM);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            String value = elem.getAttribute(PROPPREFIX + key);
            props.put(key, value);
        }
        return props;
    }

    public static void saveCPs(IConnectionProfile[] cps) throws CoreException {
        ConnectionProfileMgmt.saveCPs(cps, ConnectionProfileMgmt.getStorageLocation().append(FILENAME).toFile(), SecurityManager.getInstance().getDefaultCipherProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCPs(IConnectionProfile[] cps, File file, ICipherProvider isp) throws CoreException {
        try {
            Document document = ConnectionProfileMgmt.getDocumentBuilder().newDocument();
            Element rootElement = document.createElement(ROOTNAME);
            document.appendChild(rootElement);
            if (!file.exists()) {
                file.createNewFile();
            }
            OutputStream out = null;
            FileOutputStream outs = new FileOutputStream(file);
            Writer writer = null;
            try {
                out = isp != null ? new CipherOutputStream(outs, isp.createEncryptionCipher()) : outs;
                OutputStreamWriter outw = new OutputStreamWriter(out, "UTF-8");
                writer = new BufferedWriter(outw);
                for (int i = 0; i < cps.length; ++i) {
                    String value;
                    String key;
                    Properties props;
                    Element child;
                    IConnectionProfile cp;
                    block20: {
                        cp = cps[i];
                        child = document.createElement(CHILDNAME);
                        child.setAttribute(PROFILENAME, cp.getName());
                        child.setAttribute(PROFILEDESC, cp.getDescription());
                        child.setAttribute(PROFILEAUTOCONNECT, ((ConnectionProfile)cp).isAutoConnect() ? LITERAL_YES : LITERAL_NO);
                        child.setAttribute(PROVIDERID, cp.getProviderId());
                        child.setAttribute(PROFILEID, cp.getInstanceID());
                        props = cp.getBaseProperties();
                        try {
                            props = ((ConnectionProfileProvider)cp.getProvider()).getPropertiesPersistenceHook().getPersitentProperties(props);
                        }
                        catch (Exception e) {
                            if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block20;
                            System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookSaveError", new Object[]{cp.getName(), cp.getProviderId()}));
                            e.printStackTrace();
                        }
                    }
                    String keys = ConnectionProfileMgmt.keysToString(props.keys());
                    child.setAttribute(PROPKEYS, keys);
                    Enumeration<?> enu = props.propertyNames();
                    while (enu.hasMoreElements()) {
                        key = (String)enu.nextElement();
                        value = props.getProperty(key);
                        child.setAttribute(PROPPREFIX + key, value);
                    }
                    Iterator it = ((ConnectionProfile)cp).getPropertiesMap().entrySet().iterator();
                    while (it.hasNext()) {
                        Element extraChild;
                        block21: {
                            Map.Entry me = it.next();
                            String type = (String)me.getKey();
                            props = (Properties)me.getValue();
                            extraChild = document.createElement(type);
                            if (props == null) {
                                props = new Properties();
                            }
                            try {
                                ProfileExtensionProvider pep = (ProfileExtensionProvider)cp.getProfileExtensions().get(type);
                                if (pep != null) {
                                    props = pep.getPropertiesPersistenceHook().getPersitentProperties(new Properties(props));
                                }
                            }
                            catch (Exception e) {
                                if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block21;
                                System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookSaveError", new Object[]{cp.getName(), type}));
                                e.printStackTrace();
                            }
                        }
                        keys = ConnectionProfileMgmt.keysToString(props.keys());
                        extraChild.setAttribute(PROPKEYS, keys);
                        Enumeration<?> enu2 = props.propertyNames();
                        while (enu2.hasMoreElements()) {
                            key = (String)enu2.nextElement();
                            value = props.getProperty(key);
                            extraChild.setAttribute(PROPPREFIX + key, value);
                        }
                        child.appendChild(extraChild);
                    }
                    rootElement.appendChild(child);
                }
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(outw);
                ConnectionProfileMgmt.getTransformer().transform(source, result);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (DOMException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
        catch (GeneralSecurityException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.saveprofilesxml"), (Throwable)e));
        }
    }

    public static IConnectionProfile loadCP(String cpName) throws CoreException {
        try {
            IPath path = ConnectionProfileMgmt.getStorageLocation();
            path = path.append(FILENAME);
            File file = path.toFile();
            if (!file.exists()) {
                return null;
            }
            FileInputStream is = new FileInputStream(file);
            InputSource source = new InputSource(is);
            source.setEncoding("UTF-8");
            Document document = ConnectionProfileMgmt.getDocumentBuilder().parse(source);
            ConnectionProfile cp = null;
            NodeList nl = document.getElementsByTagName(CHILDNAME);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element elem;
                Node node = nl.item(i);
                if (!(node instanceof Element) || !(elem = (Element)node).getAttribute(PROFILENAME).equals(cpName) || (cp = new ConnectionProfile(elem.getAttribute(PROFILENAME), elem.getAttribute(PROFILEDESC), elem.getAttribute(PROVIDERID), elem.getAttribute(PROFILEPARENT), LITERAL_YES.equals(elem.getAttribute(PROFILEAUTOCONNECT)), elem.getAttribute(PROFILEID))).getProvider() == null) continue;
                cp.setBaseProperties(ConnectionProfileMgmt.keysToProperties(elem));
                if (cp.getProfileExtensions().size() == 0) break;
                Iterator it = cp.getProfileExtensions().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    String type = (String)me.getKey();
                    Node xmlExtraChild = elem.getFirstChild();
                    if (xmlExtraChild == null || !elem.getTagName().equals(type)) continue;
                    cp.setProperties(type, ConnectionProfileMgmt.keysToProperties((Element)xmlExtraChild));
                }
                break;
            }
            cp.setCreated();
            return cp;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
    }

    public static IConnectionProfile[] loadCPs(File file) throws CoreException {
        try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            String line = reader.readLine();
            reader.close();
            isr.close();
            fis.close();
            if (line.matches(".*xml.*")) {
                return ConnectionProfileMgmt.loadCPs(file, null);
            }
            return ConnectionProfileMgmt.loadCPs(file, SecurityManager.getInstance().getDefaultCipherProvider());
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
    }

    public static IConnectionProfile[] loadCPs(File file, ICipherProvider isp) throws CoreException {
        IConnectionProfile[] retVal = null;
        try {
            if (!file.exists()) {
                return new IConnectionProfile[0];
            }
            FileInputStream fis = new FileInputStream(file);
            InputStream is = isp != null ? new CipherInputStream(fis, isp.createDecryptionCipher()) : fis;
            InputSource source = new InputSource(is);
            source.setEncoding("UTF-8");
            Document document = ConnectionProfileMgmt.getDocumentBuilder().parse(source);
            ArrayList<ConnectionProfile> cps = new ArrayList<ConnectionProfile>();
            boolean updatedIDs = false;
            NodeList nl = document.getElementsByTagName(CHILDNAME);
            for (int i = 0; i < nl.getLength(); ++i) {
                Properties props;
                Element elem;
                ConnectionProfile cp;
                block13: {
                    Node node = nl.item(i);
                    if (!(node instanceof Element) || (cp = new ConnectionProfile((elem = (Element)node).getAttribute(PROFILENAME), elem.getAttribute(PROFILEDESC), elem.getAttribute(PROVIDERID), elem.getAttribute(PROFILEPARENT), LITERAL_YES.equals(elem.getAttribute(PROFILEAUTOCONNECT)), elem.getAttribute(PROFILEID))).getProvider() == null) continue;
                    props = ConnectionProfileMgmt.keysToProperties(elem);
                    try {
                        props = ((ConnectionProfileProvider)cp.getProvider()).getPropertiesPersistenceHook().populateTransientProperties(props);
                    }
                    catch (Exception e) {
                        if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block13;
                        System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), cp.getProviderId()}));
                        e.printStackTrace();
                    }
                }
                cp.setBaseProperties(props);
                NodeList extElements = elem.getChildNodes();
                int extCount = extElements.getLength();
                for (int extIndex = 0; extIndex < extCount; ++extIndex) {
                    String type;
                    block14: {
                        Node extNode = extElements.item(extIndex);
                        if (extNode.getNodeType() != 1) continue;
                        type = extNode.getNodeName();
                        props = ConnectionProfileMgmt.keysToProperties((Element)extNode);
                        try {
                            ProfileExtensionProvider pep = (ProfileExtensionProvider)cp.getProfileExtensions().get(type);
                            if (pep != null) {
                                props = pep.getPropertiesPersistenceHook().populateTransientProperties(props);
                            }
                        }
                        catch (Exception e) {
                            if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block14;
                            System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHookLoadError", new Object[]{cp.getName(), type}));
                            e.printStackTrace();
                        }
                    }
                    cp.setProperties(type, props);
                }
                cp.setCreated();
                cps.add(cp);
                updatedIDs = elem.getAttribute(PROFILEID) == null || updatedIDs;
            }
            retVal = cps.toArray(new IConnectionProfile[cps.size()]);
            if (updatedIDs) {
                ConnectionProfileMgmt.saveCPs(retVal, file, isp);
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (GeneralSecurityException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.datatools.connectivity", -1, ConnectivityPlugin.getDefault().getResourceString("error.loadprofilesxml"), (Throwable)e));
        }
        return retVal;
    }

    public static IPath getStorageLocation() {
        if (storageLocation == null) {
            return ConnectivityPlugin.getDefault().getStateLocation();
        }
        return storageLocation;
    }

    public static void setStorageLocation(IPath location) {
        storageLocation = location;
    }

    private static DocumentBuilder getDocumentBuilder() {
        if (documentBuilder == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return documentBuilder;
    }

    private static Transformer getTransformer() {
        if (transformer == null) {
            transFactory = TransformerFactory.newInstance();
            try {
                transformer = transFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return transformer;
    }
}

