/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConfigurationType;
import org.eclipse.datatools.connectivity.IConnectionFactoryProvider;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.IPropertiesPersistenceHook;
import org.eclipse.datatools.connectivity.PropertiesPersistenceHook;
import org.eclipse.datatools.connectivity.internal.ConnectionFactoryProvider;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.ProfileExtensionProvider;

public class ConnectionProfileProvider
implements IConnectionProfileProvider {
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_FILE_EXTENSION = "fileExtension";
    public static final String ATTR_CATEGORY = "category";
    public static final String ATTR_CONFIGURATION_TYPE = "configurationType";
    public static final String ATTR_MAINTAINCONNECTION = "maintainConnection";
    public static final String ATTR_PING_FACTORY = "pingFactory";
    public static final String ATTR_PROPERTIES_PERSISTENCE_HOOK = "propertiesPersistenceHook";
    static final IPropertiesPersistenceHook DEFAULT_PROPERTIES_PERSISTENCE_HOOK = new PropertiesPersistenceHook();
    private String mName;
    private String mId;
    private URL mIconURL;
    private String mCategory;
    private String mConfigType;
    private String mFileExt;
    private Map mProfileExtensions;
    private Map mConnectionFactories;
    private IConfigurationElement mElement;
    private boolean mMaintainConnection = true;
    private IPropertiesPersistenceHook mPropertiesPersistenceHook;

    public ConnectionProfileProvider(IConfigurationElement element) {
        this.init(element);
    }

    public String getName() {
        return this.mName;
    }

    public String getId() {
        return this.mId;
    }

    public URL getIconURL() {
        return this.mIconURL;
    }

    public IConnectionFactoryProvider getConnectionFactory(String type) {
        return (IConnectionFactoryProvider)this.mConnectionFactories.get(type);
    }

    public Map getConnectionFactories() {
        return new HashMap(this.mConnectionFactories);
    }

    public IConfigurationType getConfigurationType() {
        return ConnectionProfileManager.getInstance().getConfigurationType(this.mConfigType);
    }

    public ICategory getCategory() {
        return ConnectionProfileManager.getInstance().getCategory(this.mCategory);
    }

    public String getFileExtension() {
        return this.mFileExt;
    }

    public Map getProfileExtensions() {
        return new HashMap(this.mProfileExtensions);
    }

    public void addProfileExtension(IConfigurationElement element) {
        ProfileExtensionProvider pe = new ProfileExtensionProvider(element);
        Assert.isTrue((!this.mProfileExtensions.containsKey(pe.getId()) ? 1 : 0) != 0, (String)ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile", new Object[]{element.toString()}));
        this.mProfileExtensions.put(pe.getId(), pe);
    }

    public void addConnectionFactory(IConfigurationElement element) {
        this.addConnectionFactory(new ConnectionFactoryProvider(element));
    }

    public void addConnectionFactory(IConnectionFactoryProvider icfap) {
        Assert.isTrue((!this.mConnectionFactories.containsKey(icfap.getId()) ? 1 : 0) != 0, (String)ConnectivityPlugin.getDefault().getResourceString("assert.invalid.profile.duplicateFactory", new Object[]{icfap.getId().toString()}));
        this.mConnectionFactories.put(icfap.getId(), icfap);
    }

    public IPropertiesPersistenceHook getPropertiesPersistenceHook() {
        this.loadPropertiesPersistenceHook();
        return this.mPropertiesPersistenceHook;
    }

    private void loadPropertiesPersistenceHook() {
        block4: {
            if (this.mPropertiesPersistenceHook == null) {
                this.mPropertiesPersistenceHook = DEFAULT_PROPERTIES_PERSISTENCE_HOOK;
                if (this.mElement.getAttribute(ATTR_PROPERTIES_PERSISTENCE_HOOK) != null) {
                    try {
                        this.mPropertiesPersistenceHook = (IPropertiesPersistenceHook)this.mElement.createExecutableExtension(ATTR_PROPERTIES_PERSISTENCE_HOOK);
                    }
                    catch (CoreException e) {
                        if (!ConnectionProfileManager.DEBUG_CONNECTION_PROFILE_EXTENSION) break block4;
                        System.err.println(ConnectivityPlugin.getDefault().getResourceString("trace.error.propertiesPersistenceHook", new Object[]{this.mId, this.mId}));
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void init(IConfigurationElement element) {
        Assert.isTrue((boolean)"connectionProfile".equals(element.getName()));
        this.mProfileExtensions = new HashMap();
        this.mConnectionFactories = new HashMap();
        this.mElement = element;
        this.mId = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mFileExt = element.getAttribute(ATTR_FILE_EXTENSION);
        this.mCategory = element.getAttribute(ATTR_CATEGORY);
        this.mConfigType = element.getAttribute(ATTR_CONFIGURATION_TYPE);
        if (element.getAttribute(ATTR_MAINTAINCONNECTION) != null) {
            this.mMaintainConnection = new Boolean(element.getAttribute(ATTR_MAINTAINCONNECTION));
        }
        if (element.getAttribute(ATTR_PING_FACTORY) != null) {
            ConnectionFactoryProvider cfp = new ConnectionFactoryProvider(element, "org.eclipse.datatools.connectivity.connectionFactory.pingFactory", this.getId(), ATTR_PING_FACTORY);
            this.mConnectionFactories.put("org.eclipse.datatools.connectivity.connectionFactory.pingFactory", cfp);
        }
        this.processIconAttr();
    }

    private void processIconAttr() {
        String iconAttr = this.mElement.getAttribute(ATTR_ICON);
        if (iconAttr != null && iconAttr.trim().length() > 0) {
            this.mIconURL = Platform.getBundle((String)this.mElement.getContributor().getName()).getEntry(iconAttr);
        }
    }

    public boolean needsMaintainConnection() {
        return this.mMaintainConnection;
    }
}

