/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.ViewsTreeProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class LibraryExplorerProvider
extends ViewsTreeProvider {
    FileFilter filter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.isFile() && pathname.getPath().toLowerCase().endsWith(".rptlibrary");
        }
    };

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof File) {
            File file = (File)parentElement;
            if (!file.exists()) {
                return new Object[]{Messages.getString((String)"LibraryExplorerProvider.FolderNotExist")};
            }
            if (file.isDirectory()) {
                File[] children = file.listFiles(this.filter);
                ArrayList<File> folderList = new ArrayList<File>();
                ArrayList<File> fileList = new ArrayList<File>();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i].isDirectory()) {
                        folderList.add(children[i]);
                        continue;
                    }
                    fileList.add(children[i]);
                }
                folderList.addAll(fileList);
                return folderList.toArray();
            }
            try {
                return super.getChildren((Object)SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(file.getAbsolutePath()));
            }
            catch (DesignFileException designFileException) {
                // empty catch block
            }
        }
        return super.getChildren(parentElement);
    }

    public Image getImage(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            if (file.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return ReportPlatformUIImages.getImage((String)"Library");
        }
        return super.getImage(element);
    }

    public Object getParent(Object element) {
        if (element instanceof File) {
            return ((File)element).getParentFile();
        }
        return super.getParent(element);
    }

    public String getText(Object element) {
        if (element instanceof File) {
            return ((File)element).getName();
        }
        if (element instanceof String) {
            return element.toString();
        }
        return super.getText(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof File) {
            if (((File)element).isDirectory()) {
                return ((File)element).list() != null && ((File)element).list().length > 0;
            }
            return true;
        }
        return super.hasChildren(element);
    }
}

