/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.ILibraryProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ItemSorter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerContextMenuProvider;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerProvider;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.dnd.LibraryDragListener;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.BackingStoreException;

public class LibraryExplorerTreeViewPage
extends LibraryExplorerViewPage
implements IValidationListener,
IEclipsePreferences.IPreferenceChangeListener {
    private ILibraryProvider libraryProvider;
    private IEclipsePreferences reportPreferenceNode;
    private TreeViewer treeViewer;

    protected TreeViewer createTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.configTreeViewer();
        this.initPage();
        return this.treeViewer;
    }

    protected void configTreeViewer() {
        LibraryExplorerProvider provider = new LibraryExplorerProvider();
        this.treeViewer.setContentProvider((IContentProvider)provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.refreshRoot();
        int ops = 1;
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        this.treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new LibraryDragListener((StructuredViewer)this.treeViewer));
        this.treeViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    LibraryExplorerTreeViewPage.this.treeViewer.refresh();
                }
            }
        });
    }

    protected void initPage() {
        this.createContextMenus();
        this.treeViewer.setSorter((ViewerSorter)new ItemSorter());
        this.treeViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == LibraryExplorerTreeViewPage.this.treeViewer.getTree()) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = LibraryExplorerTreeViewPage.this.treeViewer.getTree().getItem(pt);
                    LibraryExplorerTreeViewPage.this.treeViewer.getTree().setToolTipText(LibraryExplorerTreeViewPage.this.getTooltip(item));
                }
            }
        });
        IEclipsePreferences rootNode = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance");
        String reportName = ReportPlugin.getDefault().getBundle().getSymbolicName();
        try {
            if (rootNode.nodeExists(reportName)) {
                this.reportPreferenceNode = (IEclipsePreferences)rootNode.node(reportName);
                this.reportPreferenceNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            }
        }
        catch (BackingStoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void createContextMenus() {
        LibraryExplorerContextMenuProvider menuManager = new LibraryExplorerContextMenuProvider(this.treeViewer);
        Menu menu = menuManager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu("#Pop up", (MenuManager)menuManager, this.getSite().getSelectionProvider());
    }

    private String getTooltip(TreeItem item) {
        if (item != null) {
            Object object = item.getData();
            if (object instanceof DataSourceHandle || object instanceof DataSetHandle || object instanceof ParameterHandle || object instanceof ParameterGroupHandle || object instanceof EmbeddedImageHandle) {
                return Messages.getString((String)"LibraryExplorerTreeViewPage.toolTips.DragAndDrapOutline");
            }
            if (object instanceof ReportItemHandle || object instanceof ThemeHandle) {
                return Messages.getString((String)"LibraryExplorerTreeViewPage.toolTips.DragAndDrapLayout");
            }
            if (object instanceof LibraryHandle) {
                return ((LibraryHandle)object).getFileName();
            }
        }
        return "";
    }

    public void dispose() {
        if (this.reportPreferenceNode != null) {
            this.reportPreferenceNode.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        super.dispose();
    }

    protected boolean isDisposed() {
        Control ctrl = this.getControl();
        return ctrl == null || ctrl.isDisposed();
    }

    public void elementValidated(DesignElementHandle targetElement, ValidationEvent ev) {
        this.treeViewer.refresh();
    }

    private void refreshRoot() {
        this.treeViewer.setInput((Object)new File(ReportPlugin.getDefault().getResourcePreference()));
    }

    public void setLibraryProvider(ILibraryProvider provider) {
        this.libraryProvider = provider;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("org.eclipse.birt.report.designer.ui.preferences.resourcestore".equals(event.getKey())) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    LibraryExplorerTreeViewPage.this.refreshRoot();
                }
            });
        }
    }
}

