/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public class RemoveLibraryAction
extends Action {
    private StructuredViewer viewer;
    private static final String ACTION_TEXT = Messages.getString((String)"RemoveLibraryAction.Text");

    public RemoveLibraryAction(StructuredViewer viewer) {
        super(ACTION_TEXT);
        this.viewer = viewer;
    }

    public boolean isEnabled() {
        LibraryHandle library = this.getSelectedLibrary();
        if (library != null) {
            String[] libraries = ReportPlugin.getDefault().getLibraryPreference();
            return this.isArrayContain(libraries, library.getFileName());
        }
        return false;
    }

    public void run() {
        LibraryHandle library = this.getSelectedLibrary();
        if (library != null) {
            String[] libraries = ReportPlugin.getDefault().getLibraryPreference();
            ReportPlugin.getDefault().setLibraryPreference(this.removeElementFromArray(libraries, library.getFileName()));
        }
    }

    private LibraryHandle getSelectedLibrary() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null && selection.size() == 1 && selection.getFirstElement() instanceof LibraryHandle) {
            return (LibraryHandle)selection.getFirstElement();
        }
        return null;
    }

    private String[] removeElementFromArray(String[] array, String element) {
        ArrayList<String> result = new ArrayList<String>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i].equals(element)) continue;
            result.add(array[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean isArrayContain(String[] array, String element) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(element)) continue;
            return true;
        }
        return false;
    }
}

