/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import javax.transaction.xa.Xid;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.ConnectionRequestInterface;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConfiguration;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.Request;
import org.apache.derby.client.net.Typdef;

public class NetConnectionRequest
extends Request
implements ConnectionRequestInterface {
    NetConnectionRequest(NetAgent netAgent, CcsidManager ccsidManager, int n) {
        super(netAgent, ccsidManager, n);
    }

    void writeExchangeServerAttributes(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws SqlException {
        this.buildEXCSAT(string, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    void writeDummyExchangeServerAttributes() throws SqlException {
        this.buildDummyEXCSAT();
    }

    void writeAccessSecurity(int n, String string, byte[] byArray) throws SqlException {
        this.buildACCSEC(n, string, byArray);
    }

    void writeSecurityCheck(int n, String string, String string2, String string3, byte[] byArray, byte[] byArray2) throws SqlException {
        this.buildSECCHK(n, string, string2, string3, byArray, byArray2);
    }

    void writeAccessDatabase(String string, boolean bl, byte[] byArray, byte[] byArray2, Typdef typdef) throws SqlException {
        this.buildACCRDB(string, bl, byArray, byArray2, typdef);
    }

    public void writeCommitSubstitute(NetConnection netConnection) throws SqlException {
        this.buildDummyEXCSAT();
    }

    public void writeLocalCommit(NetConnection netConnection) throws SqlException {
        this.buildRDBCMM();
    }

    public void writeLocalRollback(NetConnection netConnection) throws SqlException {
        this.buildRDBRLLBCK();
    }

    public void writeLocalXAStart(NetConnection netConnection) throws SqlException {
    }

    public void writeLocalXACommit(NetConnection netConnection) throws SqlException {
    }

    public void writeLocalXARollback(NetConnection netConnection) throws SqlException {
    }

    public void writeXaStartUnitOfWork(NetConnection netConnection) throws SqlException {
    }

    public void writeXaEndUnitOfWork(NetConnection netConnection) throws SqlException {
    }

    protected void writeXaPrepare(NetConnection netConnection) throws SqlException {
    }

    protected void writeXaCommit(NetConnection netConnection, Xid xid) throws SqlException {
    }

    protected void writeXaRollback(NetConnection netConnection, Xid xid) throws SqlException {
    }

    protected void writeXaRecover(NetConnection netConnection, int n) throws SqlException {
    }

    protected void writeXaForget(NetConnection netConnection, Xid xid) throws SqlException {
    }

    public void writeSYNCType(int n, int n2) {
        this.writeScalar1Byte(n, n2);
    }

    public void writeForget(int n, int n2) {
    }

    public void writeReleaseConversation(int n, int n2) {
    }

    void writeNullXID(int n) {
    }

    void writeXID(int n, Xid xid) throws SqlException {
    }

    void writeXAFlags(int n, int n2) {
    }

    void buildRDBCMM() throws SqlException {
        this.createCommand();
        this.writeLengthCodePoint(4, 8206);
    }

    void buildRDBRLLBCK() throws SqlException {
        this.createCommand();
        this.writeLengthCodePoint(4, 8207);
    }

    void buildEXCSAT(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4161);
        this.buildEXTNAM(string);
        this.buildSRVNAM("Derby");
        this.buildSRVRLSLV();
        this.buildMGRLVLLS(n, n2, n3, n4, n7, n8, n9);
        this.buildSRVCLSNM();
        this.updateLengthBytes();
    }

    void buildDummyEXCSAT() throws SqlException {
        this.createCommand();
        this.markLengthBytes(4161);
        this.updateLengthBytes();
    }

    void buildACCSEC(int n, String string, byte[] byArray) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4205);
        this.buildSECMEC(n);
        this.buildRDBNAM(string);
        if (byArray != null) {
            this.buildSECTKN(byArray);
        }
        this.updateLengthBytes();
    }

    void buildSECCHK(int n, String string, String string2, String string3, byte[] byArray, byte[] byArray2) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4206);
        this.buildSECMEC(n);
        this.buildRDBNAM(string);
        if (string2 != null) {
            this.buildUSRID(string2);
        }
        if (string3 != null) {
            this.buildPASSWORD(string3);
        }
        if (byArray != null) {
            this.buildSECTKN(byArray);
        }
        if (byArray2 != null) {
            this.buildSECTKN(byArray2);
        }
        this.updateLengthBytes();
    }

    void buildACCRDB(String string, boolean bl, byte[] byArray, byte[] byArray2, Typdef typdef) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8193);
        this.buildRDBNAM(string);
        this.buildRDBACCCL();
        this.buildPRDID();
        this.buildPRDDTA(byArray2);
        this.buildTYPDEFNAM(typdef.getTypdefnam());
        if (byArray == null) {
            this.netAgent_.netConnection_.constructCrrtkn();
        }
        this.buildCRRTKN(this.netAgent_.netConnection_.crrtkn_);
        this.buildTYPDEFOVR(typdef.isCcsidSbcSet(), typdef.getCcsidSbc(), typdef.isCcsidDbcSet(), typdef.getCcsidDbc(), typdef.isCcsidMbcSet(), typdef.getCcsidMbc());
        this.buildRDBALWUPD(bl);
        this.updateLengthBytes();
    }

    void buildSYNCCTLMigrate() throws SqlException {
    }

    void buildSYNCCTLCommit(int n, Xid xid) throws SqlException {
    }

    void buildSYNCCTLRollback(int n) throws SqlException {
    }

    private void buildEXTNAM(String string) throws SqlException {
        int n = Utils.min(string.length(), 255);
        this.writeScalarString(4446, string.substring(0, n));
    }

    private void buildSRVNAM(String string) throws SqlException {
        int n = Utils.min(string.length(), 255);
        this.writeScalarString(4461, string.substring(0, n));
    }

    private void buildSRVRLSLV() throws SqlException {
        this.writeScalarString(4442, NetConfiguration.SRVRLSLV);
    }

    private void buildSRVCLSNM() throws SqlException {
        this.writeScalarString(4423, "QDERBY/JVM");
    }

    private void buildSECMEC(int n) throws SqlException {
        this.writeScalar2Bytes(4514, n);
    }

    private void buildRDBNAM(String string) throws SqlException {
        int n = string.length();
        if (n <= 18) {
            this.writeScalarPaddedString(8464, string, 18);
        } else if (n <= 255) {
            this.writeScalarString(8464, string);
        } else {
            throw new SqlException(this.netAgent_.logWriter_, "Length of the Relational Database Name, " + string + ", exceeds maximum size allowed for PROTOCOL Connection.");
        }
    }

    private void buildSECTKN(byte[] byArray) throws SqlException {
        if (byArray.length > 32763) {
            throw new SqlException(this.netAgent_.logWriter_, "bug check: sectkn too long");
        }
        this.writeScalarBytes(4572, byArray);
    }

    private void buildUSRID(String string) throws SqlException {
        int n = string.length();
        if (n == 0 || n > 255) {
            throw new SqlException(this.netAgent_.logWriter_, "userid length, " + n + ", is not allowed.");
        }
        this.writeScalarString(4512, string);
    }

    private void buildPASSWORD(String string) throws SqlException {
        int n = string.length();
        if (n == 0 || n > 255) {
            throw new SqlException(this.netAgent_.logWriter_, "password length, " + n + ", is not allowed.");
        }
        if (this.netAgent_.logWriter_ != null) {
            this.passwordIncluded_ = true;
            this.passwordStart_ = this.offset_ + 4;
            this.passwordLength_ = n;
        }
        this.writeScalarString(4513, string);
    }

    private void buildRDBACCCL() throws SqlException {
        this.writeScalar2Bytes(8463, 9223);
    }

    private void buildPRDID() throws SqlException {
        this.writeScalarString(4398, NetConfiguration.PRDID);
    }

    private void buildPRDDTA(byte[] byArray) throws SqlException {
        int n = (byArray[0] & 0xFF) + 1;
        this.writeScalarBytes(8452, byArray, 0, n);
    }

    private void buildTYPDEFNAM(String string) throws SqlException {
        this.writeScalarString(47, string);
    }

    void buildTYPDEFOVR(boolean bl, int n, boolean bl2, int n2, boolean bl3, int n3) throws SqlException {
        this.markLengthBytes(53);
        if (bl) {
            this.writeScalar2Bytes(4508, n);
        }
        if (bl2) {
            this.writeScalar2Bytes(4509, n2);
        }
        if (bl3) {
            this.writeScalar2Bytes(4510, n3);
        }
        this.updateLengthBytes();
    }

    private void buildMGRLVLLS(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws SqlException {
        this.markLengthBytes(5124);
        this.writeCodePoint4Bytes(5123, n);
        this.writeCodePoint4Bytes(9223, n2);
        this.writeCodePoint4Bytes(9231, n3);
        this.writeCodePoint4Bytes(5184, n4);
        if (this.netAgent_.netConnection_.isXAConnection()) {
            if (n5 != 0) {
                this.writeCodePoint4Bytes(7169, n5);
            }
            if (n6 != 0) {
                this.writeCodePoint4Bytes(5312, n6);
            }
            if (n7 != 0) {
                this.writeCodePoint4Bytes(5313, n7);
            }
        }
        this.updateLengthBytes();
    }

    private void buildCRRTKN(byte[] byArray) throws SqlException {
        this.writeScalarBytes(8501, byArray);
    }

    private void buildRDBALWUPD(boolean bl) throws SqlException {
        if (bl) {
            this.writeScalar1Byte(8474, -16);
        }
    }
}

