/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.TemplateDataSetHandle;
import org.eclipse.birt.report.model.api.TemplateParameterDefinitionHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.TranslationHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CustomMsgException;
import org.eclipse.birt.report.model.api.core.AttributeEvent;
import org.eclipse.birt.report.model.api.core.DisposeEvent;
import org.eclipse.birt.report.model.api.core.IAttributeListener;
import org.eclipse.birt.report.model.api.core.IDisposeListener;
import org.eclipse.birt.report.model.api.core.IModuleModel;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.PropertyValueValidationUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.birt.report.model.command.CustomMsgCommand;
import org.eclipse.birt.report.model.command.LibraryCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.ShiftLibraryCommand;
import org.eclipse.birt.report.model.command.ThemeCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.IModuleNameSpace;
import org.eclipse.birt.report.model.css.StyleSheetLoader;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public abstract class ModuleHandle
extends DesignElementHandle
implements IModuleModel {
    protected boolean isInitialized = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ModuleHandle(Module module) {
        super(module);
    }

    public void addConfigVariable(ConfigVariable configVar) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("configVars");
        if (configVar != null && StringUtil.isBlank(configVar.getName())) {
            throw new PropertyValueException(this.getElement(), propDefn, (Object)configVar, "Error.PropertyValueException.INVALID_VALUE");
        }
        if (configVar != null && this.findConfigVariable(configVar.getName()) != null) {
            throw new PropertyValueException(this.getElement(), propDefn, (Object)configVar.getName(), "Error.PropertyValueException.VALUE_EXISTS");
        }
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.addItem(new CachedMemberRef(propDefn), configVar);
    }

    public void addImage(EmbeddedImage image) throws SemanticException {
        PropertyCommand cmd = new PropertyCommand(this.module, this.getElement());
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("images");
        cmd.addItem(new CachedMemberRef(propDefn), image);
    }

    public void rename(EmbeddedImage image) {
        this.module.rename(image);
    }

    private void addParameters(ArrayList list, ParameterGroupHandle handle) {
        SlotHandle h = handle.getParameters();
        Iterator it = h.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
    }

    public void addTranslation(String resourceKey, String locale, String text) throws CustomMsgException {
        CustomMsgCommand command = new CustomMsgCommand(this.getModule());
        command.addTranslation(resourceKey, locale, text);
    }

    public void addValidationListener(IValidationListener listener) {
        this.getModule().addValidationListener(listener);
    }

    public void checkReport() {
        this.module.semanticCheck(this.module);
        ValidationEvent event = new ValidationEvent(this.module, null, this.getErrorList());
        this.module.broadcastValidationEvent(this.module, event);
    }

    public void close() {
        this.module.close();
        DisposeEvent event = new DisposeEvent(this.module);
        this.module.broadcastDisposeEvent(event);
    }

    List getFilteredStructureList(String propName, String nameMember) {
        ArrayList<StructureHandle> list = new ArrayList<StructureHandle>();
        PropertyHandle propHandle = this.getPropertyHandle(propName);
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        HashSet<String> names = new HashSet<String>();
        Iterator iter = propHandle.iterator();
        while (iter.hasNext()) {
            StructureHandle s = (StructureHandle)iter.next();
            String nameValue = (String)s.getProperty(nameMember);
            if (names.contains(nameValue)) continue;
            list.add(s);
            names.add(nameValue);
        }
        List theLibraries = this.getLibraries();
        int size = theLibraries.size();
        for (int i = 0; i < size; ++i) {
            LibraryHandle library = (LibraryHandle)theLibraries.get(i);
            if (!library.isValid()) continue;
            iter = library.getFilteredStructureList(propName, nameMember).iterator();
            while (iter.hasNext()) {
                StructureHandle s = (StructureHandle)iter.next();
                String nameValue = (String)s.getProperty(nameMember);
                if (names.contains(nameValue)) continue;
                list.add(s);
                names.add(nameValue);
            }
        }
        return list;
    }

    List getStructureList(String propName) {
        ArrayList list = new ArrayList();
        List tempList = this.getNativeStructureList(propName);
        if (!tempList.isEmpty()) {
            list.addAll(tempList);
        }
        List theLibraries = this.getLibraries();
        int size = theLibraries.size();
        for (int i = 0; i < size; ++i) {
            LibraryHandle library = (LibraryHandle)theLibraries.get(i);
            tempList = library.getNativeStructureList(propName);
            if (tempList.isEmpty()) continue;
            list.addAll(tempList);
        }
        return list;
    }

    List getNativeStructureList(String propName) {
        ArrayList<StructureHandle> list = new ArrayList<StructureHandle>();
        PropertyHandle propHandle = this.getPropertyHandle(propName);
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        Iterator iter = propHandle.iterator();
        while (iter.hasNext()) {
            StructureHandle s = (StructureHandle)iter.next();
            list.add(s);
        }
        return list;
    }

    public Iterator configVariablesIterator() {
        return this.getFilteredStructureList("configVars", "name").iterator();
    }

    public Iterator customColorsIterator() {
        return this.getStructureList("colorPalette").iterator();
    }

    public void dropConfigVariable(String name) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("configVars");
        int posn = this.findConfigVariablePos(name);
        if (posn < 0) {
            throw new PropertyValueException(this.getElement(), propHandle.getPropertyDefn(), (Object)name, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        propHandle.removeItem(posn);
    }

    public void dropImage(List images) throws SemanticException {
        if (images == null) {
            return;
        }
        PropertyHandle propHandle = this.getPropertyHandle("images");
        propHandle.removeItems(images);
    }

    public void dropImage(String name) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("images");
        int pos = this.findImagePos(name);
        if (pos < 0) {
            throw new PropertyValueException(this.getElement(), propHandle.getPropertyDefn(), (Object)name, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        propHandle.removeItem(pos);
    }

    public void dropTranslation(String resourceKey, String locale) throws CustomMsgException {
        CustomMsgCommand command = new CustomMsgCommand(this.getModule());
        command.dropTranslation(resourceKey, locale);
    }

    private int findConfigVariablePos(String name) {
        List configVars = (List)this.module.getLocalProperty(this.module, "configVars");
        if (configVars == null) {
            return -1;
        }
        int i = 0;
        Iterator iter = configVars.iterator();
        while (iter.hasNext()) {
            ConfigVariable var = (ConfigVariable)iter.next();
            if (var.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public DataSetHandle findDataSet(String name) {
        DesignElement element = this.module.findDataSet(name);
        if (!(element instanceof DataSet)) {
            return null;
        }
        return (DataSetHandle)element.getHandle(element.getRoot());
    }

    public JointDataSetHandle findJointDataSet(String name) {
        DesignElement element = this.module.findDataSet(name);
        if (!(element instanceof JointDataSet)) {
            return null;
        }
        return (JointDataSetHandle)element.getHandle(element.getRoot());
    }

    public TemplateDataSetHandle findTemplateDataSet(String name) {
        DesignElement element = this.module.findDataSet(name);
        if (element == null) {
            return null;
        }
        return (TemplateDataSetHandle)element.getHandle(element.getRoot());
    }

    public DataSourceHandle findDataSource(String name) {
        DesignElement element = this.module.findDataSource(name);
        if (element == null) {
            return null;
        }
        return (DataSourceHandle)element.getHandle(element.getRoot());
    }

    public DesignElementHandle findElement(String name) {
        DesignElement element = this.module.findElement(name);
        if (element == null) {
            return null;
        }
        return element.getHandle(element.getRoot());
    }

    public EmbeddedImage findImage(String name) {
        return this.module.findImage(name);
    }

    public ConfigVariable findConfigVariable(String name) {
        return this.module.findConfigVariabel(name);
    }

    public CustomColor findColor(String name) {
        return this.module.findColor(name);
    }

    private int findImagePos(String name) {
        List images = (List)this.module.getLocalProperty(this.module, "images");
        int i = 0;
        Iterator iter = images.iterator();
        while (iter.hasNext()) {
            EmbeddedImage image = (EmbeddedImage)iter.next();
            if (image.getName() != null && image.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public MasterPageHandle findMasterPage(String name) {
        DesignElement element = this.module.findPage(name);
        if (element == null) {
            return null;
        }
        return (MasterPageHandle)element.getHandle(element.getRoot());
    }

    public ParameterHandle findParameter(String name) {
        DesignElement element = this.module.findParameter(name);
        if (element == null) {
            return null;
        }
        return (ParameterHandle)element.getHandle(element.getRoot());
    }

    public SharedStyleHandle findNativeStyle(String name) {
        StyleElement style = this.module.findNativeStyle(name);
        if (style == null) {
            return null;
        }
        return (SharedStyleHandle)style.getHandle(this.module);
    }

    public SharedStyleHandle findStyle(String name) {
        StyleElement style = this.module.findStyle(name);
        if (style == null) {
            return null;
        }
        return (SharedStyleHandle)style.getHandle(style.getRoot());
    }

    public ThemeHandle findTheme(String name) {
        Theme theme = this.module.findTheme(name);
        if (theme == null) {
            return null;
        }
        return (ThemeHandle)theme.getHandle(theme.getRoot());
    }

    public String getAuthor() {
        return this.getStringProperty("author");
    }

    public CommandStack getCommandStack() {
        return this.module.getActivityStack();
    }

    public SlotHandle getComponents() {
        return this.getSlot(5);
    }

    public String getCreatedBy() {
        return this.getStringProperty("createdBy");
    }

    public SlotHandle getDataSets() {
        return this.getSlot(3);
    }

    public SlotHandle getDataSources() {
        return this.getSlot(2);
    }

    public String getDefaultUnits() {
        return this.module.getUnits();
    }

    public void setDefaultUnits(String units) throws SemanticException {
        this.setStringProperty("units", units);
    }

    public DesignElement getElement() {
        return this.module;
    }

    public DesignElementHandle getElementByID(long id) {
        DesignElement element = this.module.getElementByID(id);
        if (element == null) {
            return null;
        }
        return element.getHandle(this.module);
    }

    public List getErrorList() {
        return this.module.getErrorList();
    }

    public String getFileName() {
        return this.module.getFileName();
    }

    public List getFlattenParameters() {
        ArrayList<DesignElementHandle> list = new ArrayList<DesignElementHandle>();
        SlotHandle slotHandle = this.getParameters();
        Iterator it = slotHandle.iterator();
        while (it.hasNext()) {
            DesignElementHandle h = (DesignElementHandle)it.next();
            list.add(h);
            if (!(h instanceof ParameterGroupHandle)) continue;
            this.addParameters(list, (ParameterGroupHandle)h);
        }
        DesignElementHandle.doSort(list);
        return list;
    }

    public String getHelpGuide() {
        return this.getStringProperty("helpGuide");
    }

    public String getInitialize() {
        return this.getStringProperty("initialize");
    }

    public SlotHandle getMasterPages() {
        return this.getSlot(4);
    }

    public String getMessage(String resourceKey) {
        return this.getModule().getMessage(resourceKey);
    }

    public String getMessage(String resourceKey, Locale locale) {
        return this.getModule().getMessage(resourceKey, ULocale.forLocale((Locale)locale));
    }

    public String getMessage(String resourceKey, ULocale locale) {
        return this.getModule().getMessage(resourceKey, locale);
    }

    public List getMessageKeys() {
        return this.getModule().getMessageKeys();
    }

    public SlotHandle getParameters() {
        return this.getSlot(1);
    }

    public CascadingParameterGroupHandle findCascadingParameterGroup(String groupName) {
        DesignElement element = this.module.findParameter(groupName);
        if (element == null || !(element instanceof CascadingParameterGroup)) {
            return null;
        }
        return (CascadingParameterGroupHandle)element.getHandle(element.getRoot());
    }

    public SlotHandle getStyles() {
        return this.getSlot(0);
    }

    public TranslationHandle getTranslation(String resourceKey, String locale) {
        Translation translation = this.module.findTranslation(resourceKey, locale);
        if (translation != null) {
            return translation.handle(this.getModule());
        }
        return null;
    }

    public String[] getTranslationKeys() {
        return this.getModule().getTranslationResourceKeys();
    }

    public List getTranslations() {
        List translations = this.getModule().getTranslations();
        if (translations == null) {
            return null;
        }
        ArrayList<TranslationHandle> translationHandles = new ArrayList<TranslationHandle>();
        for (int i = 0; i < translations.size(); ++i) {
            translationHandles.add(((Translation)translations.get(i)).handle(this.getModule()));
        }
        return translationHandles;
    }

    public List getWarningList() {
        return this.module.getWarningList();
    }

    public Iterator imagesIterator() {
        return this.getPropertyHandle("images").iterator();
    }

    public List getAllImages() {
        return this.getStructureList("images");
    }

    public boolean needsSave() {
        List versionInfos;
        String version = this.module.getVersionManager().getVersion();
        if (version != null && !(versionInfos = ModelUtil.checkVersion(version)).isEmpty()) {
            return true;
        }
        return this.module.isDirty();
    }

    public void onSave() {
        this.module.onSave();
    }

    public boolean removeValidationListener(IValidationListener listener) {
        return this.getModule().removeValidationListener(listener);
    }

    public void rename(DesignElementHandle elementHandle) {
        if (elementHandle == null) {
            return;
        }
        this.module.rename(elementHandle.getElement());
    }

    public void replaceConfigVariable(ConfigVariable oldVar, ConfigVariable newVar) throws SemanticException {
        this.replaceObjectInList("configVars", oldVar, newVar);
    }

    public void replaceImage(EmbeddedImage oldVar, EmbeddedImage newVar) throws SemanticException {
        this.replaceObjectInList("images", oldVar, newVar);
    }

    private void replaceObjectInList(String propName, Object oldVar, Object newVar) throws SemanticException {
        ElementPropertyDefn propDefn = this.module.getPropertyDefn(propName);
        PropertyCommand cmd = new PropertyCommand(this.module, this.getElement());
        cmd.replaceItem(new CachedMemberRef(propDefn), (Structure)oldVar, (Structure)newVar);
    }

    public void save() throws IOException {
        String fileName = this.getFileName();
        if (!$assertionsDisabled && fileName == null) {
            throw new AssertionError();
        }
        if (fileName == null) {
            return;
        }
        this.module.prepareToSave();
        this.module.getWriter().write(new File(this.getModule().getFileName()));
        this.module.onSave();
    }

    public void saveAs(String newName) throws IOException {
        this.setFileName(newName);
        this.save();
    }

    public void serialize(OutputStream out) throws IOException {
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        this.module.prepareToSave();
        this.module.getWriter().write(out);
        this.module.onSave();
    }

    public void setAuthor(String author) {
        block2: {
            try {
                this.setStringProperty("author", author);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setCreatedBy(String toolName) {
        block2: {
            try {
                this.setStringProperty("createdBy", toolName);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setFileName(String newName) {
        URL systemId;
        this.getModule().setFileName(newName);
        if (!StringUtil.isBlank(newName) && (systemId = URIUtil.getDirectory(newName)) != null) {
            this.getModule().setSystemId(systemId);
        }
        AttributeEvent event = new AttributeEvent(this.module, "fileName");
        this.module.broadcastFileNameEvent(event);
    }

    public void setHelpGuide(String helpGuide) {
        block2: {
            try {
                this.setStringProperty("helpGuide", helpGuide);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setInitialize(String value) {
        block2: {
            try {
                this.setStringProperty("initialize", value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public List getAllStyles() {
        List elementList = this.module.getModuleNameSpace(0).getElements(Integer.MAX_VALUE);
        return this.generateHandleList(elementList);
    }

    public List getVisibleThemes(int level) {
        List elementList = this.module.getModuleNameSpace(6).getElements(level);
        return this.generateHandleList(elementList);
    }

    public List getAllDataSources() {
        IModuleNameSpace namescope = this.module.getModuleNameSpace(3);
        List elementList = namescope.getElements(Integer.MAX_VALUE);
        return this.generateHandleList(elementList);
    }

    public List getVisibleDataSources() {
        IModuleNameSpace namescope = this.module.getModuleNameSpace(3);
        List elementList = namescope.getElements(0);
        return this.generateHandleList(elementList);
    }

    public List getAllDataSets() {
        IModuleNameSpace namescope = this.module.getModuleNameSpace(4);
        List elementList = namescope.getElements(Integer.MAX_VALUE);
        return this.generateHandleList(elementList);
    }

    public List getVisibleDataSets() {
        IModuleNameSpace namescope = this.module.getModuleNameSpace(4);
        List elementList = namescope.getElements(0);
        return this.generateHandleList(elementList);
    }

    public List getAllPages() {
        List elementList = this.module.getNameSpace(5).getElements();
        return this.generateHandleList(elementList);
    }

    public List getAllParameters() {
        List elementList = this.module.getNameSpace(2).getElements();
        return this.generateHandleList(elementList);
    }

    private List generateHandleList(List elementList) {
        ArrayList<DesignElementHandle> handleList = new ArrayList<DesignElementHandle>();
        Iterator iter = elementList.iterator();
        while (iter.hasNext()) {
            DesignElement element = (DesignElement)iter.next();
            Module root = element.getRoot();
            if (!$assertionsDisabled && root == null) {
                throw new AssertionError();
            }
            handleList.add(element.getHandle(root));
        }
        return handleList;
    }

    public List getAllLibraries() {
        return this.getLibraries(Integer.MAX_VALUE);
    }

    protected List getLibraries(int level) {
        List libraries = this.module.getLibraries(level);
        ArrayList<LibraryHandle> retLibs = new ArrayList<LibraryHandle>();
        Iterator iter = libraries.iterator();
        while (iter.hasNext()) {
            Library library = (Library)iter.next();
            retLibs.add(library.handle());
        }
        return Collections.unmodifiableList(retLibs);
    }

    public List getLibraries() {
        return this.getLibraries(1);
    }

    public LibraryHandle getLibrary(String namespace) {
        Library library = this.module.getLibraryWithNamespace(namespace, 1);
        if (library == null) {
            return null;
        }
        return (LibraryHandle)library.getHandle(library);
    }

    public LibraryHandle findLibrary(String fileName) {
        URL url = this.module.findResource(fileName, 2);
        if (url == null) {
            return null;
        }
        Library library = this.module.getLibraryByLocation(url.toString());
        if (library == null) {
            return null;
        }
        return (LibraryHandle)library.getHandle(library);
    }

    public void shiftLibrary(LibraryHandle library, int toPosn) throws SemanticException {
        if (library == null) {
            return;
        }
        ShiftLibraryCommand command = new ShiftLibraryCommand(this.module);
        command.shiftLibrary((Library)library.getElement(), toPosn);
    }

    public boolean isReadOnly() {
        return this.module.isReadOnly();
    }

    public Iterator includeLibrariesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("libraries");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public void includeLibrary(String libraryFileName, String namespace) throws DesignFileException, SemanticException {
        LibraryCommand command = new LibraryCommand(this.module);
        command.addLibrary(libraryFileName, namespace);
    }

    public void dropLibrary(LibraryHandle library) throws SemanticException {
        if (library == null) {
            return;
        }
        LibraryCommand command = new LibraryCommand(this.module);
        command.dropLibrary((Library)library.getElement());
    }

    public void reloadLibrary(LibraryHandle libraryToReload) throws SemanticException, DesignFileException {
        if (libraryToReload == null) {
            return;
        }
        LibraryCommand command = new LibraryCommand(this.module);
        command.reloadLibrary(libraryToReload.getLocation());
    }

    public void dropLibraryAndBreakExtends(LibraryHandle library) throws SemanticException {
        if (library == null) {
            return;
        }
        LibraryCommand command = new LibraryCommand(this.module);
        command.dropLibraryAndBreakExtends((Library)library.getElement());
    }

    public void addAttributeListener(IAttributeListener listener) {
        this.getModule().addAttributeListener(listener);
    }

    public boolean removeAttributeListener(IAttributeListener listener) {
        return this.getModule().removeAttributeListener(listener);
    }

    public void addDisposeListener(IDisposeListener listener) {
        this.getModule().addDisposeListener(listener);
    }

    public boolean removeDisposeListener(IDisposeListener listener) {
        return this.getModule().removeDisposeListener(listener);
    }

    public void drop() throws SemanticException {
        throw new IllegalOperationException();
    }

    public void dropAndClear() throws SemanticException {
        throw new IllegalOperationException();
    }

    public String getIncludeResource() {
        return this.getStringProperty("includeResource");
    }

    public void setIncludeResource(String baseName) {
        block2: {
            try {
                this.setProperty("includeResource", baseName);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public URL findResource(String fileName, int fileType) {
        return this.module.findResource(fileName, fileType);
    }

    public CssStyleSheetHandle openCssStyleSheet(String fileName) throws StyleSheetException {
        StyleSheetLoader loader = new StyleSheetLoader();
        return loader.load(this.module, fileName).handle(this.module);
    }

    public CssStyleSheetHandle openCssStyleSheet(InputStream is) throws StyleSheetException {
        StyleSheetLoader loader = new StyleSheetLoader();
        return loader.load(this.module, is).handle(this.module);
    }

    public abstract void importCssStyles(CssStyleSheetHandle var1, List var2);

    public void setThemeName(String themeName) throws SemanticException {
        ThemeCommand command = new ThemeCommand((Module)this.getElement());
        command.setTheme(themeName);
    }

    public ThemeHandle getTheme() {
        Theme theme = this.getModule().getTheme(this.module);
        if (theme == null) {
            return null;
        }
        return (ThemeHandle)theme.getHandle(theme.getRoot());
    }

    public void setTheme(ThemeHandle theme) throws SemanticException {
        ThemeCommand command = new ThemeCommand((Module)this.getElement());
        command.setThemeElement(theme);
    }

    String getLocation() {
        return this.getModule().getLocation();
    }

    public boolean isInclude(LibraryHandle library) {
        return this.getModule().getLibraryByLocation(library.getLocation()) != null;
    }

    TemplateParameterDefinitionHandle findTemplateParameterDefinition(String name) {
        TemplateParameterDefinition templateParam = this.module.findTemplateParameterDefinition(name);
        if (templateParam == null) {
            return null;
        }
        return templateParam.handle(templateParam.getRoot());
    }

    List getAllTemplateParameterDefinitions() {
        List elementList = this.module.getModuleNameSpace(7).getElements(0);
        return this.generateHandleList(elementList);
    }

    public String getDescription() {
        return this.getStringProperty("description");
    }

    public String getDisplayDescription() {
        return this.getExternalizedValue("descriptionID", "description");
    }

    public void setDescription(String description) throws SemanticException {
        this.setStringProperty("description", description);
    }

    public String getDescriptionKey() {
        return this.getStringProperty("descriptionID");
    }

    public void setDescriptionKey(String resourceKey) throws SemanticException {
        this.setStringProperty("descriptionID", resourceKey);
    }

    public void initializeModule(Map properties) throws SemanticException {
        if (this.isInitialized) {
            return;
        }
        String name = null;
        Object value = null;
        Module root = (Module)this.getElement();
        Set propNames = properties.keySet();
        Iterator itre = propNames.iterator();
        while (itre.hasNext()) {
            name = (String)itre.next();
            value = PropertyValueValidationUtil.validateProperty(this, name, properties.get(name));
            root.setProperty(name, value);
        }
        this.isInitialized = true;
    }

    public String getFileEncoding() {
        return "UTF-8";
    }

    static {
        $assertionsDisabled = !ModuleHandle.class.desiredAssertionStatus();
    }
}

