/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnBandInsertAction;
import org.eclipse.birt.report.model.api.ColumnBandInsertPasteAction;
import org.eclipse.birt.report.model.api.ColumnBandPasteAction;
import org.eclipse.birt.report.model.api.ColumnBandShiftAction;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableColumnBandAdapter;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.table.LayoutTableModel;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ColumnHelper;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.interfaces.ITableItemModel;

public class TableHandle
extends ListingHandle
implements ITableItemModel {
    public TableHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public SlotHandle getColumns() {
        return this.getSlot(4);
    }

    public int getColumnCount() {
        return ((TableItem)this.getElement()).getColumnCount(this.module);
    }

    public String getCaption() {
        return this.getStringProperty("caption");
    }

    public void setCaption(String caption) throws SemanticException {
        this.setStringProperty("caption", caption);
    }

    public String getCaptionKey() {
        return this.getStringProperty("captionID");
    }

    public void setCaptionKey(String captionKey) throws SemanticException {
        this.setStringProperty("captionID", captionKey);
    }

    public boolean canCopyColumn(int columnIndex) {
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new TableColumnBandAdapter(this));
        try {
            pasteAction.copyColumnBand(columnIndex);
        }
        catch (SemanticException e) {
            return false;
        }
        return true;
    }

    public boolean canPasteColumn(ColumnBandData data, int columnIndex, boolean inForce) {
        if (data == null) {
            throw new IllegalArgumentException("empty column to check.");
        }
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new TableColumnBandAdapter(this));
        return pasteAction.canPaste(columnIndex, inForce, data);
    }

    public ColumnBandData copyColumn(int columnIndex) throws SemanticException {
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new TableColumnBandAdapter(this));
        return pasteAction.copyColumnBand(columnIndex);
    }

    public void pasteColumn(ColumnBandData data, int columnNumber, boolean inForce) throws SemanticException {
        if (data == null) {
            throw new IllegalArgumentException("empty column to paste.");
        }
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new TableColumnBandAdapter(this));
        pasteAction.pasteColumnBand(columnNumber, inForce, data);
    }

    public void insertAndPasteColumn(ColumnBandData data, int columnNumber) throws SemanticException {
        if (data == null) {
            throw new IllegalArgumentException("empty column to paste.");
        }
        ColumnBandInsertPasteAction insertAction = new ColumnBandInsertPasteAction(new TableColumnBandAdapter(this));
        insertAction.insertAndPasteColumnBand(columnNumber, data);
    }

    public boolean canInsertAndPasteColumn(ColumnBandData data, int columnIndex) {
        if (data == null) {
            throw new IllegalArgumentException("empty column to check.");
        }
        ColumnBandInsertPasteAction insertAction = new ColumnBandInsertPasteAction(new TableColumnBandAdapter(this));
        return insertAction.canInsertAndPaste(columnIndex, data);
    }

    public void shiftColumn(int sourceColumn, int destColumn) throws SemanticException {
        ColumnBandShiftAction shiftAction = new ColumnBandShiftAction(new TableColumnBandAdapter(this));
        shiftAction.shiftColumnBand(sourceColumn, destColumn);
    }

    public boolean canShiftColumn(int sourceColumn, int destColumn) {
        ColumnBandShiftAction shiftAction = new ColumnBandShiftAction(new TableColumnBandAdapter(this));
        try {
            shiftAction.getShiftData(sourceColumn);
        }
        catch (SemanticException e) {
            return false;
        }
        return shiftAction.checkTargetColumn(sourceColumn, destColumn);
    }

    public LayoutTableModel getLayoutModel() {
        return new LayoutTableModel(this);
    }

    public void insertColumn(int columnNumber, int positionFlag) throws SemanticException {
        ColumnBandInsertAction insertAction = new ColumnBandInsertAction(new TableColumnBandAdapter(this));
        insertAction.insertColumnBand(columnNumber, positionFlag);
    }

    protected CellHandle getCell(int row, int column) {
        return this.getLayoutModel().getCell(row, column);
    }

    public CellHandle getCell(int slotId, int groupLevel, int row, int column) {
        if (groupLevel <= 0) {
            return this.getLayoutModel().getCell(slotId, row, column);
        }
        return this.getLayoutModel().getCell(groupLevel, slotId, row, column);
    }

    public ColumnHandle findColumn(int columnNum) {
        TableColumn targetColumn = ColumnHelper.findColumn(this.module, this.getColumns().getSlot(), columnNum);
        return (ColumnHandle)targetColumn.getHandle(this.module);
    }
}

