/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class PropertyValueValidationUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Object validateStructure(DesignElementHandle element, ElementPropertyDefn propDefn, Object value) throws SemanticException {
        if (!(value instanceof IStructure)) {
            throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 16);
        }
        IStructure item = (IStructure)value;
        if (item.getDefn() != propDefn.getStructDefn()) {
            throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 16);
        }
        return PropertyValueValidationUtil.doValidateStructure(element, propDefn.getStructDefn(), item);
    }

    private static IStructure doValidateStructure(DesignElementHandle element, IStructureDefn structDefn, IStructure item) throws SemanticException {
        List errorList;
        Iterator iter = structDefn.propertiesIterator();
        while (iter.hasNext()) {
            PropertyDefn memberDefn = (PropertyDefn)iter.next();
            item.setProperty(memberDefn, memberDefn.validateValue(element.getModule(), item.getLocalProperty(element.getModule(), memberDefn)));
        }
        if (item instanceof Structure && (errorList = ((Structure)item).validate(element.getModule(), element.getElement())).size() > 0) {
            throw (SemanticException)((Object)errorList.get(0));
        }
        return item;
    }

    private static Object validateList(DesignElementHandle element, ElementPropertyDefn propDefn, Object value) throws SemanticException {
        if (!(value instanceof List)) {
            return null;
        }
        if (!$assertionsDisabled && !propDefn.isList()) {
            throw new AssertionError();
        }
        ArrayList<IStructure> retList = new ArrayList<IStructure>();
        List list = (List)value;
        IStructureDefn structDefn = propDefn.getStructDefn();
        for (int i = 0; i < list.size(); ++i) {
            IStructure item = (IStructure)list.get(i);
            if (item.getDefn() != structDefn) {
                throw new PropertyValueException(element.getElement(), propDefn, (Object)item, "Error.PropertyValueException.WRONG_ITEM_TYPE");
            }
            retList.add(PropertyValueValidationUtil.doValidateStructure(element, structDefn, item));
        }
        return retList;
    }

    public static Object validateProperty(DesignElementHandle element, String propName, Object propValue) throws SemanticException {
        ElementPropertyDefn propDefn = (ElementPropertyDefn)element.getPropertyDefn(propName);
        if (propDefn == null) {
            throw new PropertyNameException(element.getElement(), propName);
        }
        Object retValue = null;
        switch (propDefn.getTypeCode()) {
            case 17: {
                throw new PropertyValueException(propValue, "Error.PropertyValueException.INVALID_VALUE", propDefn.getTypeCode());
            }
            case 16: {
                if (propDefn.isList()) {
                    retValue = PropertyValueValidationUtil.validateList(element, propDefn, propValue);
                    break;
                }
                retValue = PropertyValueValidationUtil.validateStructure(element, propDefn, propValue);
                break;
            }
            default: {
                retValue = propDefn.validateValue(element.getModule(), propValue);
            }
        }
        return retValue;
    }

    static {
        $assertionsDisabled = !PropertyValueValidationUtil.class.desiredAssertionStatus();
    }
}

