/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class MasterPageContextContainmentValidator
extends AbstractElementValidator {
    private static final MasterPageContextContainmentValidator instance = new MasterPageContextContainmentValidator();

    public static MasterPageContextContainmentValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof MasterPage)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, element, false);
    }

    private List doValidate(Module module, DesignElement toValidate, boolean isAddListing) {
        MasterPage page = null;
        for (DesignElement container = toValidate; container != null; container = container.getContainer()) {
            if (!(container instanceof MasterPage)) continue;
            page = (MasterPage)container;
            break;
        }
        if (page == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        if (ModelUtil.containElement((DesignElement)page, "Listing") || isAddListing) {
            list.add(new SemanticError(toValidate, "Error.SemanticError.INVALID_MASTER_PAGE_CONTEXT_CONTAINMENT"));
        }
        return list;
    }

    public List validateForAdding(Module module, DesignElement element, int slotId, DesignElement toAdd) {
        List errors;
        boolean isAddListing = false;
        if (toAdd instanceof ListingElement || ModelUtil.containElement(toAdd, "Listing")) {
            isAddListing = true;
        }
        if (!(errors = this.doValidate(module, element, isAddListing)).isEmpty()) {
            errors.clear();
            errors.add(new ContentException(element, slotId, toAdd, "Error.ContentException.INVALID_CONTEXT_CONTAINMENT"));
        }
        return errors;
    }

    public List validateForAdding(Module module, DesignElement element, IElementDefn toAdd) {
        IElementDefn defn = MetaDataDictionary.getInstance().getElement("Listing");
        boolean isAddListing = defn.isKindOf(toAdd);
        return this.doValidate(module, element, isAddListing);
    }
}

