/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.command.LibraryReloadedEvent;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.LibraryRecord;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.util.ElementStructureUtil;
import org.eclipse.birt.report.model.util.LevelContentIterator;

public class LibraryCommand
extends AbstractElementCommand {
    static final int RELOAD_ACTION = 1;
    static final int SIMPLE_ACTION = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LibraryCommand(Module module) {
        super(module, module);
    }

    public void addLibrary(String libraryFileName, String namespace) throws DesignFileException, SemanticException {
        if (StringUtil.isBlank(namespace)) {
            namespace = StringUtil.extractFileName(libraryFileName);
        }
        if (this.module.isDuplicateNamespace(namespace)) {
            throw new LibraryException(this.module, new String[]{namespace}, "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE");
        }
        URL url = this.module.findResource(libraryFileName, 2);
        if (url != null && this.module.getLibraryByLocation(url.toString()) != null) {
            throw new LibraryException(this.module, new String[]{url.toString()}, "Error.LibraryException.LIBRARY_ALREADY_INCLUDED");
        }
        if (url != null && url.toString().equals(this.module.getLocation())) {
            throw new LibraryException(this.module, new String[]{namespace}, "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY");
        }
        this.doAddLibrary(libraryFileName, namespace, 2, null);
    }

    public void dropLibraryAndBreakExtends(Library library) throws SemanticException {
        if (!this.module.getLibraries().contains(library)) {
            throw new LibraryException(library, new String[]{library.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans();
        try {
            for (int slotID = 0; slotID < library.getDefn().getSlotCount(); ++slotID) {
                if (slotID == 0) continue;
                Iterator iter = library.getSlot(slotID).iterator();
                while (iter.hasNext()) {
                    DesignElement element = (DesignElement)iter.next();
                    List derived = element.getDerived();
                    for (int i = 0; i < derived.size(); ++i) {
                        DesignElement child = (DesignElement)derived.get(i);
                        if (child.getRoot() != this.getModule()) continue;
                        ExtendsCommand command = new ExtendsCommand(this.getModule(), child);
                        command.localizeElement();
                    }
                }
            }
            LibraryRecord record = new LibraryRecord(this.module, library, false);
            this.getActivityStack().execute(record);
            String libraryFileName = library.getFileName();
            if (!$assertionsDisabled && libraryFileName == null) {
                throw new AssertionError();
            }
            this.removeIncludeLibrary(libraryFileName, library.getNamespace());
        }
        catch (SemanticException ex) {
            stack.rollback();
            throw ex;
        }
        this.getActivityStack().commit();
    }

    public void dropLibrary(Library library) throws SemanticException {
        if (!this.module.getLibraries().contains(library)) {
            throw new LibraryException(library, new String[]{library.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        this.dealAllElementDecendents(library, 2);
        this.doDropLibrary(library);
    }

    private void doDropLibrary(Library library) throws SemanticException {
        ActivityStack stack = this.getActivityStack();
        stack.startTrans();
        LibraryRecord record = new LibraryRecord(this.module, library, false);
        this.getActivityStack().execute(record);
        try {
            String libFileName = library.getFileName();
            if (!$assertionsDisabled && libFileName == null) {
                throw new AssertionError();
            }
            this.removeIncludeLibrary(libFileName, library.getNamespace());
        }
        catch (SemanticException ex) {
            stack.rollback();
            throw ex;
        }
        this.getActivityStack().commit();
    }

    private Map dealElementDecendents(Library library, DesignElement parent, int actionCode) throws SemanticException {
        ArrayList allDescendents = new ArrayList();
        this.getAllDescdents(parent, allDescendents);
        HashMap<Long, Map> overriddenValues = new HashMap<Long, Map>();
        for (int i = 0; i < allDescendents.size(); ++i) {
            DesignElement child = (DesignElement)allDescendents.get(i);
            do {
                if (child.getRoot() != this.module) continue;
                if (actionCode == 1) {
                    Map values = this.unresolveElementDescendent(this.module, child);
                    overriddenValues.put(new Long(child.getID()), values);
                }
                if (actionCode != 2) continue;
                throw new LibraryException(library, new String[]{child.getHandle(this.module).getDisplayLabel()}, "Error.LibraryException.LIBRARY_HAS_DESCENDENTS");
            } while (child.hasDerived());
        }
        return overriddenValues;
    }

    public void reloadLibrary(String location) throws DesignFileException, SemanticException {
        Library library = this.module.getLibraryByLocation(location);
        if (!this.module.getLibraries().contains(library)) {
            throw new LibraryException(library, new String[]{library == null ? null : library.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        String namespace = library.getNamespace();
        IncludedLibrary includedItem = this.module.findIncludedLibrary(namespace);
        String path = includedItem.getFileName();
        URL url = this.module.findResource(path, 2);
        if (url == null) {
            DesignParserException ex = new DesignParserException(new String[]{path}, "Error.DesignParserException.FILE_NOT_FOUND");
            ArrayList<DesignParserException> exceptionList = new ArrayList<DesignParserException>();
            exceptionList.add(ex);
            throw new DesignFileException(path, exceptionList);
        }
        Map overriddenValues = null;
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startSilentTrans(true);
        try {
            overriddenValues = this.dealAllElementDecendents(library, 1);
            this.doDropLibrary(library);
            this.doAddLibrary(path, namespace, 1, overriddenValues);
        }
        catch (SemanticException e) {
            activityStack.rollback();
            throw e;
        }
        catch (DesignFileException e) {
            activityStack.rollback();
            throw e;
        }
        activityStack.commit();
        activityStack.flush();
        LibraryReloadedEvent event = new LibraryReloadedEvent(this.module.getLibraryByLocation(url.toExternalForm()));
        this.module.broadcast(event);
    }

    private Map dealAllElementDecendents(Library library, int actionCode) throws SemanticException {
        HashMap overriddenValues = new HashMap();
        LevelContentIterator contentIter = new LevelContentIterator(library, 1);
        while (contentIter.hasNext()) {
            DesignElement tmpElement = (DesignElement)contentIter.next();
            if (!tmpElement.getDefn().canExtend()) continue;
            Map values = this.dealElementDecendents(library, tmpElement, actionCode);
            if (actionCode != 1) continue;
            overriddenValues.putAll(values);
        }
        return overriddenValues;
    }

    private void doAddLibrary(String libraryFileName, String namespace, int action, Map overriddenValues) throws SemanticException, DesignFileException {
        Library library = this.module.loadLibrary(libraryFileName, namespace);
        library.setReadOnly();
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startTrans();
        LibraryRecord record = null;
        if (action == 2) {
            record = new LibraryRecord(this.module, library, true);
        }
        if (action == 1) {
            record = new LibraryRecord(this.module, library, overriddenValues);
        }
        this.getActivityStack().execute(record);
        IncludedLibrary includeLibrary = StructureFactory.createIncludeLibrary();
        includeLibrary.setFileName(libraryFileName);
        includeLibrary.setNamespace(namespace);
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("libraries");
        PropertyCommand propCommand = new PropertyCommand(this.module, this.module);
        propCommand.addItem(new CachedMemberRef(propDefn), includeLibrary);
        activityStack.commit();
    }

    private Map unresolveElementDescendent(Module module, DesignElement child) throws SemanticException {
        ElementRefValue value = (ElementRefValue)child.getLocalProperty(module, "extends");
        DesignElement parent = value.getElement();
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (child.getDefn().getSlotCount() == 0) {
            parent.dropDerived(child);
            value.unresolved(value.getName());
            return Collections.EMPTY_MAP;
        }
        Map overriddenValues = ElementStructureUtil.collectPropertyValues(child);
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startSilentTrans();
        LevelContentIterator contentIter = new LevelContentIterator(child, 1);
        while (contentIter.hasNext()) {
            DesignElement tmpElement = (DesignElement)contentIter.next();
            ContentCommand command = new ContentCommand(module, child);
            command.remove(tmpElement, tmpElement.getContainerSlot(), false, true);
        }
        activityStack.commit();
        parent.dropDerived(child);
        value.unresolved(value.getName());
        return overriddenValues;
    }

    private void getAllDescdents(DesignElement tmpElement, List results) {
        List descends = tmpElement.getDerived();
        results.addAll(descends);
        for (int i = 0; i < descends.size(); ++i) {
            this.getAllDescdents((DesignElement)descends.get(i), results);
        }
    }

    private void removeIncludeLibrary(String fileName, String namespace) throws PropertyValueException {
        if (!$assertionsDisabled && fileName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && namespace == null) {
            throw new AssertionError();
        }
        List includeLibraries = this.module.getIncludedLibraries();
        Iterator iter = includeLibraries.iterator();
        while (iter.hasNext()) {
            IncludedLibrary includeLibrary = (IncludedLibrary)iter.next();
            if (!namespace.equals(includeLibrary.getNamespace()) || !fileName.endsWith(StringUtil.extractFileNameWithSuffix(includeLibrary.getFileName()))) continue;
            ElementPropertyDefn propDefn = this.module.getPropertyDefn("libraries");
            PropertyCommand propCommand = new PropertyCommand(this.module, this.module);
            propCommand.removeItem((MemberRef)new CachedMemberRef(propDefn), includeLibrary);
            break;
        }
    }

    static {
        $assertionsDisabled = !LibraryCommand.class.desiredAssertionStatus();
    }
}

