/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.LibraryEvent;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.AbstractLibraryRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ElementStructureUtil;

class LibraryRecord
extends AbstractLibraryRecord {
    protected int position = -1;
    protected boolean add = true;
    protected Map overriddenValues = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    LibraryRecord(Module module, Library library, boolean add) {
        super(module, library);
        this.add = add;
    }

    LibraryRecord(Module module, Library library, Map values) {
        this(module, library, true);
        this.overriddenValues = values;
        if (!$assertionsDisabled && this.overriddenValues == null) {
            throw new AssertionError();
        }
    }

    protected void perform(boolean undo) {
        if (this.add && !undo || !this.add && undo) {
            int toUpdateLibraryCount;
            if (this.position == -1) {
                this.module.addLibrary(this.library);
                toUpdateLibraryCount = this.module.getLibraries().size() - 1;
            } else {
                this.module.insertLibrary(this.library, this.position);
                toUpdateLibraryCount = this.position;
            }
            if (this.add && !undo) {
                this.resolveAllElementDescendants();
            }
            List librariesToUpdate = this.module.getLibraries().subList(0, toUpdateLibraryCount);
            this.updateReferenceableClients(librariesToUpdate);
        } else {
            this.position = this.module.dropLibrary(this.library);
            this.updateReferenceableClients(this.library);
        }
    }

    public DesignElement getTarget() {
        return this.module;
    }

    public NotificationEvent getEvent() {
        if (this.add && this.state != 2 || !this.add && this.state == 2) {
            return new LibraryEvent(this.library, 1);
        }
        return new LibraryEvent(this.library, 2);
    }

    protected void resolveAllElementDescendants() {
        for (int i = 0; i < this.module.getDefn().getSlotCount(); ++i) {
            int slotId = i;
            if (slotId == 0 || slotId == 0 || slotId == 8) continue;
            this.resolveElementDescendantsInSlot(slotId);
        }
    }

    private void resolveElementDescendantsInSlot(int slotId) {
        ContentIterator contentIter = new ContentIterator(this.module, slotId);
        while (contentIter.hasNext()) {
            String name;
            DesignElement tmpElement = (DesignElement)contentIter.next();
            ElementDefn elementDefn = (ElementDefn)tmpElement.getDefn();
            if (!elementDefn.canExtend() || StringUtil.isBlank(name = tmpElement.getExtendsName())) continue;
            tmpElement.resolveExtends(this.module);
            if (tmpElement.getDefn().getSlotCount() <= 0) continue;
            tmpElement.refreshStructureFromParent(this.module);
            if (this.overriddenValues == null) {
                return;
            }
            Long idObj = new Long(tmpElement.getID());
            Map values = (Map)this.overriddenValues.get(idObj);
            ElementStructureUtil.distributeValues(tmpElement, values);
            ElementStructureUtil.addTheVirualElementsToNamesapce(tmpElement, this.module);
        }
    }

    static {
        $assertionsDisabled = !LibraryRecord.class.desiredAssertionStatus();
    }
}

