/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.TableRow;

public class CellHelper {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Cell findCell(Module module, GridItem grid, int rowNum, int colNum) {
        if (grid == null) {
            return null;
        }
        if (colNum > grid.findMaxCols(module)) {
            return null;
        }
        ContainerSlot rowSlot = grid.getSlot(1);
        for (int i = 0; i < rowSlot.getCount(); ++i) {
            TableRow row = (TableRow)rowSlot.getContent(i);
            ContainerSlot cellSlot = row.getSlot(0);
            for (int j = 0; j < cellSlot.getCount(); ++j) {
                int rowIndex = i;
                Cell cell = (Cell)cellSlot.getContent(j);
                int rowSpan = cell.getIntProperty(module, "rowSpan");
                int n = rowSpan = rowSpan < 1 ? 1 : rowSpan;
                if ((rowIndex += rowSpan) < rowNum) continue;
                int colIndex = 0;
                int column = grid.getCellPositionInColumn(module, cell);
                if (!$assertionsDisabled && column <= 0) {
                    throw new AssertionError();
                }
                int colSpan = cell.getIntProperty(module, "colSpan");
                colSpan = colSpan < 1 ? 1 : colSpan;
                colIndex = column + colSpan - 1;
                if (colIndex < colNum) continue;
                return cell;
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !CellHelper.class.desiredAssertionStatus();
    }
}

