/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;

class FileMetaLogger
implements IMetaLogger {
    protected static final String DEFAULT_LOG_FILE = "meta.log";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected Writer writer = null;
    private String fileName = null;
    protected static final SimpleDateFormat df;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileMetaLogger() {
        this(DEFAULT_LOG_FILE);
    }

    public FileMetaLogger(String fileName) {
        this.fileName = fileName;
    }

    public void log(String message) {
        if (this.canLog()) {
            try {
                Date dateTime = Calendar.getInstance().getTime();
                StringBuffer sb = new StringBuffer();
                sb.append(df.format(dateTime));
                sb.append(" Message [");
                sb.append(message.toString() + "]" + "\n");
                this.writer.write(sb.toString());
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void log(String message, Throwable t) {
        if (this.canLog()) {
            try {
                Date dateTime = Calendar.getInstance().getTime();
                StringBuffer sb = new StringBuffer();
                sb.append(df.format(dateTime));
                sb.append("  Message [");
                sb.append(message.toString() + "]" + "\n");
                sb.append("\t\t\t\t\t");
                sb.append(" Exception [");
                sb.append(this.getExceptionString(t));
                sb.append("]\n");
                this.writer.write(sb.toString());
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String getExceptionString(Throwable aException) {
        ByteArrayOutputStream outStream = null;
        PrintStream printStream = null;
        outStream = new ByteArrayOutputStream();
        printStream = new PrintStream(outStream);
        aException.printStackTrace(printStream);
        String stackTrace = outStream.toString();
        printStream.close();
        printStream = null;
        outStream.close();
        outStream = null;
        String string = stackTrace;
        Object var7_7 = null;
        try {
            if (printStream != null) {
                printStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return string;
        catch (Exception e) {
            try {
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (printStream != null) {
                        printStream.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (printStream != null) {
                    printStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e2) {}
        }
        return null;
    }

    protected OutputStreamWriter createWriter(String fileName) throws IOException {
        OutputStreamWriter retWriter;
        block2: {
            retWriter = null;
            try {
                retWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName), false), DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return retWriter;
    }

    protected boolean canLog() {
        if (this.fileName != null && this.writer == null) {
            try {
                this.writer = this.createWriter(this.fileName);
            }
            catch (IOException e) {
                this.fileName = null;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.writer = null;
            }
        }
    }

    static {
        $assertionsDisabled = !FileMetaLogger.class.desiredAssertionStatus();
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

