/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.Map;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.gef.commands.Command;

public class CreateCommand
extends Command {
    private Object parent;
    private Object after;
    private Map extendsData;

    public CreateCommand(Map extendsData) {
        this.extendsData = extendsData;
    }

    public void execute() {
        DesignElementHandle newObject = this.getNewObject();
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("CreateCommand >> Starts ... ");
        }
        try {
            if (this.parent instanceof SlotHandle) {
                if (this.after != null) {
                    int pos = DEUtil.findInsertPosition(((SlotHandle)this.parent).getElementHandle(), (DesignElementHandle)this.after, ((SlotHandle)this.parent).getSlotID());
                    ((SlotHandle)this.parent).add(newObject, pos);
                } else {
                    ((SlotHandle)this.parent).add(newObject);
                }
            } else if (newObject instanceof DataSourceHandle) {
                ((DesignElementHandle)this.parent).addElement(newObject, 2);
            } else if (this.after != null) {
                int pos = DEUtil.findInsertPosition((DesignElementHandle)this.parent, (DesignElementHandle)this.after);
                int slotID = DEUtil.findSlotID(this.parent, this.after);
                ((DesignElementHandle)this.parent).addElement(newObject, slotID, pos);
            } else {
                ((DesignElementHandle)this.parent).addElement(newObject, DEUtil.getDefaultSlotID(this.parent));
            }
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("CreateCommand >> Finished. " + DEUtil.getDisplayLabel(newObject) + " created");
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("CreateCommand >> Failed");
            }
            e.printStackTrace();
        }
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setAfter(Object model) {
        this.after = model;
    }

    public DesignElementHandle getNewObject() {
        return (DesignElementHandle)this.extendsData.get("newObject");
    }
}

