/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.commands.DeleteColumnCommand;
import org.eclipse.birt.report.designer.core.commands.DeleteRowCommand;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.StructuredSelection;

public class DeleteCommand
extends Command {
    private Object model = null;
    private ArrayList embeddedImageList = new ArrayList();

    public DeleteCommand(Object model) {
        this.model = model;
    }

    public void execute() {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("DeleteCommand >> Starts ... ");
        }
        try {
            this.dropSource(this.model);
            if (!this.embeddedImageList.isEmpty()) {
                for (int i = 0; i < this.embeddedImageList.size(); ++i) {
                    IStructure item = ((EmbeddedImageHandle)this.embeddedImageList.get(i)).getStructure();
                    String name = ((EmbeddedImageHandle)this.embeddedImageList.get(i)).getName();
                    SessionHandleAdapter.getInstance().getReportDesignHandle().getPropertyHandle("images").removeItem(item);
                    if (DesignerConstants.TRACING_COMMANDS) {
                        System.out.println("DeleteCommand >> Dropping embedded image " + item.getStructName());
                    }
                    String key = ImageManager.getInstance().generateKey(SessionHandleAdapter.getInstance().getReportDesignHandle(), name);
                    ImageManager.getInstance().removeCachedImage(key);
                }
            }
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("DeleteCommand >> Finished. ");
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("DeleteCommand >> Failed. ");
            }
            e.printStackTrace();
        }
    }

    protected void dropSource(Object source) throws SemanticException {
        if ((source = DNDUtil.unwrapToModel(source)) instanceof Object[]) {
            Object[] array = (Object[])source;
            for (int i = 0; i < array.length; ++i) {
                this.dropSource(array[i]);
            }
        } else if (source instanceof StructuredSelection) {
            this.dropSource(((StructuredSelection)source).toArray());
        } else if (source instanceof DesignElementHandle) {
            this.dropSourceElementHandle((DesignElementHandle)source);
        } else if (source instanceof EmbeddedImageHandle) {
            this.dropEmbeddedImageHandle((EmbeddedImageHandle)source);
        } else if (source instanceof SlotHandle) {
            this.dropSourceSlotHandle((SlotHandle)source);
        }
    }

    private void dropEmbeddedImageHandle(EmbeddedImageHandle embeddedImage) {
        this.embeddedImageList.add(embeddedImage);
    }

    protected void dropSourceElementHandle(DesignElementHandle handle) throws SemanticException {
        if (handle.getContainer() != null) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("DeleteCommand >> Dropping " + DEUtil.getDisplayLabel(handle));
            }
            if (handle instanceof CellHandle) {
                this.dropSourceSlotHandle(((CellHandle)handle).getContent());
            } else if (handle instanceof RowHandle) {
                new DeleteRowCommand(handle).execute();
            } else if (handle instanceof ColumnHandle) {
                new DeleteColumnCommand(handle).execute();
            } else {
                handle.drop();
            }
        }
    }

    protected void dropSourceSlotHandle(SlotHandle slot) throws SemanticException {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("DeleteCommand >> Dropping slot " + slot.getSlotID() + " of " + DEUtil.getDisplayLabel(slot.getElementHandle()));
        }
        List list = slot.getContents();
        for (int i = 0; i < list.size(); ++i) {
            this.dropSourceElementHandle((DesignElementHandle)list.get(i));
        }
    }

    public boolean canExecute() {
        return this.canDrop(this.model);
    }

    protected boolean canDrop(Object source) {
        if (source == null) {
            return false;
        }
        if (source instanceof List) {
            return this.canDrop(((List)source).toArray());
        }
        if (source instanceof StructuredSelection) {
            return this.canDrop(((StructuredSelection)source).toArray());
        }
        if (source instanceof Object[]) {
            Object[] array = (Object[])source;
            if (array.length == 0) {
                return false;
            }
            for (int i = 0; i < array.length; ++i) {
                if (DNDUtil.checkContainerExists(array[i], array) || !this.canDrop(array[i])) continue;
                return true;
            }
            return false;
        }
        if ((source = DNDUtil.unwrapToModel(source)) instanceof SlotHandle) {
            SlotHandle slot = (SlotHandle)source;
            DesignElementHandle handle = slot.getElementHandle();
            return slot.getContents().size() > 0 && (handle instanceof ListHandle && ((ListHandle)handle).canDrop() || handle instanceof ListGroupHandle && ((ListGroupHandle)handle).canDrop()) && this.canDrop(slot.getContents());
        }
        if (source instanceof EmbeddedImageHandle) {
            return true;
        }
        if (source instanceof CellHandle) {
            return ((CellHandle)source).getContent().getContents().size() > 0 && ((CellHandle)source).canDrop();
        }
        if (source instanceof MasterPageHandle) {
            return SessionHandleAdapter.getInstance().getReportDesignHandle().getMasterPages().getCount() > 1;
        }
        if (source instanceof ReportElementHandle) {
            return ((ReportElementHandle)source).canDrop();
        }
        return false;
    }
}

