/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.gef.commands.Command;

public class PasteCommand
extends Command {
    private DesignElementHandle sourceHandle;
    private Object newContainer;
    private DesignElementHandle afterHandle;
    private IDesignElement cloneElement;
    private boolean isCut = false;
    private int slotID = -1;
    private int position = -1;
    private boolean isCloned = false;

    public PasteCommand(DesignElementHandle sourceHandle, Object newContainer, DesignElementHandle afterHandle, boolean isCut) {
        this.sourceHandle = sourceHandle;
        this.cloneElement = sourceHandle.copy();
        this.newContainer = newContainer;
        this.afterHandle = afterHandle;
        this.isCut = isCut;
        this.isCloned = true;
    }

    public PasteCommand(DesignElementHandle sourceHandle, Object newContainer, int position, boolean isCut) {
        this.sourceHandle = sourceHandle;
        this.cloneElement = sourceHandle.copy();
        this.newContainer = newContainer;
        this.position = position;
        this.isCut = isCut;
        this.isCloned = true;
    }

    public PasteCommand(IDesignElement cloneElement, Object newContainer, DesignElementHandle afterHandle) {
        this.cloneElement = cloneElement;
        this.newContainer = newContainer;
        this.afterHandle = afterHandle;
        this.isCloned = false;
    }

    public PasteCommand(IDesignElement cloneElement, Object newContainer, int position) {
        this.cloneElement = cloneElement;
        this.newContainer = newContainer;
        this.position = position;
        this.isCloned = false;
    }

    public void execute() {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("PasteCommand >> Starts ...");
        }
        try {
            if (!this.isCut || this.sourceHandle == null || this.sourceHandle.getContainer() == null) {
                this.isCut = false;
            }
            this.calculatePositionAndSlotId();
            this.dropSourceHandle(this.sourceHandle);
            ModuleHandle currentDesignHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
            DesignElementHandle newHandle = this.copyNewHandle(this.cloneElement, currentDesignHandle);
            this.addHandleToReport(newHandle);
        }
        catch (Exception e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("PasteCommand >> Failed.");
            }
            e.printStackTrace();
        }
    }

    private void addHandleToReport(DesignElementHandle newHandle) throws ContentException, NameException {
        SlotHandle slotHandle = null;
        if (this.newContainer instanceof DesignElementHandle) {
            slotHandle = ((DesignElementHandle)this.newContainer).getSlot(this.slotID);
        } else if (this.newContainer instanceof SlotHandle) {
            slotHandle = (SlotHandle)this.newContainer;
        } else if (this.newContainer instanceof ReportElementModel) {
            slotHandle = ((ReportElementModel)this.newContainer).getElementHandle().getSlot(this.slotID);
        }
        slotHandle.paste(newHandle, this.position);
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("PasteCommand >>  Finished. Paste " + DEUtil.getDisplayLabel(newHandle) + " to the slot " + slotHandle.getSlotID() + " of " + DEUtil.getDisplayLabel(slotHandle.getElementHandle()) + ",Position: " + this.position);
        }
    }

    private void calculatePositionAndSlotId() {
        int oldPosition;
        DesignElementHandle container = null;
        if (this.newContainer instanceof DesignElementHandle) {
            this.slotID = DEUtil.getDefaultSlotID(this.newContainer);
            container = (DesignElementHandle)this.newContainer;
        } else if (this.newContainer instanceof SlotHandle) {
            this.slotID = ((SlotHandle)this.newContainer).getSlotID();
            container = ((SlotHandle)this.newContainer).getElementHandle();
        } else if (this.newContainer instanceof ReportElementModel) {
            this.slotID = ((ReportElementModel)this.newContainer).getSlotId();
            container = ((ReportElementModel)this.newContainer).getElementHandle();
        } else {
            return;
        }
        if (this.afterHandle != null) {
            this.position = DEUtil.findInsertPosition(container, this.afterHandle, this.slotID);
        } else if (this.position > -1 && this.isCut && this.sourceHandle.getContainer() == container && (oldPosition = DEUtil.findInsertPosition(container, this.sourceHandle, this.slotID)) < this.position) {
            --this.position;
        }
    }

    private void dropSourceHandle(DesignElementHandle oldHandle) throws SemanticException {
        if (this.isCut) {
            oldHandle.drop();
        }
    }

    private DesignElementHandle copyNewHandle(IDesignElement element, ModuleHandle currentDesignHandle) throws CloneNotSupportedException {
        IDesignElement newElement = this.isCloned ? element : (IDesignElement)element.clone();
        DesignElementHandle handle = newElement.getHandle(currentDesignHandle.getModule());
        currentDesignHandle.rename(handle);
        return handle;
    }

    public boolean canExecute() {
        if (this.cloneElement == null) {
            return false;
        }
        DesignElementHandle childHandle = this.sourceHandle;
        if (childHandle == null) {
            childHandle = this.cloneElement.getHandle(SessionHandleAdapter.getInstance().getReportDesignHandle().getModule());
        }
        return DNDUtil.handleValidateTargetCanContain(this.newContainer, childHandle) && DNDUtil.handleValidateTargetCanContainMore(this.newContainer, 1);
    }
}

