/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.CSSUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupElementFactory;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MethodInfo;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class DEUtil {
    public static final String ELEMENT_LABELCONTENT_PROPERTY = "labelContent";
    private static HashMap propertiesMap;
    private static ArrayList notSupportList;
    public static final String TYPE_GROUP_LISTING = "listing";
    public static final String TYPE_GROUP_GROUP = "group";
    public static final String TYPE_GROUP_NONE = "none";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static List getElementSupportList(DesignElementHandle parent, int slotId) {
        ArrayList list = new ArrayList();
        ISlotDefn slotDefn = parent.getDefn().getSlot(slotId);
        if (slotDefn != null) {
            list.addAll(slotDefn.getContentExtendedElements());
            list.removeAll(notSupportList);
        }
        ArrayList availableList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            if (!parent.canContain(slotId, ((IElementDefn)list.get(i)).getName())) continue;
            availableList.add(list.get(i));
        }
        return availableList;
    }

    public static List getElementSupportList(SlotHandle slotHandle) {
        return DEUtil.getElementSupportList(slotHandle.getElementHandle(), slotHandle.getSlotID());
    }

    public static List getElementSupportList(DesignElementHandle parent) {
        int slotID = -1;
        if (parent instanceof MasterPageHandle) {
            slotID = 0;
        }
        return DEUtil.getElementSupportList(parent, slotID);
    }

    public static int findInsertPosition(DesignElementHandle parent, DesignElementHandle element, int slotID) {
        if (element == null) {
            SlotHandle slotHandle = parent.getSlot(slotID);
            if (slotHandle != null) {
                return slotHandle.getCount();
            }
            return -1;
        }
        return DEUtil.findPos(parent, slotID, element);
    }

    public static int findPos(DesignElementHandle parent, int slotID, DesignElementHandle child) {
        if (!$assertionsDisabled && slotID < 0) {
            throw new AssertionError();
        }
        SlotHandle slotHandle = parent.getSlot(slotID);
        return slotHandle.findPosn(child);
    }

    public static String getElementName(Object obj) {
        if (obj instanceof Class) {
            obj = ((Class)obj).getName();
        }
        return obj.toString().substring(obj.toString().lastIndexOf(".") + 1);
    }

    public static IElementDefn getElementDefn(String elementName) {
        IElementDefn defn = DesignEngine.getMetaDataDictionary().getElement(elementName);
        if (defn == null) {
            defn = DesignEngine.getMetaDataDictionary().getExtension(elementName);
        }
        return defn;
    }

    public static String getDisplayLabel(Object obj) {
        return DEUtil.getDisplayLabel(obj, true);
    }

    public static String getDisplayLabel(Object obj, boolean includeElementName) {
        if (obj instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)obj;
            String elementName = handle.getDefn().getDisplayName();
            String displayName = handle.getQualifiedName() != null && !handle.getQualifiedName().equals(handle.getName()) ? handle.getQualifiedName() : handle.getDisplayLabel(0);
            if (!StringUtil.isBlank((String)displayName)) {
                if (includeElementName) {
                    return elementName + " - " + displayName;
                }
                return displayName;
            }
            return elementName;
        }
        return "";
    }

    public static int getMasterPageAccount() {
        SlotHandle slotHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().getMasterPages();
        Iterator itor = slotHandle.iterator();
        int account = 0;
        while (itor.hasNext()) {
            ++account;
            itor.next();
        }
        return account;
    }

    public static int getDefaultSlotID(Object parent) {
        int slotID = -1;
        if (parent instanceof GraphicMasterPageHandle) {
            slotID = 0;
        } else if (parent instanceof ParameterGroupHandle) {
            slotID = 0;
        } else if (parent instanceof ReportDesignHandle) {
            slotID = 6;
        } else if (parent instanceof LibraryHandle) {
            slotID = 5;
        } else if (parent instanceof CellHandle) {
            slotID = 0;
        } else if (parent instanceof RowHandle) {
            slotID = 0;
        } else if (parent instanceof GridHandle) {
            slotID = 1;
        } else if (parent instanceof ThemeHandle) {
            slotID = 0;
        }
        return slotID;
    }

    public static int findSlotID(Object parent, Object child) {
        if (!$assertionsDisabled && !(parent instanceof DesignElementHandle)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(child instanceof DesignElementHandle)) {
            throw new AssertionError();
        }
        int slotID = ((DesignElementHandle)parent).findContentSlot((DesignElementHandle)child);
        return slotID;
    }

    public static int getSlotID(Object parent, Object child) {
        if (!$assertionsDisabled && !(parent instanceof DesignElementHandle)) {
            throw new AssertionError();
        }
        int slotID = -1;
        slotID = child != null ? DEUtil.findSlotID(parent, child) : DEUtil.getDefaultSlotID(parent);
        return slotID;
    }

    public static int findInsertPosition(DesignElementHandle parent, DesignElementHandle element) {
        if (element == null) {
            SlotHandle slotHandle = parent.getSlot(DEUtil.getDefaultSlotID(parent));
            if (slotHandle != null) {
                return slotHandle.getCount();
            }
            return -1;
        }
        return DEUtil.findPos(parent, element.getContainerSlotHandle().getSlotID(), element);
    }

    public static String getGUIPropertyKey(String key) {
        if (key != null) {
            return (String)propertiesMap.get(key);
        }
        return null;
    }

    public static double convertoToPixel(Object handle) {
        return DEUtil.convertToPixel(handle, 0);
    }

    public static double convertToPixel(Object object, int fontSize) {
        DimensionValue dimension;
        double px = 0.0;
        double measure = 0.0;
        String units = "";
        if (object instanceof DimensionValue) {
            dimension = (DimensionValue)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        } else if (object instanceof DimensionHandle) {
            dimension = (DimensionHandle)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        }
        if ("px".equals(units)) {
            return measure;
        }
        if ("".equalsIgnoreCase(units)) {
            px = measure;
        }
        if (fontSize == 0) {
            Font defaultFont = JFaceResources.getDefaultFont();
            FontData[] fontData = defaultFont.getFontData();
            fontSize = fontData[0].getHeight();
        }
        if ("em".equals(units)) {
            px = DimensionUtil.convertTo((double)(measure * (double)fontSize), (String)"pt", (String)"in").getMeasure();
        } else if ("ex".equals(units)) {
            px = DimensionUtil.convertTo((double)(measure * (double)fontSize / 3.0), (String)"pt", (String)"in").getMeasure();
        } else if ("%".equals(units)) {
            px = DimensionUtil.convertTo((double)(measure * (double)fontSize / 100.0), (String)"pt", (String)"in").getMeasure();
        } else if ("".equals(units)) {
            units = SessionHandleAdapter.getInstance().getReportDesignHandle().getDefaultUnits();
            px = DimensionUtil.convertTo((double)measure, (String)units, (String)"in").getMeasure();
        } else {
            px = units == null ? 0.0 : DimensionUtil.convertTo((double)measure, (String)units, (String)"in").getMeasure();
        }
        return MetricUtility.inchToPixel(px);
    }

    public static double convertToValue(DimensionHandle handle, String targetUnit) {
        double retValue = 0.0;
        if (handle.isSet()) {
            retValue = DimensionUtil.convertTo((double)handle.getMeasure(), (String)handle.getUnits(), (String)targetUnit).getMeasure();
        }
        return retValue;
    }

    public static boolean isValidInteger(String val) {
        try {
            Integer.parseInt(val);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isValidNumber(String val) {
        try {
            Double.parseDouble(val);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String[] splitString(String value) {
        String[] spt = new String[2];
        if (value != null) {
            for (int i = value.length(); i > 0; --i) {
                if (!DEUtil.isValidNumber(value.substring(0, i))) continue;
                spt[0] = value.substring(0, i);
                spt[1] = value.substring(i, value.length());
                break;
            }
            if (spt[0] == null && spt[1] == null) {
                spt[1] = value;
            }
        }
        return spt;
    }

    public static String resolveNull(String value) {
        return value == null ? "" : value;
    }

    public static String getRGBText(RGB rgb) {
        if (rgb != null) {
            return rgb.red + "," + rgb.green + "," + rgb.blue;
        }
        return "";
    }

    public static RGB getRGBValue(String val) {
        if (val != null) {
            if (val.startsWith("#")) {
                int rgb = ColorUtil.parseColor((String)val);
                if (rgb != -1) {
                    return DEUtil.getRGBValue(rgb);
                }
            } else {
                String[] ss = val.split(",");
                if (ss.length == 3) {
                    try {
                        int r = Integer.parseInt(ss[0]);
                        int g = Integer.parseInt(ss[1]);
                        int b = Integer.parseInt(ss[2]);
                        return new RGB(r, g, b);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public static RGB getRGBValue(int rgbValue) {
        if (rgbValue == -1) {
            return null;
        }
        return new RGB(rgbValue >> 16 & 0xFF, rgbValue >> 8 & 0xFF, rgbValue & 0xFF);
    }

    public static int getRGBInt(RGB rgb) {
        if (rgb == null) {
            return -1;
        }
        return (rgb.red & 0xFF) << 16 | (rgb.green & 0xFF) << 8 | rgb.blue & 0xFF;
    }

    public static List getDataSetList(DesignElementHandle handle) {
        ArrayList<Object> dataSetList = new ArrayList<Object>();
        if (handle instanceof ReportElementHandle) {
            DataSetHandle dataSet;
            if (handle instanceof ReportItemHandle && (dataSet = ((ReportItemHandle)handle).getDataSet()) != null && !dataSetList.contains(dataSet)) {
                dataSetList.add(dataSet);
            }
            Iterator itor = DEUtil.getDataSetList(handle.getContainer()).iterator();
            while (itor.hasNext()) {
                DesignElementHandle dataSet2 = (DesignElementHandle)itor.next();
                if (dataSetList.contains(dataSet2)) continue;
                dataSetList.add(dataSet2);
            }
        }
        return dataSetList;
    }

    public static List getDataSetListExcludeSelf(DesignElementHandle handle) {
        ArrayList<DesignElementHandle> dataSetList = new ArrayList<DesignElementHandle>();
        if (handle instanceof ReportElementHandle) {
            Iterator itor = DEUtil.getDataSetList(handle.getContainer()).iterator();
            while (itor.hasNext()) {
                DesignElementHandle dataSet = (DesignElementHandle)itor.next();
                if (dataSetList.contains(dataSet)) continue;
                dataSetList.add(dataSet);
            }
        }
        return dataSetList;
    }

    public static IElementPropertyDefn getPropertyDefn(String elementName, String propertyName) {
        IElementDefn elementDefn = DesignEngine.getMetaDataDictionary().getElement(elementName);
        if (elementDefn != null) {
            return elementDefn.getProperty(propertyName);
        }
        return null;
    }

    public static String getExpression(Object model) {
        if (model instanceof ParameterHandle) {
            return "params[\"" + DEUtil.escape(((ParameterHandle)model).getQualifiedName()) + "\"]";
        }
        if (model instanceof DataSetItemModel) {
            String colName = ((DataSetItemModel)model).getAlias();
            if (colName == null || colName.trim().length() == 0) {
                colName = ((DataSetItemModel)model).getName();
            }
            return DEUtil.getColumnExpression(colName);
        }
        if (model instanceof ComputedColumnHandle) {
            return DEUtil.getColumnExpression(((ComputedColumnHandle)model).getName());
        }
        if (model instanceof ResultSetColumnHandle) {
            return DEUtil.getResultSetColumnExpression(((ResultSetColumnHandle)model).getColumnName());
        }
        if (model instanceof DataSetParameterHandle) {
            return "outputParams[\"" + DEUtil.escape(((DataSetParameterHandle)model).getName()) + "\"]";
        }
        return null;
    }

    public static int getFontSize(String fontSize) {
        if ("larger".equals(fontSize)) {
            fontSize = "large";
        } else if ("smaller".equals(fontSize)) {
            fontSize = "small";
        } else if (fontSize == null) {
            fontSize = "medium";
        }
        String rt = (String)DesignerConstants.fontMap.get(fontSize);
        if (rt != null) {
            return Integer.parseInt(rt);
        }
        String[] sp = DEUtil.splitString(fontSize);
        if (sp[0] != null && DEUtil.isValidNumber(sp[0])) {
            return (int)CSSUtil.convertToPoint(new DimensionValue(Double.parseDouble(sp[0]), sp[1]));
        }
        return 10;
    }

    public static String getFontSize(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                return "medium";
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            return ((DimensionValue)fontSizeValue).toString();
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSize(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSize(handle.getContainer());
            }
            return fontSize;
        }
        return "medium";
    }

    private static String getLargerFontSize(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                for (int i = 0; i < DesignerConstants.fontSizes.length - 1; ++i) {
                    if (!"medium".equals(DesignerConstants.fontSizes[i][0])) continue;
                    return DesignerConstants.fontSizes[i + 1][0];
                }
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            int parentSize = DEUtil.getFontSizeIntValue(handle.getContainer());
            int size = (int)CSSUtil.convertToPoint(fontSizeValue, parentSize) + 1;
            DimensionValue dm = new DimensionValue((double)size, "pt");
            return dm.toString();
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSize(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSize(handle.getContainer());
            }
            for (int i = 0; i < DesignerConstants.fontSizes.length - 1; ++i) {
                if (!fontSize.equals(DesignerConstants.fontSizes[i][0])) continue;
                return DesignerConstants.fontSizes[i + 1][0];
            }
            return DesignerConstants.fontSizes[DesignerConstants.fontSizes.length - 1][0];
        }
        return "medium";
    }

    private static String getSmallerFontSize(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                for (int i = DesignerConstants.fontSizes.length - 1; i > 0; --i) {
                    if (!"medium".equals(DesignerConstants.fontSizes[i][0])) continue;
                    return DesignerConstants.fontSizes[i - 1][0];
                }
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            int parentSize = DEUtil.getFontSizeIntValue(handle.getContainer());
            int size = (int)CSSUtil.convertToPoint(fontSizeValue, parentSize) - 1;
            size = size < 1 ? 1 : size;
            DimensionValue dm = new DimensionValue((double)size, "pt");
            return dm.toString();
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSize(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSize(handle.getContainer());
            }
            for (int i = DesignerConstants.fontSizes.length - 1; i > 0; --i) {
                if (!fontSize.equals(DesignerConstants.fontSizes[i][0])) continue;
                return DesignerConstants.fontSizes[i - 1][0];
            }
            return DesignerConstants.fontSizes[0][0];
        }
        return "medium";
    }

    public static int getFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                String size = (String)DesignerConstants.fontMap.get("medium");
                return Integer.parseInt(size);
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            int size = DEUtil.getFontSizeIntValue(handle.getContainer());
            return (int)CSSUtil.convertToPoint(fontSizeValue, size);
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSizeIntValue(handle.getContainer());
            }
            String size = (String)DesignerConstants.fontMap.get(fontSize);
            return Integer.parseInt(size);
        }
        String size = (String)DesignerConstants.fontMap.get("medium");
        return Integer.parseInt(size);
    }

    private static int getLargerFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                String size = (String)DesignerConstants.fontMap.get("medium");
                return Integer.parseInt(size) + 1;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            int size = DEUtil.getFontSizeIntValue(handle.getContainer());
            return (int)CSSUtil.convertToPoint(fontSizeValue, size) + 1;
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSizeIntValue(handle.getContainer());
            }
            for (int i = 0; i < DesignerConstants.fontSizes.length - 1; ++i) {
                if (!fontSize.equals(DesignerConstants.fontSizes[i][0])) continue;
                return Integer.parseInt(DesignerConstants.fontSizes[i + 1][1]);
            }
            return Integer.parseInt(DesignerConstants.fontSizes[DesignerConstants.fontSizes.length - 1][1]);
        }
        String size = (String)DesignerConstants.fontMap.get("medium");
        return Integer.parseInt(size) + 1;
    }

    private static int getSmallerFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                String size = (String)DesignerConstants.fontMap.get("medium");
                return Integer.parseInt(size) - 1;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            int gParentFontSize = DEUtil.getFontSizeIntValue(handle.getContainer());
            int size = (int)CSSUtil.convertToPoint(fontSizeValue, gParentFontSize) - 1;
            if (size < 1) {
                return 1;
            }
            return size;
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSizeIntValue(handle.getContainer());
            }
            for (int i = DesignerConstants.fontSizes.length - 1; i > 0; --i) {
                if (!fontSize.equals(DesignerConstants.fontSizes[i][0])) continue;
                return Integer.parseInt(DesignerConstants.fontSizes[i - 1][1]);
            }
            return Integer.parseInt(DesignerConstants.fontSizes[0][1]);
        }
        String size = (String)DesignerConstants.fontMap.get("medium");
        return Integer.parseInt(size) - 1;
    }

    public static String getEscapedMenuItemText(String src) {
        if (src != null && src.indexOf(38) != -1) {
            src = src.replaceAll("\\&", "&&");
        }
        return src;
    }

    public static String[] getSystemFontNames() {
        return DEUtil.getSystemFontNames(null);
    }

    public static String[] getSystemFontNames(Comparator comparator) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        if (comparator != null) {
            Arrays.sort(fontNames, comparator);
        }
        return fontNames;
    }

    public static GroupElementHandle getMultiSelectionHandle(List modelList) {
        ModuleHandle designHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        GroupElementHandle handle = GroupElementFactory.newGroupElement((ModuleHandle)designHandle, (List)modelList);
        return handle;
    }

    public static String escape(String str) {
        String[][] chars = new String[][]{{"\\\\", "\"", "'"}, {"\\\\\\\\", "\\\\\"", "\\\\'"}};
        String result = str;
        for (int i = 0; i < chars[0].length; ++i) {
            result = result.replaceAll(chars[0][i], chars[1][i]);
        }
        return result;
    }

    public static String getDecmalStr(int decPlaces) {
        String defaultDecs = "0000000000";
        String decStr = "";
        if (decPlaces > 0 && decPlaces < 10) {
            decStr = defaultDecs.substring(0, decPlaces);
        } else if (decPlaces >= 10) {
            if (decPlaces > 100) {
                decPlaces = 100;
            }
            int quotient = decPlaces / 10;
            int remainder = decPlaces % 10;
            StringBuffer s = new StringBuffer(100);
            for (int i = 0; i < quotient; ++i) {
                s.append(defaultDecs);
            }
            s.append(defaultDecs.substring(0, remainder));
            decStr = s.toString();
        }
        return decStr;
    }

    public static boolean isParameterGroup(Object transferSource) {
        return transferSource instanceof IDesignElement && ((IDesignElement)transferSource).getDefn().getName().equals("ParameterGroup");
    }

    public static Iterator getStyles() {
        return DEUtil.getStyles(new AlphabeticallyComparator());
    }

    public static Iterator getStyles(Comparator comparator) {
        Object[] stylesArray;
        ArrayList styles = null;
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() instanceof ReportDesignHandle) {
            styles = SessionHandleAdapter.getInstance().getReportDesignHandle().getAllStyles();
        } else if (SessionHandleAdapter.getInstance().getReportDesignHandle() instanceof LibraryHandle) {
            styles = new ArrayList();
            ThemeHandle theme = ((LibraryHandle)SessionHandleAdapter.getInstance().getReportDesignHandle()).getTheme();
            if (theme != null) {
                styles.addAll(theme.getStyles().getContents());
            }
        }
        Object[] objectArray = stylesArray = styles == null ? new Object[]{} : styles.toArray();
        if (comparator != null) {
            Arrays.sort(stylesArray, comparator);
        }
        return Arrays.asList(stylesArray).iterator();
    }

    public static boolean isSameString(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        return str1 != null && str1.equals(str2);
    }

    public static String getColumnExpression(String columnName) {
        Assert.isNotNull((Object)columnName);
        if (StringUtil.isBlank((String)columnName)) {
            return null;
        }
        return "row[\"" + DEUtil.escape(columnName) + "\"]";
    }

    public static String getResultSetColumnExpression(String columnName) {
        Assert.isNotNull((Object)columnName);
        if (StringUtil.isBlank((String)columnName)) {
            return null;
        }
        return "dataSetRow[\"" + DEUtil.escape(columnName) + "\"]";
    }

    public static String getRelativedPath(String basePath, String path) {
        File baseFile = new File(basePath);
        if (baseFile.isFile()) {
            baseFile = baseFile.getParentFile();
        }
        return URIUtil.getRelativePath((String)baseFile.getAbsolutePath(), (String)path);
    }

    public static ActionHandle getActionHandle(ReportItemHandle element) {
        ActionHandle actionHandle = null;
        if (element instanceof LabelHandle) {
            actionHandle = ((LabelHandle)element).getActionHandle();
        } else if (element instanceof DataItemHandle) {
            actionHandle = ((DataItemHandle)element).getActionHandle();
        } else if (element instanceof ImageHandle) {
            actionHandle = ((ImageHandle)element).getActionHandle();
        }
        return actionHandle;
    }

    public static ActionHandle setAction(ReportItemHandle element, Action action) throws SemanticException {
        ActionHandle actionHandle = null;
        if (element instanceof LabelHandle) {
            actionHandle = ((LabelHandle)element).setAction(action);
        } else if (element instanceof DataItemHandle) {
            actionHandle = ((DataItemHandle)element).setAction(action);
        } else if (element instanceof ImageHandle) {
            actionHandle = ((ImageHandle)element).setAction(action);
        }
        return actionHandle;
    }

    private static Object getModelFontSize(DesignElementHandle handle) {
        StyleHandle styleHandle = handle.getPrivateStyle();
        Object fontSizeValue = null;
        if (styleHandle != null) {
            fontSizeValue = handle.getPrivateStyle().getFontSize().getValue();
        }
        return fontSizeValue;
    }

    public static List getDataSets() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().getVisibleDataSets();
    }

    public static Iterator getThemes() {
        return DEUtil.getThemes(new AlphabeticallyComparator());
    }

    private static Iterator getThemes(AlphabeticallyComparator comparator) {
        List themes = SessionHandleAdapter.getInstance().getReportDesignHandle().getVisibleThemes(1);
        Object[] themesArray = themes.toArray();
        if (comparator != null) {
            Arrays.sort(themesArray, comparator);
        }
        return Arrays.asList(themesArray).iterator();
    }

    public static GroupElementHandle getGroupElementHandle(List modelList) {
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() == null) {
            return GroupElementFactory.newGroupElement((ModuleHandle)SessionHandleAdapter.getInstance().getReportDesignHandle(), (List)Collections.EMPTY_LIST);
        }
        return GroupElementFactory.newGroupElement((ModuleHandle)SessionHandleAdapter.getInstance().getReportDesignHandle(), (List)modelList);
    }

    public static boolean isIncluded(LibraryHandle handle) {
        return handle.getNamespace() != null;
    }

    public static List getClasses() {
        return DEUtil.getClasses(new AlphabeticallyComparator());
    }

    public static List getClasses(Comparator comp) {
        List classes = DesignEngine.getMetaDataDictionary().getClasses();
        Collections.sort(classes, comp);
        return classes;
    }

    public static List getMethods(IClassInfo classInfo) {
        return DEUtil.getMethods(classInfo, new AlphabeticallyComparator());
    }

    public static List getMethods(IClassInfo classInfo, Comparator comp) {
        List methods = classInfo.getMethods();
        Collections.sort(methods, comp);
        return methods;
    }

    public static List getMembers(IClassInfo classInfo) {
        return DEUtil.getMembers(classInfo, new AlphabeticallyComparator());
    }

    public static List getMembers(IClassInfo classInfo, Comparator comp) {
        List members = classInfo.getMembers();
        Collections.sort(members, comp);
        return members;
    }

    public static String getMethodArgumentType(DesignElementHandle handle, String methodName, int argIndex) {
        if (handle instanceof DataSetHandle) {
            return "DataSet";
        }
        if (handle instanceof DataSourceHandle) {
            return "DataSource";
        }
        List methods = handle.getDefn().getLocalMethods();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MethodInfo method = ((ElementPropertyDefn)iter.next()).getMethodInfo();
            if (!method.getName().equals(methodName)) continue;
            Iterator argumentListIterator = method.argumentListIterator();
            if (argumentListIterator.hasNext()) {
                IArgumentInfoList argumentInfoList = (IArgumentInfoList)argumentListIterator.next();
                int i = 0;
                Iterator iterator = argumentInfoList.argumentsIterator();
                while (iterator.hasNext()) {
                    Object arg = iterator.next();
                    if (argIndex == i) {
                        return ((IArgumentInfo)arg).getType();
                    }
                    ++i;
                }
            }
            return null;
        }
        return null;
    }

    public static Map getDesignElementMethodArguments(DesignElementHandle handle, String methodName) {
        List methods = handle.getDefn().getMethods();
        LinkedHashMap<String, String> argMap = new LinkedHashMap<String, String>(methods.size() * 2);
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Iterator argumentListIterator;
            MethodInfo method = ((ElementPropertyDefn)iter.next()).getMethodInfo();
            if (!method.getName().equals(methodName) || !(argumentListIterator = method.argumentListIterator()).hasNext()) continue;
            IArgumentInfoList argumentInfoList = (IArgumentInfoList)argumentListIterator.next();
            int i = 0;
            Iterator iterator = argumentInfoList.argumentsIterator();
            while (iterator.hasNext()) {
                IArgumentInfo arg = (IArgumentInfo)iterator.next();
                argMap.put(arg.getName(), arg.getType());
                ++i;
            }
        }
        return argMap;
    }

    public static List getDataSources() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().getVisibleDataSources();
    }

    public static List getAllColumnBindingList(DesignElementHandle handle) {
        return DEUtil.getAllColumnBindingList(handle, true);
    }

    public static List getAllColumnBindingList(DesignElementHandle handle, boolean includeSelf) {
        ArrayList bindingList = new ArrayList();
        if (handle instanceof ReportElementHandle) {
            Iterator iterator = DEUtil.getBindingColumnIterator(handle);
            while (iterator.hasNext()) {
                bindingList.add(iterator.next());
            }
            if (handle instanceof ListingHandle) {
                SlotHandle groupSlotHandle = ((ListingHandle)handle).getGroups();
                Iterator iter = groupSlotHandle.iterator();
                while (iter.hasNext()) {
                    GroupHandle group = (GroupHandle)iter.next();
                    Iterator columnIter = group.columnBindingsIterator();
                    while (columnIter.hasNext()) {
                        bindingList.add(columnIter.next());
                    }
                }
            }
            bindingList.addAll(0, DEUtil.getAllColumnBindingList(handle.getContainer(), true));
        }
        return bindingList;
    }

    public static List getVisiableColumnBindingsList(DesignElementHandle handle) {
        return DEUtil.getVisiableColumnBindingsList(handle, true);
    }

    public static List getVisiableColumnBindingsList(DesignElementHandle handle, boolean includeSelf) {
        ReportItemHandle holder;
        ArrayList bindingList = new ArrayList();
        if (includeSelf) {
            Iterator iterator = DEUtil.getBindingColumnIterator(handle);
            while (iterator.hasNext()) {
                bindingList.add(iterator.next());
            }
        }
        if ((holder = DEUtil.getBindingHolder(handle)) != null) {
            for (DesignElementHandle elementHandle = handle.getContainer(); elementHandle != holder.getContainer(); elementHandle = elementHandle.getContainer()) {
                ArrayList subBindingList = new ArrayList();
                Iterator iterator = DEUtil.getBindingColumnIterator(elementHandle);
                while (iterator.hasNext()) {
                    subBindingList.add(iterator.next());
                }
                bindingList.addAll(0, subBindingList);
            }
        }
        return bindingList;
    }

    public static ReportItemHandle getBindingHolder(DesignElementHandle handle) {
        if (handle instanceof ReportElementHandle) {
            if (handle instanceof ListingHandle) {
                return (ReportItemHandle)handle;
            }
            if (handle instanceof ReportItemHandle && (((ReportItemHandle)handle).getDataSet() != null || ((ReportItemHandle)handle).columnBindingsIterator().hasNext())) {
                return (ReportItemHandle)handle;
            }
            ReportItemHandle result = DEUtil.getBindingHolder(handle.getContainer());
            if (result == null && handle instanceof ReportItemHandle && !(handle instanceof GridHandle)) {
                result = (ReportItemHandle)handle;
            }
            return result;
        }
        return null;
    }

    public static DataSetHandle getFirstDataSet(DesignElementHandle handle) {
        DataSetHandle dataSetHandle = null;
        if (handle instanceof ReportItemHandle) {
            dataSetHandle = ((ReportItemHandle)handle).getDataSet();
        }
        if (dataSetHandle == null) {
            for (DesignElementHandle elementHandle = handle; elementHandle != null; elementHandle = elementHandle.getContainer()) {
                if (!(elementHandle instanceof ListingHandle) || (dataSetHandle = ((ListingHandle)elementHandle).getDataSet()) == null) continue;
                return dataSetHandle;
            }
        }
        return dataSetHandle;
    }

    public static ListingHandle getListingContainer(DesignElementHandle container) {
        for (DesignElementHandle elementHandle = container; elementHandle != null; elementHandle = elementHandle.getContainer()) {
            if (!(elementHandle instanceof ListingHandle)) continue;
            return (ListingHandle)elementHandle;
        }
        return null;
    }

    public static ComputedColumnHandle addColumn(DesignElementHandle handle, ComputedColumn column, boolean inForce) throws SemanticException {
        Assert.isLegal((handle instanceof ReportItemHandle || handle instanceof GroupHandle ? 1 : 0) != 0);
        if (handle instanceof GroupHandle) {
            return ((GroupHandle)handle).addColumnBinding(column, inForce);
        }
        return ((ReportItemHandle)handle).addColumnBinding(column, inForce);
    }

    public static Iterator getBindingColumnIterator(DesignElementHandle handle) {
        if (handle instanceof GroupHandle) {
            return ((GroupHandle)handle).columnBindingsIterator();
        }
        if (handle instanceof ReportItemHandle) {
            return ((ReportItemHandle)handle).columnBindingsIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public static String getBindingexpression(DesignElementHandle baseElement, ComputedColumnHandle column) {
        String exp = "row";
        for (int i = 0; i < DEUtil.getBindingLevel(column.getElementHandle(), baseElement); ++i) {
            exp = exp + "._outer";
        }
        exp = exp + "[\"" + DEUtil.escape(column.getName()) + "\"]";
        return exp;
    }

    public static int getBindingLevel(DesignElementHandle holder, DesignElementHandle baseElement) {
        int level = 0;
        DesignElementHandle elementHandle = baseElement;
        while (elementHandle.getContainer() != null) {
            ReportItemHandle bindingHolder = DEUtil.getBindingHolder(elementHandle);
            if (bindingHolder == holder) {
                return level;
            }
            if (holder instanceof GroupHandle && bindingHolder == holder.getContainer()) {
                return level;
            }
            elementHandle = DEUtil.getBindingHolder(elementHandle).getContainer();
            ++level;
        }
        return -1;
    }

    public static boolean isLinked(DesignElementHandle handle) {
        if (handle.getExtends() != null) {
            return handle.getExtends().getRoot() instanceof LibraryHandle;
        }
        return false;
    }

    public static List getGroups(DesignElementHandle handle) {
        ArrayList<GroupHandle> groupList = new ArrayList<GroupHandle>();
        if (handle instanceof ListingHandle) {
            SlotHandle groupSlotHandle = ((ListingHandle)handle).getGroups();
            Iterator iter = groupSlotHandle.iterator();
            while (iter.hasNext()) {
                GroupHandle group = (GroupHandle)iter.next();
                groupList.add(group);
            }
            return groupList;
        }
        DesignElementHandle result = handle.getContainer();
        if (result != null) {
            if (result instanceof GroupHandle) {
                groupList.add((GroupHandle)result);
                return groupList;
            }
            return DEUtil.getGroups(result);
        }
        return groupList;
    }

    public static String getGroupControlType(DesignElementHandle handle) {
        if (handle instanceof ListingHandle) {
            return TYPE_GROUP_LISTING;
        }
        DesignElementHandle result = handle.getContainer();
        if (result != null) {
            if (result instanceof GroupHandle) {
                return TYPE_GROUP_GROUP;
            }
            return DEUtil.getGroupControlType(result);
        }
        return TYPE_GROUP_NONE;
    }

    public static String AddQuote(String string) {
        if (!(string == null || string.startsWith("\"") && string.endsWith("\""))) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public static String RemoveQuote(String string) {
        if (string != null && string.length() >= 2 && string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    static {
        $assertionsDisabled = !DEUtil.class.desiredAssertionStatus();
        propertiesMap = new HashMap();
        notSupportList = new ArrayList();
        propertiesMap.put("text", ELEMENT_LABELCONTENT_PROPERTY);
        propertiesMap.put("content", ELEMENT_LABELCONTENT_PROPERTY);
        notSupportList.add(DesignEngine.getMetaDataDictionary().getElement("Line"));
        notSupportList.add(DesignEngine.getMetaDataDictionary().getElement("TemplateReportItem"));
        notSupportList.add(DesignEngine.getMetaDataDictionary().getElement("FreeForm"));
        notSupportList.add(DesignEngine.getMetaDataDictionary().getElement("GraphicMasterPage"));
    }
}

