/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.ITableLayoutCalculator;

public class FixTableLayoutCalculator
implements ITableLayoutCalculator {
    private float tableWidth;
    private int colNum;
    private String[] definedWidthValues;
    private float[] tableWidthValues = null;
    private float fixWidthAmt;
    private float colMinSize;
    private float minWidthAmt;
    private int minAmt;

    public float[] getFloatColWidth() {
        if (this.definedWidthValues.length > 0) {
            this.colNum = this.definedWidthValues.length;
            this.tableWidthValues = new float[this.colNum];
            return this.calcColumnWidth();
        }
        return null;
    }

    public void setDefinedColWidth(String[] widthValues) {
        this.definedWidthValues = widthValues;
    }

    public float[] getRowHeight() {
        return null;
    }

    public void setTableWidth(float width) {
        this.tableWidth = width;
    }

    private float[] calcColumnWidth() throws NumberFormatException {
        this.fixWidthAmt = 0.0f;
        this.getFixNumColWidth();
        this.calPercentAndNullColWidth();
        this.adjustWidth();
        return this.tableWidthValues;
    }

    private void adjustWidth() {
        int i;
        float amt = 0.0f;
        if (this.minWidthAmt > this.tableWidth) {
            for (int i2 = 0; i2 < this.tableWidthValues.length; ++i2) {
                this.tableWidthValues[i2] = Math.max(this.colMinSize, this.tableWidthValues[i2]);
            }
            return;
        }
        for (int i3 = 0; i3 < this.tableWidthValues.length; ++i3) {
            amt += this.tableWidthValues[i3];
        }
        float adjustValue = 0.0f;
        if (this.tableWidth - amt > 0.0f) {
            adjustValue = (this.tableWidth - amt) / (float)this.minAmt;
            if (adjustValue - this.colMinSize < 0.0f) {
                adjustValue = this.colMinSize;
            }
            for (i = 0; i < this.tableWidthValues.length; ++i) {
                if (this.tableWidthValues[i] != 0.0f) continue;
                this.tableWidthValues[i] = adjustValue;
            }
        }
        amt = 0.0f;
        for (i = 0; i < this.tableWidthValues.length; ++i) {
            amt += this.tableWidthValues[i];
        }
        if (this.tableWidth <= (float)this.colNum * this.colMinSize) {
            for (i = 0; i < this.tableWidthValues.length; ++i) {
                this.tableWidthValues[i] = Math.max(this.colMinSize, this.tableWidthValues[i]);
            }
        } else {
            while ((double)Math.abs(amt - this.tableWidth) > 0.5) {
                adjustValue = this.tableWidth / amt;
                for (i = 0; i < this.tableWidthValues.length; ++i) {
                    this.tableWidthValues[i] = this.tableWidthValues[i] * adjustValue;
                    if (!(this.tableWidthValues[i] < this.colMinSize)) continue;
                    this.tableWidthValues[i] = this.colMinSize;
                }
                amt = 0.0f;
                for (i = 0; i < this.tableWidthValues.length; ++i) {
                    amt += this.tableWidthValues[i];
                }
            }
        }
    }

    private void calPercentAndNullColWidth() throws NumberFormatException {
        for (int i = 0; i < this.definedWidthValues.length; ++i) {
            try {
                Float.parseFloat(this.definedWidthValues[i]);
                continue;
            }
            catch (NumberFormatException e) {
                if (this.definedWidthValues[i].endsWith("%")) {
                    this.tableWidthValues[i] = this.tableWidth * this.getPercentValue(this.definedWidthValues[i]) / 100.0f;
                    if (this.tableWidthValues[i] < this.colMinSize) {
                        this.tableWidthValues[i] = 0.0f;
                        this.minWidthAmt += this.colMinSize;
                        ++this.minAmt;
                    }
                    this.fixWidthAmt += this.tableWidthValues[i];
                    continue;
                }
                if (this.definedWidthValues[i] == null | "".equalsIgnoreCase(this.definedWidthValues[i])) {
                    this.tableWidthValues[i] = 0.0f;
                    this.fixWidthAmt += this.tableWidthValues[i];
                    this.minWidthAmt += this.colMinSize;
                    ++this.minAmt;
                    continue;
                }
                throw e;
            }
        }
        this.setFixWidthAmt(this.fixWidthAmt);
    }

    private float getPercentValue(String value) {
        return Float.parseFloat(value.substring(0, value.indexOf("%")));
    }

    private void getFixNumColWidth() {
        float fixWidthAmt = 0.0f;
        for (int i = 0; i < this.definedWidthValues.length; ++i) {
            try {
                float width;
                this.tableWidthValues[i] = width = Float.parseFloat(this.definedWidthValues[i]);
                if (this.tableWidthValues[i] < this.colMinSize) {
                    this.tableWidthValues[i] = this.colMinSize;
                    this.minWidthAmt += this.colMinSize;
                    ++this.minAmt;
                }
                fixWidthAmt += width;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setFixWidthAmt(fixWidthAmt);
    }

    private void setFixWidthAmt(float widthAmt) {
        this.fixWidthAmt = widthAmt;
    }

    public void setColMinSize(float minSize) {
        this.colMinSize = minSize;
    }

    public int[] getIntColWidth() throws NumberFormatException {
        float[] width = null;
        width = this.getFloatColWidth();
        int amt = 0;
        if (width == null) {
            throw new NumberFormatException(Messages.getString("FixTableLayoutCalculator.Error.CannotParse"));
        }
        int[] intWidth = new int[width.length];
        for (int i = 0; i < width.length; ++i) {
            intWidth[i] = Math.round(width[i]);
            amt += intWidth[i];
        }
        int i = 0;
        for (int balance = amt - (int)this.tableWidth; balance > 0; --balance) {
            if ((float)intWidth[i] > this.colMinSize) {
                int n = i;
                intWidth[n] = intWidth[n] - 1;
            }
            if (++i >= intWidth.length - 1) break;
        }
        return intWidth;
    }

    public float[] getFloatRowHeight() {
        return null;
    }

    public float[] getIntRowHeight() {
        return null;
    }
}

