/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.browsers.BrowserDescriptor;
import org.eclipse.birt.report.viewer.browsers.BrowserManager;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreviewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button alwaysExternal;
    private Button svgFlag;
    private Button masterPageContent;
    private Button[] externalBrowsers;
    private Button customBrowserRadio;
    private Label customBrowserPathLabel;
    private Text customBrowserPath;
    private Button customBrowserBrowse;
    private Combo localeCombo;
    private IntegerFieldEditor maxRowEditor;
    public static final int DEFAULT_MAX_ROW = 500;
    private static final int MAX_MAX_ROW = Integer.MAX_VALUE;
    public static final String PREVIEW_MAXROW = "preview_maxrow";
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.Preference_BIRT_Preview_ID");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComposite.setLayout((Layout)layout);
        Label description = new Label(mainComposite, 0);
        description.setText(Messages.getString((String)"designer.preview.preference.browser.description"));
        this.createSpacer(mainComposite);
        Label localeDescription = new Label(mainComposite, 0);
        localeDescription.setText(Messages.getString((String)"designer.preview.preference.locale.description"));
        this.localeCombo = new Combo(mainComposite, 4);
        this.localeCombo.setLayoutData((Object)new GridData(512));
        if (!$assertionsDisabled && WebViewer.LocaleTable == null) {
            throw new AssertionError();
        }
        String[] localeDisplayNames = new String[WebViewer.LocaleTable.size()];
        WebViewer.LocaleTable.keySet().toArray(localeDisplayNames);
        this.localeCombo.setItems(localeDisplayNames);
        String defaultLocale = ViewerPlugin.getDefault().getPluginPreferences().getString("user_locale");
        if (defaultLocale == null || defaultLocale.trim().length() <= 0) {
            if (!$assertionsDisabled && ULocale.getDefault() == null) {
                throw new AssertionError();
            }
            defaultLocale = ULocale.getDefault().getDisplayName();
        }
        this.localeCombo.setText(defaultLocale);
        this.createSpacer(mainComposite);
        this.svgFlag = new Button(mainComposite, 32);
        this.svgFlag.setLayoutData((Object)new GridData(512));
        this.svgFlag.setText(Messages.getString((String)"designer.preview.preference.browser.svg"));
        this.svgFlag.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getBoolean("svg_flag"));
        this.masterPageContent = new Button(mainComposite, 32);
        this.masterPageContent.setLayoutData((Object)new GridData(512));
        this.masterPageContent.setText(Messages.getString((String)"designer.preview.preference.masterpagecontent"));
        this.masterPageContent.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getBoolean("master_page_content"));
        if (BrowserManager.getInstance().isEmbeddedBrowserPresent()) {
            this.alwaysExternal = new Button(mainComposite, 32);
            this.alwaysExternal.setLayoutData((Object)new GridData(512));
            this.alwaysExternal.setText(Messages.getString((String)"designer.preview.preference.browser.useExternal"));
            this.alwaysExternal.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getBoolean("always_external_browser"));
            this.createSpacer(mainComposite);
        }
        Label tableDescription = new Label(mainComposite, 0);
        tableDescription.setText(Messages.getString((String)"designer.preview.preference.browser.currentBrowsers"));
        Color bgColor = parent.getDisplay().getSystemColor(25);
        Color fgColor = parent.getDisplay().getSystemColor(24);
        ScrolledComposite externalBrowsersScrollable = new ScrolledComposite(mainComposite, 2816);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(2);
        externalBrowsersScrollable.setLayoutData((Object)gd);
        externalBrowsersScrollable.setBackground(bgColor);
        externalBrowsersScrollable.setForeground(fgColor);
        Composite externalBrowsersComposite = new Composite((Composite)externalBrowsersScrollable, 0);
        externalBrowsersScrollable.setContent((Control)externalBrowsersComposite);
        GridLayout layout2 = new GridLayout();
        externalBrowsersComposite.setLayout((Layout)layout2);
        externalBrowsersComposite.setBackground(bgColor);
        externalBrowsersComposite.setForeground(fgColor);
        BrowserDescriptor[] descriptors = BrowserManager.getInstance().getBrowserDescriptors();
        this.externalBrowsers = new Button[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            Button radio = new Button(externalBrowsersComposite, 16);
            Dialog.applyDialogFont((Control)radio);
            radio.setBackground(bgColor);
            radio.setForeground(fgColor);
            radio.setText(descriptors[i].getLabel());
            if (BrowserManager.getInstance().getCurrentBrowserID().equals(descriptors[i].getID())) {
                radio.setSelection(true);
            } else {
                radio.setSelection(false);
            }
            radio.setData((Object)descriptors[i]);
            this.externalBrowsers[i] = radio;
            if (!"org.eclipse.birt.report.viewer.custombrowser".equals(descriptors[i].getID())) continue;
            this.customBrowserRadio = radio;
            radio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selEvent) {
                    PreviewPreferencePage.this.setCustomBrowserPathEnabled();
                }

                public void widgetDefaultSelected(SelectionEvent selEvent) {
                    this.widgetSelected(selEvent);
                }
            });
        }
        externalBrowsersComposite.setSize(externalBrowsersComposite.computeSize(-1, -1));
        this.createCustomBrowserPathPart(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
        this.createSpacer(mainComposite);
        this.createIntFieldEditor(mainComposite);
        return mainComposite;
    }

    private void createCustomBrowserPathPart(Composite mainComposite) {
        Font font = mainComposite.getFont();
        new Label(mainComposite, 0);
        Composite bPathComposite = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        bPathComposite.setLayout((Layout)layout);
        bPathComposite.setLayoutData((Object)new GridData(768));
        this.customBrowserPathLabel = new Label(bPathComposite, 16384);
        this.customBrowserPathLabel.setFont(font);
        this.customBrowserPathLabel.setText(Messages.getString((String)"designer.preview.preference.browser.program"));
        this.customBrowserPath = new Text(bPathComposite, 2048);
        this.customBrowserPath.setLayoutData((Object)new GridData(768));
        this.customBrowserPath.setFont(font);
        this.customBrowserPath.setText(ViewerPlugin.getDefault().getPluginPreferences().getString("custom_browser_path"));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.widthHint = this.convertWidthInCharsToPixels(10);
        this.customBrowserPath.setLayoutData((Object)data);
        this.customBrowserBrowse = new Button(bPathComposite, 0);
        this.customBrowserBrowse.setFont(font);
        this.customBrowserBrowse.setText(Messages.getString((String)"designer.preview.preference.browser.browse"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.customBrowserBrowse.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.customBrowserBrowse.setLayoutData((Object)data);
        this.customBrowserBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                FileDialog d = new FileDialog(PreviewPreferencePage.this.getShell());
                d.setText(Messages.getString((String)"designer.preview.preference.browser.details"));
                String file = d.open();
                if (file != null) {
                    PreviewPreferencePage.this.customBrowserPath.setText("\"" + file + "\" %1");
                }
            }
        });
        this.setCustomBrowserPathEnabled();
    }

    private void createIntFieldEditor(Composite mainComposite) {
        Composite intFieldEditorComposite = new Composite(mainComposite, 0);
        this.maxRowEditor = new IntegerFieldEditor(PREVIEW_MAXROW, "", intFieldEditorComposite);
        GridLayout layout3 = new GridLayout();
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        layout3.numColumns = 2;
        intFieldEditorComposite.setLayout((Layout)layout3);
        intFieldEditorComposite.setLayoutData((Object)new GridData(768));
        Label lab2 = this.maxRowEditor.getLabelControl(intFieldEditorComposite);
        lab2.setText(Messages.getString((String)"designer.preview.preference.resultset.maxrow.description"));
        this.maxRowEditor.setPage((DialogPage)this);
        this.maxRowEditor.setTextLimit(Integer.toString(Integer.MAX_VALUE).length());
        this.maxRowEditor.setErrorMessage(Messages.getFormattedString((String)"designer.preview.preference.resultset.maxrow.errormessage", (Object[])new Object[]{new Integer(Integer.MAX_VALUE)}));
        this.maxRowEditor.setValidateStrategy(0);
        this.maxRowEditor.setValidRange(1, Integer.MAX_VALUE);
        this.maxRowEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    PreviewPreferencePage.this.setValid(PreviewPreferencePage.this.maxRowEditor.isValid());
                }
            }
        });
        String defaultMaxRow = ViewerPlugin.getDefault().getPluginPreferences().getString(PREVIEW_MAXROW);
        if (defaultMaxRow == null || defaultMaxRow.trim().length() <= 0) {
            defaultMaxRow = String.valueOf(500);
        }
        this.maxRowEditor.setStringValue(defaultMaxRow);
    }

    protected void performDefaults() {
        String defaultBrowserID = BrowserManager.getInstance().getDefaultBrowserID();
        for (int i = 0; i < this.externalBrowsers.length; ++i) {
            BrowserDescriptor descriptor = (BrowserDescriptor)this.externalBrowsers[i].getData();
            this.externalBrowsers[i].setSelection(descriptor.getID() == defaultBrowserID);
        }
        this.customBrowserPath.setText(ViewerPlugin.getDefault().getPluginPreferences().getDefaultString("custom_browser_path"));
        this.setCustomBrowserPathEnabled();
        if (this.svgFlag != null) {
            this.svgFlag.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getDefaultBoolean("svg_flag"));
        }
        if (this.masterPageContent != null) {
            this.masterPageContent.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getDefaultBoolean("master_page_content"));
        }
        if (this.alwaysExternal != null) {
            this.alwaysExternal.setSelection(ViewerPlugin.getDefault().getPluginPreferences().getDefaultBoolean("always_external_browser"));
        }
        if (this.localeCombo != null) {
            ULocale defaultLocale = ULocale.getDefault();
            if (!$assertionsDisabled && defaultLocale == null) {
                throw new AssertionError();
            }
            this.localeCombo.setText(defaultLocale.getDisplayName());
        }
        this.maxRowEditor.setStringValue(String.valueOf(500));
        super.performDefaults();
    }

    public boolean performOk() {
        Preferences pref = ViewerPlugin.getDefault().getPluginPreferences();
        for (int i = 0; i < this.externalBrowsers.length; ++i) {
            if (!this.externalBrowsers[i].getSelection()) continue;
            String browserID = ((BrowserDescriptor)this.externalBrowsers[i].getData()).getID();
            BrowserManager.getInstance().setCurrentBrowserID(browserID);
            pref.setValue("default_browser", browserID);
            break;
        }
        this.customBrowserPath.getText();
        pref.setValue("custom_browser_path", this.customBrowserPath.getText());
        if (this.svgFlag != null) {
            pref.setValue("svg_flag", this.svgFlag.getSelection());
        }
        if (this.masterPageContent != null) {
            pref.setValue("master_page_content", this.masterPageContent.getSelection());
        }
        if (this.alwaysExternal != null) {
            pref.setValue("always_external_browser", this.alwaysExternal.getSelection());
            BrowserManager.getInstance().setAlwaysUseExternal(this.alwaysExternal.getSelection());
        }
        if (this.localeCombo != null) {
            pref.setValue("user_locale", this.localeCombo.getText());
        }
        ViewerPlugin.getDefault().savePluginPreferences();
        ViewerPlugin.getDefault().getPluginPreferences().setValue(PREVIEW_MAXROW, this.maxRowEditor.getStringValue());
        return true;
    }

    private void setCustomBrowserPathEnabled() {
        boolean enabled = this.customBrowserRadio.getSelection();
        this.customBrowserPathLabel.setEnabled(enabled);
        this.customBrowserPath.setEnabled(enabled);
        this.customBrowserBrowse.setEnabled(enabled);
    }

    private void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    public void init(IWorkbench workbench) {
    }

    static {
        $assertionsDisabled = !PreviewPreferencePage.class.desiredAssertionStatus();
    }
}

