/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.StackGroup;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.emf.common.util.EList;

public final class StackedSeriesLookup {
    private final Hashtable htAxisToStackGroups = new Hashtable();
    private final Hashtable htSeriesToStackGroup = new Hashtable();
    private int iCachedUnitCount = 0;

    StackedSeriesLookup(RunTimeContext rtc) {
    }

    public final ArrayList getStackGroups(Axis ax) {
        return (ArrayList)this.htAxisToStackGroups.get(ax);
    }

    public final int getSeriesCount(Axis ax) {
        ArrayList alSG = (ArrayList)this.htAxisToStackGroups.get(ax);
        if (alSG == null || alSG.isEmpty()) {
            return 0;
        }
        int iCount = 0;
        for (int i = 0; i < alSG.size(); ++i) {
            StackGroup sg = (StackGroup)alSG.get(i);
            iCount += sg.alSeries.size();
        }
        return iCount;
    }

    public final StackGroup getStackGroup(Series se) {
        return (StackGroup)this.htSeriesToStackGroup.get(se);
    }

    public final AxisSubUnit getSubUnit(StackGroup sg, int iUnitIndex) {
        if (sg == null || !this.htSeriesToStackGroup.contains(sg)) {
            return null;
        }
        if (sg.alUnitPositions == null) {
            sg.alUnitPositions = new ArrayList(8);
        }
        if (sg.alUnitPositions.size() <= iUnitIndex) {
            sg.alUnitPositions.add(new AxisSubUnit());
        }
        return (AxisSubUnit)sg.alUnitPositions.get(iUnitIndex);
    }

    public final AxisSubUnit getUnit(Series se, int iUnitIndex) {
        StackGroup sg = (StackGroup)this.htSeriesToStackGroup.get(se);
        if (sg == null) {
            return null;
        }
        if (sg.alUnitPositions == null) {
            sg.alUnitPositions = new ArrayList(8);
        }
        if (sg.alUnitPositions.size() <= iUnitIndex) {
            sg.alUnitPositions.add(new AxisSubUnit());
        }
        return (AxisSubUnit)sg.alUnitPositions.get(iUnitIndex);
    }

    public final void resetSubUnits() {
        Enumeration e = this.htSeriesToStackGroup.elements();
        while (e.hasMoreElements()) {
            StackGroup sg = (StackGroup)e.nextElement();
            if (sg.alUnitPositions == null) continue;
            for (int i = 0; i < sg.alUnitPositions.size(); ++i) {
                AxisSubUnit asu = (AxisSubUnit)sg.alUnitPositions.get(i);
                asu.reset();
            }
        }
    }

    static final StackedSeriesLookup create(ChartWithAxes cwa, RunTimeContext rtc) throws ChartException, IllegalArgumentException {
        if (cwa == null) {
            return null;
        }
        StackedSeriesLookup ssl = new StackedSeriesLookup(rtc);
        Axis axBase = cwa.getBaseAxes()[0];
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axBase, true);
        DataSetIterator dsi = null;
        for (int i = 0; i < axaOrthogonal.length; ++i) {
            StackGroup sg;
            int j;
            int iSharedUnitIndex = 0;
            int iSharedUnitCount = 0;
            StackGroup sgSingle = null;
            EList el = axaOrthogonal[i].getSeriesDefinitions();
            ArrayList<StackGroup> alSGCopies = new ArrayList<StackGroup>(4);
            iSharedUnitCount = 0;
            for (j = 0; j < el.size(); ++j) {
                int iDataSetCount;
                Series se;
                int k;
                SeriesDefinition sd = (SeriesDefinition)el.get(j);
                ArrayList alSeries = sd.getRunTimeSeries();
                int iSeriesCount = alSeries.size();
                if (iSeriesCount > 1) {
                    boolean bStackedSet = false;
                    sg = null;
                    for (k = 0; k < iSeriesCount; ++k) {
                        se = (Series)alSeries.get(k);
                        dsi = new DataSetIterator(se.getDataSet());
                        iDataSetCount = dsi.size();
                        if (ssl.iCachedUnitCount == 0) {
                            ssl.iCachedUnitCount = iDataSetCount;
                        } else if (ssl.iCachedUnitCount != iDataSetCount) {
                            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.runtime.dataset.count.mismatch"), new Integer(ssl.iCachedUnitCount), new Integer(iDataSetCount)));
                        }
                        if (se.canBeStacked()) {
                            if (!se.isSetStacked()) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 13, "exception.unset.series.stacked.property", new Object[]{se}, Messages.getResourceBundle(rtc.getULocale()));
                            }
                            if (se.canShareAxisUnit()) {
                                if (se.isStacked()) {
                                    if (k > 0 && !bStackedSet) {
                                        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                    }
                                    if (k == 0) {
                                        sg = new StackGroup(iSharedUnitIndex++);
                                        alSGCopies.add(sg);
                                        ++iSharedUnitCount;
                                    }
                                    bStackedSet = true;
                                    ssl.htSeriesToStackGroup.put(se, sg);
                                    sg.addSeries(se);
                                    continue;
                                }
                                if (k > 0 && bStackedSet) {
                                    throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                }
                                sg = new StackGroup(iSharedUnitIndex++);
                                alSGCopies.add(sg);
                                ++iSharedUnitCount;
                                ssl.htSeriesToStackGroup.put(se, sg);
                                sg.addSeries(se);
                                continue;
                            }
                            if (se.isStacked()) {
                                if (k > 0 && !bStackedSet) {
                                    throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                                }
                                if (k == 0) {
                                    sg = new StackGroup(-1);
                                    alSGCopies.add(sg);
                                }
                                bStackedSet = true;
                                ssl.htSeriesToStackGroup.put(se, sg);
                                sg.addSeries(se);
                                continue;
                            }
                            if (k > 0 && bStackedSet) {
                                throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.stacked.unstacked.mix.series"), sd));
                            }
                            sg = new StackGroup(-1);
                            alSGCopies.add(sg);
                            ssl.htSeriesToStackGroup.put(se, sg);
                            sg.addSeries(se);
                            continue;
                        }
                        sg = new StackGroup(-1);
                        alSGCopies.add(sg);
                        ssl.htSeriesToStackGroup.put(se, sg);
                        sg.addSeries(se);
                    }
                    continue;
                }
                for (k = 0; k < iSeriesCount; ++k) {
                    se = (Series)alSeries.get(k);
                    dsi = new DataSetIterator(se.getDataSet());
                    iDataSetCount = dsi.size();
                    if (ssl.iCachedUnitCount == 0) {
                        ssl.iCachedUnitCount = iDataSetCount;
                    } else if (ssl.iCachedUnitCount != iDataSetCount) {
                        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(rtc.getULocale()).getString("exception.runtime.dataset.count.mismatch"), new Integer(ssl.iCachedUnitCount), new Integer(iDataSetCount)));
                    }
                    if (se.canBeStacked()) {
                        if (se.canShareAxisUnit()) {
                            if (se.isStacked()) {
                                if (sgSingle == null) {
                                    sgSingle = new StackGroup(iSharedUnitIndex++);
                                    alSGCopies.add(sgSingle);
                                    ++iSharedUnitCount;
                                }
                                ssl.htSeriesToStackGroup.put(se, sgSingle);
                                sgSingle.addSeries(se);
                                continue;
                            }
                            sg = new StackGroup(iSharedUnitIndex++);
                            ++iSharedUnitCount;
                            alSGCopies.add(sg);
                            ssl.htSeriesToStackGroup.put(se, sg);
                            sg.addSeries(se);
                            continue;
                        }
                        sg = new StackGroup(-1);
                        alSGCopies.add(sg);
                        ssl.htSeriesToStackGroup.put(se, sg);
                        sg.addSeries(se);
                        continue;
                    }
                    sg = new StackGroup(-1);
                    alSGCopies.add(sg);
                    ssl.htSeriesToStackGroup.put(se, sg);
                    sg.addSeries(se);
                }
            }
            if (iSharedUnitCount < 1) {
                iSharedUnitCount = 1;
            }
            for (j = 0; j < alSGCopies.size(); ++j) {
                sg = (StackGroup)alSGCopies.get(j);
                sg.updateCount(iSharedUnitCount);
            }
            ssl.htAxisToStackGroups.put(axaOrthogonal[i], alSGCopies);
        }
        return ssl;
    }

    public final int getUnitCount() {
        return this.iCachedUnitCount;
    }
}

