/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.layout;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;

public final class LayoutManager {
    public LayoutManager(Block _blRoot) {
    }

    private void doLayout_tmp(IDisplayServer xs, Chart cm, Bounds boFull, RunTimeContext rtc) throws ChartException {
        Block cbl;
        Size szLegend;
        boolean isRightToLeft = rtc.isRightToLeft();
        Block bl = cm.getBlock();
        bl.setBounds(boFull);
        Insets ins = bl.getInsets();
        Bounds bo = boFull.adjustedInstance(ins);
        Legend lg = cm.getLegend();
        Plot p = cm.getPlot();
        TitleBlock tb = cm.getTitle();
        Size szTitle = !tb.isVisible() ? SizeImpl.create(0.0, 0.0) : tb.getPreferredSize(xs, cm, rtc);
        Bounds boPlot = p.getBounds();
        Bounds boLegend = lg.getBounds();
        Bounds boTitle = tb.getBounds();
        boTitle.setLeft(bo.getLeft());
        boTitle.setWidth(bo.getWidth());
        boTitle.setTop(bo.getTop());
        boTitle.setHeight(szTitle.getHeight());
        Size size = szLegend = !lg.isVisible() ? SizeImpl.create(0.0, 0.0) : lg.getPreferredSize(xs, cm, rtc);
        if (!lg.isSetPosition()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, Messages.getString("error.legend.position", ULocale.getDefault()));
        }
        double plotWidthHint = -1.0;
        double plotHeightHint = -1.0;
        if (p.isSetWidthHint()) {
            plotWidthHint = p.getWidthHint();
        }
        if (p.isSetHeightHint()) {
            plotHeightHint = p.getHeightHint();
        }
        Position po = lg.getPosition();
        if (isRightToLeft) {
            if (po == Position.RIGHT_LITERAL) {
                po = Position.LEFT_LITERAL;
            } else if (po == Position.LEFT_LITERAL) {
                po = Position.RIGHT_LITERAL;
            }
        }
        Anchor anchor = p.getAnchor();
        if (isRightToLeft) {
            switch (anchor.getValue()) {
                case 2: {
                    anchor = Anchor.WEST_LITERAL;
                    break;
                }
                case 1: {
                    anchor = Anchor.NORTH_WEST_LITERAL;
                    break;
                }
                case 3: {
                    anchor = Anchor.SOUTH_WEST_LITERAL;
                    break;
                }
                case 6: {
                    anchor = Anchor.EAST_LITERAL;
                    break;
                }
                case 7: {
                    anchor = Anchor.NORTH_EAST_LITERAL;
                    break;
                }
                case 5: {
                    anchor = Anchor.SOUTH_EAST_LITERAL;
                }
            }
        }
        switch (po.getValue()) {
            case 4: {
                boPlot.setWidth(plotWidthHint < 0.0 ? bo.getWidth() : plotWidthHint);
                boPlot.setHeight(plotHeightHint < 0.0 ? bo.getHeight() - szTitle.getHeight() : plotHeightHint);
                double plotLeft = bo.getLeft();
                double plotTop = bo.getTop() + szTitle.getHeight();
                switch (anchor.getValue()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        plotLeft = plotLeft + bo.getWidth() - boPlot.getWidth();
                        break;
                    }
                    case 0: 
                    case 4: {
                        plotLeft += (bo.getWidth() - boPlot.getWidth()) / 2.0;
                    }
                }
                switch (anchor.getValue()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        plotTop = plotTop + bo.getHeight() - szTitle.getHeight() - boPlot.getHeight();
                        break;
                    }
                    case 2: 
                    case 6: {
                        plotTop += (bo.getHeight() - szTitle.getHeight() - boPlot.getHeight()) / 2.0;
                    }
                }
                boPlot.setLeft(plotLeft);
                boPlot.setTop(plotTop);
                boLegend.set(0.0, 0.0, szLegend.getWidth(), szLegend.getHeight());
                break;
            }
            case 3: 
            case 5: {
                boLegend.setTop(bo.getTop() + szTitle.getHeight());
                boLegend.setLeft(bo.getLeft() + bo.getWidth() - szLegend.getWidth());
                boLegend.setWidth(szLegend.getWidth());
                boLegend.setHeight(bo.getHeight() - szTitle.getHeight());
                boPlot.setWidth(plotWidthHint < 0.0 ? bo.getWidth() - boLegend.getWidth() : plotWidthHint);
                boPlot.setHeight(plotHeightHint < 0.0 ? bo.getHeight() - szTitle.getHeight() : plotHeightHint);
                double plotLeft = bo.getLeft();
                double plotTop = bo.getTop() + szTitle.getHeight();
                switch (anchor.getValue()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        plotLeft = plotLeft + bo.getWidth() - boLegend.getWidth() - boPlot.getWidth();
                        break;
                    }
                    case 0: 
                    case 4: {
                        plotLeft += (bo.getWidth() - boLegend.getWidth() - boPlot.getWidth()) / 2.0;
                    }
                }
                switch (anchor.getValue()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        plotTop = plotTop + bo.getHeight() - szTitle.getHeight() - boPlot.getHeight();
                        break;
                    }
                    case 2: 
                    case 6: {
                        plotTop += (bo.getHeight() - szTitle.getHeight() - boPlot.getHeight()) / 2.0;
                    }
                }
                boPlot.setLeft(plotLeft);
                boPlot.setTop(plotTop);
                break;
            }
            case 2: {
                boLegend.setTop(bo.getTop() + szTitle.getHeight());
                boLegend.setLeft(bo.getLeft());
                boLegend.setWidth(szLegend.getWidth());
                boLegend.setHeight(bo.getHeight() - szTitle.getHeight());
                boPlot.setWidth(plotWidthHint < 0.0 ? bo.getWidth() - boLegend.getWidth() : plotWidthHint);
                boPlot.setHeight(plotHeightHint < 0.0 ? bo.getHeight() - szTitle.getHeight() : plotHeightHint);
                double plotLeft = bo.getLeft() + szLegend.getWidth();
                double plotTop = bo.getTop() + szTitle.getHeight();
                switch (anchor.getValue()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        plotLeft = plotLeft + bo.getWidth() - boLegend.getWidth() - boPlot.getWidth();
                        break;
                    }
                    case 0: 
                    case 4: {
                        plotLeft += (bo.getWidth() - boLegend.getWidth() - boPlot.getWidth()) / 2.0;
                    }
                }
                switch (anchor.getValue()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        plotTop = plotTop + bo.getHeight() - szTitle.getHeight() - boPlot.getHeight();
                        break;
                    }
                    case 2: 
                    case 6: {
                        plotTop += (bo.getHeight() - szTitle.getHeight() - boPlot.getHeight()) / 2.0;
                    }
                }
                boPlot.setLeft(plotLeft);
                boPlot.setTop(plotTop);
                break;
            }
            case 0: {
                boLegend.setTop(bo.getTop() + szTitle.getHeight());
                boLegend.setLeft(bo.getLeft());
                boLegend.setWidth(bo.getWidth());
                boLegend.setHeight(szLegend.getHeight());
                boPlot.setWidth(plotWidthHint < 0.0 ? bo.getWidth() : plotWidthHint);
                boPlot.setHeight(plotHeightHint < 0.0 ? bo.getHeight() - szTitle.getHeight() - boLegend.getHeight() : plotHeightHint);
                double plotLeft = bo.getLeft();
                double plotTop = bo.getTop() + szTitle.getHeight() + boLegend.getHeight();
                switch (anchor.getValue()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        plotLeft = plotLeft + bo.getWidth() - boPlot.getWidth();
                        break;
                    }
                    case 0: 
                    case 4: {
                        plotLeft += (bo.getWidth() - boPlot.getWidth()) / 2.0;
                    }
                }
                switch (anchor.getValue()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        plotTop = plotTop + bo.getHeight() - szTitle.getHeight() - boLegend.getHeight() - boPlot.getHeight();
                        break;
                    }
                    case 2: 
                    case 6: {
                        plotTop += (bo.getHeight() - szTitle.getHeight() - boLegend.getHeight() - boPlot.getHeight()) / 2.0;
                    }
                }
                boPlot.setLeft(plotLeft);
                boPlot.setTop(plotTop);
                break;
            }
            case 1: {
                boLegend.setTop(bo.getTop() + bo.getHeight() - szLegend.getHeight());
                boLegend.setLeft(bo.getLeft());
                boLegend.setWidth(bo.getWidth());
                boLegend.setHeight(szLegend.getHeight());
                boPlot.setWidth(plotWidthHint < 0.0 ? bo.getWidth() : plotWidthHint);
                boPlot.setHeight(plotHeightHint < 0.0 ? bo.getHeight() - boTitle.getHeight() - boLegend.getHeight() : plotHeightHint);
                double plotLeft = bo.getLeft();
                double plotTop = bo.getTop() + szTitle.getHeight();
                switch (anchor.getValue()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        plotLeft = plotLeft + bo.getWidth() - boPlot.getWidth();
                        break;
                    }
                    case 0: 
                    case 4: {
                        plotLeft += (bo.getWidth() - boPlot.getWidth()) / 2.0;
                    }
                }
                switch (anchor.getValue()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        plotTop = plotTop + bo.getHeight() - szTitle.getHeight() - boLegend.getHeight() - boPlot.getHeight();
                        break;
                    }
                    case 2: 
                    case 6: {
                        plotTop += (bo.getHeight() - szTitle.getHeight() - boLegend.getHeight() - boPlot.getHeight()) / 2.0;
                    }
                }
                boPlot.setLeft(plotLeft);
                boPlot.setTop(plotTop);
            }
        }
        Iterator itr = bl.getChildren().iterator();
        while (itr.hasNext()) {
            cbl = (Block)itr.next();
            if (cbl == lg || cbl == p || cbl == tb) continue;
            this.layoutBlock(xs, cm, bl.getBounds(), bl.getInsets(), cbl, rtc);
        }
        itr = lg.getChildren().iterator();
        while (itr.hasNext()) {
            cbl = (Block)itr.next();
            this.layoutBlock(xs, cm, lg.getBounds(), lg.getInsets(), cbl, rtc);
        }
        itr = tb.getChildren().iterator();
        while (itr.hasNext()) {
            cbl = (Block)itr.next();
            this.layoutBlock(xs, cm, tb.getBounds(), tb.getInsets(), cbl, rtc);
        }
        itr = p.getChildren().iterator();
        while (itr.hasNext()) {
            cbl = (Block)itr.next();
            this.layoutBlock(xs, cm, p.getBounds(), p.getInsets(), cbl, rtc);
        }
    }

    private void layoutBlock(IDisplayServer xs, Chart cm, Bounds bo, Insets ins, Block block, RunTimeContext rtc) throws ChartException {
        if (!block.isSetAnchor()) {
            return;
        }
        Bounds cbo = block.getBounds();
        if (cbo == null) {
            cbo = BoundsImpl.create(0.0, 0.0, 0.0, 0.0);
        } else if (cbo.getLeft() != 0.0 || cbo.getTop() != 0.0 || cbo.getWidth() != 0.0 || cbo.getHeight() != 0.0) {
            return;
        }
        bo = bo.adjustedInstance(ins);
        Anchor anchor = block.getAnchor();
        if (rtc != null && rtc.isRightToLeft()) {
            switch (anchor.getValue()) {
                case 2: {
                    anchor = Anchor.WEST_LITERAL;
                    break;
                }
                case 1: {
                    anchor = Anchor.NORTH_WEST_LITERAL;
                    break;
                }
                case 3: {
                    anchor = Anchor.SOUTH_WEST_LITERAL;
                    break;
                }
                case 6: {
                    anchor = Anchor.EAST_LITERAL;
                    break;
                }
                case 7: {
                    anchor = Anchor.NORTH_EAST_LITERAL;
                    break;
                }
                case 5: {
                    anchor = Anchor.SOUTH_EAST_LITERAL;
                }
            }
        }
        Size sz = block.getPreferredSize(xs, cm, rtc);
        cbo.setWidth(sz.getWidth());
        cbo.setHeight(sz.getHeight());
        switch (anchor.getValue()) {
            case 2: {
                cbo.setLeft(bo.getLeft() + bo.getWidth() - sz.getWidth());
                cbo.setTop(bo.getTop() + (bo.getHeight() - sz.getHeight()) / 2.0);
                break;
            }
            case 0: {
                cbo.setLeft(bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0);
                cbo.setTop(bo.getTop());
                break;
            }
            case 1: {
                cbo.setLeft(bo.getLeft() + bo.getWidth() - sz.getWidth());
                cbo.setTop(bo.getTop());
                break;
            }
            case 7: {
                cbo.setLeft(bo.getLeft());
                cbo.setTop(bo.getTop());
                break;
            }
            case 4: {
                cbo.setLeft(bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0);
                cbo.setTop(bo.getTop() + bo.getHeight() - sz.getHeight());
                break;
            }
            case 3: {
                cbo.setLeft(bo.getLeft() + bo.getWidth() - sz.getWidth());
                cbo.setTop(bo.getTop() + bo.getHeight() - sz.getHeight());
                break;
            }
            case 5: {
                cbo.setLeft(bo.getLeft());
                cbo.setTop(bo.getTop() + bo.getHeight() - sz.getHeight());
                break;
            }
            case 6: {
                cbo.setLeft(bo.getLeft());
                cbo.setTop(bo.getTop() + (bo.getHeight() - sz.getHeight()) / 2.0);
            }
        }
        block.setBounds(cbo);
    }

    public void doLayout(IDisplayServer xs, Chart cm, Bounds bo, RunTimeContext rtc) throws ChartException {
        this.doLayout_tmp(xs, cm, bo, rtc);
    }
}

