/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.internal.rcp.wizards.WizardNewReportCreationPage;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class NewReportTemplateWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String NEW = Messages.getString((String)"NewTemplateWizard.title.New");
    private static final String REPORT = Messages.getString((String)"NewTemplateWizard.title.Template");
    private static final String WIZARDPAGE = Messages.getString((String)"NewTemplateWizard.title.WizardPage");
    private static final String CREATE_A_NEW_REPORT = Messages.getString((String)"NewTemplateWizard.text.CreateReport");
    private static final String CREATING = Messages.getString((String)"NewTemplateWizard.text.Creating");
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewTemplateWizard.text.OpenFileForEditing");
    private static final String NEW_REPORT_FILE_NAME_PREFIX = Messages.getString((String)"NewTemplateWizard.displayName.NewReportFileNamePrefix");
    private static final String NEW_REPORT_FILE_EXTENSION = ".rpttemplate";
    private static final String TEMPLATE_FILE = "/templates/blank_report.rptdesign";
    private WizardNewReportCreationPage newReportFileWizardPage;
    private WizardReportSettingPage settingPage;

    public NewReportTemplateWizard() {
        this.setWindowTitle(NEW);
    }

    public Image getDefaultPageImage() {
        return ReportPlugin.getImage((String)"/icons/wizban/create_report_wizard.gif");
    }

    public void addPages() {
        this.newReportFileWizardPage = new WizardNewReportCreationPage(WIZARDPAGE);
        this.addPage((IWizardPage)this.newReportFileWizardPage);
        this.newReportFileWizardPage.setTitle(REPORT);
        this.newReportFileWizardPage.setDescription(CREATE_A_NEW_REPORT);
        this.newReportFileWizardPage.setInitialFileName(this.getNewFileFullName(NEW_REPORT_FILE_NAME_PREFIX));
        this.newReportFileWizardPage.setInitialFileLocation(this.getDefaultLocation());
        this.settingPage = new WizardReportSettingPage(null);
        this.settingPage.setTitle(Messages.getFormattedString((String)"SaveReportAsWizard.SettingPage.title", (Object[])new Object[]{Messages.getString((String)"NewTemplateWizard.WizardPageTitle.Template")}));
        this.addPage((IWizardPage)this.settingPage);
    }

    private String getDefaultLocation() {
        IPath defaultPath = Platform.getLocation();
        return defaultPath.toOSString();
    }

    private String getNewFileFullName(String defaultName) {
        String extension = NEW_REPORT_FILE_EXTENSION;
        String path = this.getDefaultLocation();
        String name = defaultName + extension;
        int count = 0;
        File file = new File(path, name);
        while (file.exists()) {
            name = defaultName + "_" + ++count + extension;
            file = null;
            file = new File(path, name);
        }
        file = null;
        return name;
    }

    public boolean performFinish() {
        final IPath locPath = this.newReportFileWizardPage.getFileLocationFullPath();
        String fn = this.newReportFileWizardPage.getFileName();
        final String fileName = !fn.endsWith(NEW_REPORT_FILE_EXTENSION) ? fn + NEW_REPORT_FILE_EXTENSION : fn;
        InputStream inputData = null;
        URL url = Platform.find((Bundle)Platform.getBundle((String)"org.eclipse.birt.report.designer.ui"), (IPath)new Path(TEMPLATE_FILE));
        if (url != null) {
            try {
                inputData = url.openStream();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        final InputStream stream = inputData;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                try {
                    NewReportTemplateWizard.this.doFinish(locPath, fileName, stream, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionHandler.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private void doFinish(IPath locationPath, String fileName, InputStream stream, IProgressMonitor monitor) {
        monitor.beginTask(CREATING + fileName, 2);
        final File file = new File(locationPath.toString(), fileName);
        try {
            File container = new File(locationPath.toString());
            if (!container.exists()) {
                container.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            byte[] buff = new byte[stream.available()];
            stream.read(buff);
            out.write(buff);
            out.close();
            stream.close();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    if (page == null) {
                        throw new IllegalArgumentException();
                    }
                    IEditorPart editorPart = page.openEditor((IEditorInput)new ReportEditorInput(file), "org.eclipse.birt.report.designer.ui.editors.TemplateEditor", true);
                    ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    if (ReportPlugin.getDefault().getEnableCommentPreference()) {
                        model.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
                    }
                    NewReportTemplateWizard.this.setReportSettings(model);
                    editorPart.doSave(null);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    public boolean canFinish() {
        return this.newReportFileWizardPage.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    void setReportSettings(Object model) throws IOException {
        ReportDesignHandle handle = (ReportDesignHandle)model;
        try {
            handle.setDisplayName(this.settingPage.getDisplayName());
            handle.setDescription(this.settingPage.getDescription());
            handle.setIconFile(this.settingPage.getPreviewImagePath());
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        handle.save();
    }
}

