/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.wizards;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.internal.rcp.wizards.WizardSaveAsPage;
import org.eclipse.birt.report.designer.ui.rcp.nls.DesignerWorkbenchMessages;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;

public class SaveReportAsWizard
extends Wizard {
    private ReportDesignHandle model;
    private IEditorInput orginalFile;
    private WizardSaveAsPage saveAsPage;
    private WizardReportSettingPage settingPage;
    private IPath saveAsPath;

    public SaveReportAsWizard(ReportDesignHandle model, IEditorInput orginalFile) {
        this.setWindowTitle(DesignerWorkbenchMessages.SaveAsWizardWindowTitle);
        this.model = model;
        this.orginalFile = orginalFile;
    }

    public void addPages() {
        this.saveAsPage = new WizardSaveAsPage("WizardSaveAsPage");
        this.saveAsPage.setOriginalFile(this.orginalFile);
        this.saveAsPage.setTitle(DesignerWorkbenchMessages.SaveAsWizardPageTitle);
        this.saveAsPage.setMessage(DesignerWorkbenchMessages.SaveAsWizardPageDesc);
        this.addPage((IWizardPage)this.saveAsPage);
        this.settingPage = new WizardReportSettingPage(this.model);
        this.settingPage.setTitle(DesignerWorkbenchMessages.ReportSettingPageTitle);
        this.settingPage.setMessage(Messages.getString((String)"SaveReportAsWizard.SettingPage.message"));
        this.addPage((IWizardPage)this.settingPage);
    }

    public boolean canFinish() {
        return this.saveAsPage.validatePage();
    }

    public boolean performFinish() {
        this.saveAsPath = this.saveAsPage.getResult();
        if (this.saveAsPath != null) {
            try {
                this.model.setDisplayName(this.settingPage.getDisplayName());
                this.model.setDescription(this.settingPage.getDescription());
                this.model.setIconFile(this.settingPage.getPreviewImagePath());
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return true;
    }

    public IPath getSaveAsPath() {
        return this.saveAsPath;
    }
}

