/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLCompleteImageHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IImage;

public class HTMLServerImageHandler
implements IHTMLImageHandler {
    protected Logger log = Logger.getLogger(HTMLServerImageHandler.class.getName());
    private static int count;
    private static HashMap map;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String onDesignImage(IImage image, Object context) {
        return this.handleImage(image, context, "design", true);
    }

    public String onDocImage(IImage image, Object context) {
        return null;
    }

    public String onURLImage(IImage image, Object context) {
        if (!$assertionsDisabled && image == null) {
            throw new AssertionError();
        }
        return image.getID();
    }

    public String onCustomImage(IImage image, Object context) {
        return this.handleImage(image, context, "custom", false);
    }

    protected String createUniqueFileName(String imageDir, String prefix, String postfix) {
        File file = null;
        while ((file = new File(imageDir + "/" + prefix + ++count + postfix)).exists()) {
        }
        return prefix + count + postfix;
    }

    protected String createUniqueFileName(String imageDir, String prefix) {
        File file = null;
        while ((file = new File(imageDir + "/" + prefix + ++count)).exists()) {
        }
        return prefix + count;
    }

    public String onFileImage(IImage image, Object context) {
        return this.handleImage(image, context, "file", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleImage(IImage image, Object context, String prefix, boolean needMap) {
        String mapID = null;
        if (needMap && map.containsKey(mapID = this.getImageMapID(image))) {
            return (String)map.get(mapID);
        }
        String ret = null;
        if (context != null && context instanceof HTMLRenderContext) {
            String fileName;
            HTMLRenderContext myContext = (HTMLRenderContext)context;
            String imageURL = myContext.getBaseImageURL();
            String imageDir = myContext.getImageDirectory();
            if (imageURL == null || imageURL.length() == 0 || imageDir == null || imageDir.length() == 0) {
                this.log.log(Level.SEVERE, "imageURL or ImageDIR is not set!");
                return null;
            }
            Class clazz = HTMLCompleteImageHandler.class;
            synchronized (clazz) {
                String extension = image.getExtension();
                fileName = extension != null && extension.length() > 0 ? this.createUniqueFileName(imageDir, prefix, extension) : this.createUniqueFileName(imageDir, prefix);
                File file = new File(imageDir, fileName);
                try {
                    image.writeImage(file);
                }
                catch (IOException e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            ret = imageURL.indexOf("?") > 0 ? imageURL + fileName : (imageURL.endsWith("/") ? imageURL + fileName : imageURL + "/" + fileName);
            if (needMap) {
                map.put(mapID, ret);
            }
        } else {
            ret = this.handleTempImage(image, prefix, needMap);
        }
        return ret;
    }

    protected String handleTempImage(IImage image, String prefix, boolean needMap) {
        try {
            File imageFile = File.createTempFile(prefix, ".img");
            image.writeImage(imageFile);
            String fileName = imageFile.getAbsolutePath();
            if (needMap) {
                String mapID = this.getImageMapID(image);
                map.put(mapID, fileName);
            }
            return fileName;
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
            return "unknow.img";
        }
    }

    protected String getImageMapID(IImage image) {
        if (image.getReportRunnable() != null) {
            return image.getReportRunnable().hashCode() + image.getID();
        }
        return image.getID();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getImage(OutputStream out, String imageDir, String imageID) throws EngineException {
        File image = new File(imageDir, imageID);
        if (!image.exists()) {
            throw new EngineException("Error.MissingImageFileError");
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(image);
                byte[] buffer = new byte[1024];
                int size = 0;
                do {
                    if ((size = ((InputStream)in).read(buffer)) <= 0) continue;
                    out.write(buffer, 0, size);
                } while (size > 0);
                ((InputStream)in).close();
            }
            catch (IOException ex) {
                throw new EngineException("Error.Error", ex);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException er) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException er) {}
        if (in == null) return;
        ((InputStream)in).close();
        return;
    }

    static {
        $assertionsDisabled = !HTMLServerImageHandler.class.desiredAssertionStatus();
        count = 0;
        map = new HashMap();
    }
}

