/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.impl.ReportPart;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.util.FileUtil;

public class Image
extends ReportPart
implements IImage {
    protected static Logger logger;
    protected String id = null;
    protected String extension = null;
    protected int source = -1;
    protected byte[] data = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Image(String uri) {
        if (uri == null || uri.length() == 0) {
            return;
        }
        this.id = uri;
        if (!FileUtil.isLocalResource(uri)) {
            this.extension = FileUtil.getExtFromFileName(uri);
            this.source = 2;
            return;
        }
        this.source = 3;
        try {
            new URL(uri);
            this.extension = FileUtil.getExtFromFileName(uri);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.extension = FileUtil.getExtFromFileName(uri);
            return;
        }
    }

    public Image(byte[] data, String name) {
        if (data == null) {
            return;
        }
        this.id = name;
        this.data = data;
        this.source = 4;
    }

    public Image(IImageContent content) {
        String mimeType;
        String imgUri = content.getURI();
        byte[] imgData = content.getData();
        this.extension = content.getExtension();
        if (this.extension == null && (mimeType = content.getMIMEType()) != null) {
            this.extension = FileUtil.getExtFromType(mimeType);
        }
        switch (content.getImageSource()) {
            case 0: {
                if (imgUri == null) break;
                this.id = imgUri;
                this.source = 3;
                break;
            }
            case 1: {
                if (imgData == null) break;
                this.data = imgData;
                this.source = 0;
                this.id = imgUri;
                break;
            }
            case 2: {
                if (imgData == null) break;
                this.data = imgData;
                this.source = 4;
                this.id = content.getInstanceID().toString();
                break;
            }
            case 3: {
                if (imgUri == null) break;
                this.id = imgUri;
                this.source = 2;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public byte[] getImageData() throws OutOfMemoryError {
        return this.data;
    }

    public InputStream getImageStream() {
        switch (this.source) {
            case 3: {
                try {
                    URL url = new URL(this.id);
                    return new BufferedInputStream(url.openStream());
                }
                catch (MalformedURLException e) {
                }
                catch (IOException e1) {
                    // empty catch block
                }
                try {
                    return new BufferedInputStream(new FileInputStream(new File(this.id)));
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    return null;
                }
            }
            case 4: {
                return new ByteArrayInputStream(this.data);
            }
            case 0: {
                return new ByteArrayInputStream(this.data);
            }
            case 2: {
                try {
                    URL url = new URL(this.id);
                    return new BufferedInputStream(url.openStream());
                }
                catch (MalformedURLException e) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            case -1: {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeImage(File dest) throws IOException {
        block22: {
            IOException e222;
            BufferedOutputStream output;
            InputStream input;
            block20: {
                if (this.source == -1) {
                    logger.log(Level.SEVERE, "image source {0} is not valid!", this.id);
                    return;
                }
                input = this.getImageStream();
                if (null == input) {
                    logger.log(Level.SEVERE, "image source {0} is not found!", this.id);
                    return;
                }
                String parent = new File(dest.getAbsolutePath()).getParent();
                File parentDir = new File(parent);
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                output = null;
                output = new BufferedOutputStream(new FileOutputStream(dest));
                this.copyStream(input, output);
                Object var8_6 = null;
                if (input == null) break block20;
                try {
                    input.close();
                }
                catch (IOException e222) {
                    logger.log(Level.SEVERE, e222.getMessage(), e222);
                }
            }
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e222) {
                    logger.log(Level.SEVERE, e222.getMessage(), e222);
                }
            }
            break block22;
            {
                catch (IOException ex) {
                    IOException e222;
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    Object var8_7 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e222) {
                            logger.log(Level.SEVERE, e222.getMessage(), e222);
                        }
                    }
                    if (output != null) {
                        try {
                            ((OutputStream)output).close();
                        }
                        catch (IOException e222) {
                            logger.log(Level.SEVERE, e222.getMessage(), e222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var8_8 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e222) {
                        logger.log(Level.SEVERE, e222.getMessage(), e222);
                    }
                }
                if (output != null) {
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (IOException e222) {
                        logger.log(Level.SEVERE, e222.getMessage(), e222);
                    }
                }
                throw throwable;
            }
        }
    }

    protected void copyStream(InputStream src, OutputStream tgt) throws IOException {
        byte[] buffer = new byte[1024];
        int size = 0;
        do {
            if ((size = src.read(buffer)) <= 0) continue;
            tgt.write(buffer, 0, size);
        } while (size > 0);
    }

    public String getExtension() {
        return this.extension;
    }

    static {
        $assertionsDisabled = !Image.class.desiredAssertionStatus();
        logger = Logger.getLogger(Image.class.getName());
    }
}

