/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ReportEngine
implements IReportEngine {
    protected static Logger logger = Logger.getLogger(ReportEngine.class.getName());
    protected EngineConfig config;
    protected ReportEngineHelper helper;
    protected ScriptableObject rootScope;

    public ReportEngine(EngineConfig config) {
        this.config = config;
        this.helper = new ReportEngineHelper(this);
        this.setupLogging();
        this.setupScriptScope();
    }

    private void setupLogging() {
        String dest;
        if (this.config != null && (dest = this.config.getLogDirectory()) != null) {
            Level level = this.config.getLogLevel();
            if (level == null) {
                level = Level.WARNING;
            }
            this.helper.setupLogging(dest, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupScriptScope() {
        if (this.config != null) {
            Context cx = Context.enter();
            try {
                this.rootScope = cx.initStandardObjects(null, true);
                this.registerBeans(this.rootScope, this.config.getConfigMap());
                this.registerBeans(this.rootScope, this.config.getScriptObjects());
                IStatusHandler handler = this.config.getStatusHandler();
                if (handler != null) {
                    handler.initialize();
                    this.rootScope.put("_statusHandle", (Scriptable)this.rootScope, (Object)handler);
                    cx.evaluateString((Scriptable)this.rootScope, "function writeStatus(msg) { _statusHandle.showStatus(msg); }", "<inline>", 0, null);
                }
            }
            catch (Exception ex) {
                this.rootScope = null;
                logger.log(Level.INFO, "Error occurs while initialze script scope", ex);
            }
            finally {
                Context.exit();
            }
        }
    }

    public Object getRootScope() {
        return this.rootScope;
    }

    private void registerBeans(ScriptableObject scope, Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getKey() == null) continue;
            scope.put(entry.getKey().toString(), (Scriptable)scope, entry.getValue());
        }
    }

    public void changeLogLevel(Level newLevel) {
        if (newLevel != null) {
            this.helper.changeLogLevel(newLevel);
        }
    }

    public EngineConfig getConfig() {
        return this.config;
    }

    public IReportRunnable openReportDesign(String designName) throws EngineException {
        IResourceLocator locator = this.config.getResourceLocator();
        return this.helper.openReportDesign(designName, locator);
    }

    public IReportRunnable openReportDesign(ReportDesignHandle designHandle) throws EngineException {
        return this.helper.openReportDesign(designHandle);
    }

    public IReportRunnable openReportDesign(InputStream designStream) throws EngineException {
        return this.helper.openReportDesign(designStream);
    }

    public IReportRunnable openReportDesign(String name, InputStream designStream) throws EngineException {
        return this.helper.openReportDesign(name, designStream);
    }

    public IRunAndRenderTask createRunAndRenderTask(IReportRunnable reportRunnable) {
        return this.helper.createRunAndRenderTask(reportRunnable);
    }

    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable reportRunnable) {
        return this.helper.createGetParameterDefinitionTask(reportRunnable);
    }

    public String[] getSupportedFormats() {
        return this.helper.getSupportedFormats();
    }

    public String getMIMEType(String format) {
        return this.helper.getMIMEType(format);
    }

    public void destroy() {
        IStatusHandler handler;
        this.helper.stopLogging();
        this.rootScope = null;
        this.helper = null;
        if (this.config != null && (handler = this.config.getStatusHandler()) != null) {
            handler.finish();
        }
    }

    public IRunTask createRunTask(IReportRunnable reportRunnable) {
        return this.helper.createRunTask(reportRunnable);
    }

    public IRenderTask createRenderTask(IReportDocument reportDocument) {
        return this.helper.createRenderTask(reportDocument);
    }

    public IReportDocument openReportDocument(String fileName) throws EngineException {
        return this.helper.openReportDocument(fileName);
    }

    public IDataExtractionTask createDataExtractionTask(IReportDocument reportDocument) {
        return this.helper.createDataExtractionTask(reportDocument);
    }

    public void shutdown() {
    }

    public IReportDocument openReportDocument(String systemId, String fileName) throws EngineException {
        return this.openReportDocument(systemId, fileName, null);
    }

    public IReportRunnable openReportDesign(String designName, IResourceLocator locator) throws EngineException {
        return this.helper.openReportDesign(designName, locator);
    }

    public IReportRunnable openReportDesign(String name, InputStream designStream, IResourceLocator locator) throws EngineException {
        return this.helper.openReportDesign(name, designStream, locator);
    }

    public IReportDocument openReportDocument(String fileName, IResourceLocator locator) throws EngineException {
        return this.openReportDocument(fileName, fileName, locator);
    }

    public IReportDocument openReportDocument(String systemId, String fileName, IResourceLocator locator) throws EngineException {
        return this.helper.openReportDocument(systemId, fileName, locator);
    }
}

