/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractValueManager;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.css.engine.value.URIValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class RawStringManager
extends AbstractValueManager {
    String propertyName;
    boolean inherit;
    Value defaultValue;

    public RawStringManager(String propertyName, boolean inherit, Value defaultValue) {
        this.propertyName = propertyName;
        this.inherit = inherit;
        this.defaultValue = defaultValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isInheritedProperty() {
        return this.inherit;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        return new StringValue(19, lu.getStringValue());
    }

    public Value createStringValue(short type, String value, CSSEngine engine) throws DOMException {
        return new StringValue(19, value);
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        Value pvalue;
        if (value == null) {
            return null;
        }
        if (value.getCssValueType() == 1 && (pvalue = value).getPrimitiveType() == 20) {
            return new URIValue(pvalue.getStringValue(), pvalue.getStringValue());
        }
        return value;
    }
}

