/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.mozilla.javascript.Scriptable;

public class DataPresentationEngine
extends AbstractDataEngine {
    private IDocArchiveReader reader;
    protected HashMap rsetRelations = new HashMap();
    private StringBuffer keyBuffer = new StringBuffer();

    public DataPresentationEngine(ExecutionContext context, IDocArchiveReader reader) {
        super(context);
        try {
            DataEngineContext dteContext = DataEngineContext.newInstance((int)2, (Scriptable)context.getSharedScope(), (IDocArchiveReader)reader, null);
            this.dteEngine = DataEngine.newDataEngine((DataEngineContext)dteContext);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "can't create the DTE data engine", ex);
            ex.printStackTrace();
        }
        this.reader = reader;
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.queryIDMap.putAll(report.getQueryIDs());
        this.loadDteMetaInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDteMetaInfo() {
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream((InputStream)this.reader.getStream("/Data/hierarchy"));
                StringBuffer buffer = new StringBuffer();
                while (true) {
                    String pRsetId = IOUtil.readString((DataInputStream)dis);
                    long rowId = IOUtil.readLong((DataInputStream)dis);
                    String queryId = IOUtil.readString((DataInputStream)dis);
                    String rsetId = IOUtil.readString((DataInputStream)dis);
                    buffer.setLength(0);
                    buffer.append(pRsetId);
                    buffer.append(".");
                    buffer.append(rowId);
                    buffer.append(".");
                    buffer.append(queryId);
                    this.rsetRelations.put(buffer.toString(), rsetId);
                }
            }
            catch (EOFException eofe) {
                Object var9_9 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ex) {}
                }
            }
            catch (IOException ioe) {
                this.context.addException(new EngineException("Can't load the data in report document", ioe));
                logger.log(Level.SEVERE, ioe.getMessage(), ioe);
                Object var9_10 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    protected String getResultID(String pRsetId, long rowId, String queryId) {
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(pRsetId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rowId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        return (String)this.rsetRelations.get(this.keyBuffer.toString());
    }

    protected IResultSet doExecuteQuery(DteResultSet parentResult, IQueryDefinition query) {
        String queryID = (String)this.queryIDMap.get(query);
        try {
            IQueryResults queryResults = null;
            if (parentResult != null) {
                queryResults = parentResult.getQueryResults();
            }
            String resultSetID = null;
            if (queryResults == null) {
                resultSetID = this.getResultID(null, -1L, queryID);
            } else {
                String pRsetId = queryResults.getID();
                long rowid = parentResult.getCurrentPosition();
                resultSetID = this.getResultID(pRsetId, rowid, queryID);
            }
            if (resultSetID == null) {
                logger.log(Level.SEVERE, "Can't load the report query");
                return null;
            }
            queryResults = this.dteEngine.getQueryResults(resultSetID);
            DteResultSet resultSet = null;
            resultSet = parentResult == null ? new DteResultSet(this, this.context, queryResults) : new DteResultSet(parentResult, queryResults);
            return resultSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }
}

