/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemGeneration;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.extension.internal.RowSet;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ExtendedItemExecutor
extends QueryItemExecutor {
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExtendedItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        ExtendedItemDesign extDesign = (ExtendedItemDesign)this.design;
        IForeignContent extContent = this.report.createForeignContent();
        this.setContent(extContent);
        this.executeQuery();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(extDesign, extContent);
        this.processAction(extDesign, extContent);
        this.processBookmark(extDesign, extContent);
        this.processStyle(extDesign, extContent);
        this.processVisibility(extDesign, extContent);
        this.generateContent(extDesign, extContent);
        if (this.context.isInFactory()) {
            this.context.execute(extDesign.getOnCreate());
        }
        this.startTOCEntry(extContent);
        if (this.emitter != null) {
            this.emitter.startForeign(extContent);
        }
        return extContent;
    }

    public void close() {
        this.context.unregisterOnPageBreak(this.content);
        this.finishTOCEntry();
        this.closeQuery();
        this.manager.releaseExecutor(8, this);
    }

    protected void generateContent(ExtendedItemDesign item, IForeignContent content) {
        ExtendedItemHandle handle = (ExtendedItemHandle)item.getHandle();
        String tagName = handle.getExtensionName();
        String name = item.getName();
        IReportItemGeneration itemGeneration = ExtensionManager.getInstance().createGenerationItem(tagName);
        byte[] generationStatus = null;
        if (itemGeneration != null) {
            itemGeneration.setModelObject(handle);
            itemGeneration.setScriptContext(this.context.getReportContext());
            IBaseQueryDefinition[] queries = item.getQueries();
            if (queries == null && item.getQuery() != null) {
                queries = new IBaseQueryDefinition[]{item.getQuery()};
            }
            itemGeneration.setReportQueries(queries);
            IRowSet[] rowSets = this.executeQueries(item);
            try {
                if (rowSets != null) {
                    itemGeneration.onRowSets(rowSets);
                }
                if (itemGeneration.needSerialization()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    itemGeneration.serialize(out);
                    generationStatus = out.toByteArray();
                }
                itemGeneration.finish();
            }
            catch (BirtException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.context.addException(new EngineException("Error.ExtendedItemGenerationError", handle.getExtensionName() + (name != null ? " " + name : ""), (Throwable)ex));
            }
            this.closeQueries(rowSets);
        }
        content.setRawType("object/external");
        content.setRawValue(generationStatus);
    }

    protected static byte[] readContent(InputStream in) {
        BufferedInputStream bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int readSize = 0;
        try {
            readSize = bin.read(buffer);
            while (readSize != -1) {
                out.write(buffer, 0, readSize);
                readSize = bin.read(buffer);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return out.toByteArray();
    }

    protected IRowSet[] executeQueries(ReportItemDesign item) {
        if (!$assertionsDisabled && !(item instanceof ExtendedItemDesign)) {
            throw new AssertionError();
        }
        ExtendedItemDesign extItem = (ExtendedItemDesign)item;
        IDataEngine dataEngine = this.context.getDataEngine();
        IResultSet parent = this.getParentResultSet();
        IRowSet[] rowSets = null;
        IBaseQueryDefinition[] queries = extItem.getQueries();
        if (queries != null) {
            rowSets = new IRowSet[queries.length];
            for (int i = 0; i < rowSets.length; ++i) {
                IResultSet rset = dataEngine.execute(parent, queries[i]);
                rowSets[i] = rset != null ? new RowSet(rset) : null;
            }
        }
        if (rowSets == null && this.rset != null) {
            rowSets = new IRowSet[]{new RowSet(this.rset, true)};
        }
        return rowSets;
    }

    protected void closeQueries(IRowSet[] rowSets) {
        if (rowSets != null) {
            for (int i = 0; i < rowSets.length; ++i) {
                if (rowSets[i] == null) continue;
                rowSets[i].close();
            }
        }
    }

    static {
        $assertionsDisabled = !ExtendedItemExecutor.class.desiredAssertionStatus();
        logger = Logger.getLogger(ExtendedItemExecutor.class.getName());
    }
}

