/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.script.internal.LabelScriptExecutor;

public class LabelItemExecutor
extends QueryItemExecutor {
    public LabelItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        LabelItemDesign labelDesign = (LabelItemDesign)this.getDesign();
        ILabelContent labelContent = this.report.createLabelContent();
        this.setContent(labelContent);
        this.executeQuery();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(labelDesign, labelContent);
        this.processAction(labelDesign, labelContent);
        this.processBookmark(labelDesign, labelContent);
        this.processStyle(labelDesign, labelContent);
        this.processVisibility(labelDesign, labelContent);
        if (this.context.isInFactory()) {
            LabelScriptExecutor.handleOnCreate(labelContent, this.context);
        }
        this.startTOCEntry(labelContent);
        if (this.emitter != null) {
            this.emitter.startLabel(labelContent);
        }
        return labelContent;
    }

    public void close() {
        this.context.unregisterOnPageBreak(this.content);
        this.finishTOCEntry();
        this.closeQuery();
        this.manager.releaseExecutor(2, this);
    }
}

