/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class ListBandExecutor
extends StyledItemExecutor {
    int currentItem;

    protected ListBandExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        ListBandDesign bandDesign = (ListBandDesign)this.getDesign();
        IListBandContent bandContent = this.report.createListBandContent();
        this.setContent(bandContent);
        this.restoreResultSet();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(bandDesign, bandContent);
        this.startTOCEntry(bandContent);
        if (this.emitter != null) {
            this.emitter.startListBand(bandContent);
        }
        this.currentItem = 0;
        return bandContent;
    }

    public void close() {
        IListBandContent bandContent = (IListBandContent)this.getContent();
        if (this.emitter != null) {
            this.emitter.endListBand(bandContent);
        }
        this.context.unregisterOnPageBreak(this.content);
        this.finishTOCEntry();
        this.manager.releaseExecutor(11, this);
    }

    public boolean hasNextChild() {
        ListBandDesign bandDesign = (ListBandDesign)this.design;
        return this.currentItem < bandDesign.getContentCount();
    }

    public IReportItemExecutor getNextChild() {
        ListBandDesign bandDesign = (ListBandDesign)this.design;
        if (this.currentItem < bandDesign.getContentCount()) {
            ReportItemDesign itemDesign = bandDesign.getContent(this.currentItem++);
            ReportItemExecutor executor = this.manager.createExecutor(this, itemDesign);
            return executor;
        }
        return null;
    }
}

