/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ListingElementExecutor;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.script.internal.ListScriptExecutor;

public class ListItemExecutor
extends ListingElementExecutor {
    protected ListItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        ListItemDesign listDesign = (ListItemDesign)this.getDesign();
        IListContent listContent = this.report.createListContent();
        this.setContent(listContent);
        this.executeQuery();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(listDesign, listContent);
        this.processAction(listDesign, listContent);
        this.processBookmark(listDesign, listContent);
        this.processStyle(listDesign, listContent);
        this.processVisibility(listDesign, listContent);
        if (this.context.isInFactory()) {
            ListScriptExecutor.handleOnCreate(listContent, this.context);
        }
        this.startTOCEntry(listContent);
        if (this.emitter != null) {
            this.emitter.startList(listContent);
        }
        this.prepareToExecuteChildren();
        return listContent;
    }

    public void close() {
        IListContent listContent = (IListContent)this.getContent();
        if (this.emitter != null) {
            this.emitter.endList(listContent);
        }
        this.context.unregisterOnPageBreak(this.content);
        this.finishTOCEntry();
        this.closeQuery();
    }
}

