/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v3;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.AutoTextContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ListBandContent;
import org.eclipse.birt.report.engine.content.impl.ListContent;
import org.eclipse.birt.report.engine.content.impl.ListGroupContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableBandContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.content.impl.TableGroupContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;

public class ReportContentReaderV3 {
    protected static Logger logger = Logger.getLogger(ReportContentReaderV3.class.getName());
    protected ReportContent reportContent;
    protected RAInputStream stream;
    protected long offset;

    public ReportContentReaderV3(ReportContent reportContent, RAInputStream stream) {
        this.reportContent = reportContent;
        this.stream = stream;
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to close the reader", ex);
            }
            this.stream = null;
        }
    }

    protected IContent readObject(long offset) throws IOException {
        this.stream.seek(offset);
        int size = this.stream.readInt();
        byte[] buffer = new byte[size];
        this.stream.readFully(buffer, 0, size);
        DataInputStream oi = new DataInputStream(new ByteArrayInputStream(buffer));
        AbstractContent object = null;
        int contentType = IOUtil.readInt((InputStream)oi);
        switch (contentType) {
            case 1: {
                CellContent cellContent = new CellContent(this.reportContent);
                cellContent.readContent(oi);
                object = cellContent;
                break;
            }
            case 2: {
                ContainerContent containerContent = new ContainerContent(this.reportContent);
                containerContent.readContent(oi);
                object = containerContent;
                break;
            }
            case 3: {
                DataContent dataContent = new DataContent(this.reportContent);
                dataContent.readContent(oi);
                object = dataContent;
                break;
            }
            case 4: {
                ForeignContent foreignContent = new ForeignContent(this.reportContent);
                foreignContent.readContent(oi);
                object = foreignContent;
                break;
            }
            case 5: {
                ImageContent imageContent = new ImageContent(this.reportContent);
                imageContent.readContent(oi);
                object = imageContent;
                break;
            }
            case 6: {
                LabelContent labelContent = new LabelContent(this.reportContent);
                labelContent.readContent(oi);
                object = labelContent;
                break;
            }
            case 7: {
                PageContent pageContent = new PageContent(this.reportContent);
                pageContent.readContent(oi);
                object = pageContent;
                break;
            }
            case 8: {
                RowContent rowContent = new RowContent(this.reportContent);
                rowContent.readContent(oi);
                object = rowContent;
                break;
            }
            case 9: {
                TableBandContent tableBandContent = new TableBandContent(this.reportContent);
                tableBandContent.readContent(oi);
                object = tableBandContent;
                break;
            }
            case 10: {
                TableContent tableContent = new TableContent(this.reportContent);
                tableContent.readContent(oi);
                object = tableContent;
                break;
            }
            case 11: {
                TextContent textContent = new TextContent(this.reportContent);
                textContent.readContent(oi);
                object = textContent;
                break;
            }
            case 12: {
                AutoTextContent autoText = new AutoTextContent(this.reportContent);
                autoText.readContent(oi);
                object = autoText;
                break;
            }
            case 13: {
                ListContent list = new ListContent(this.reportContent);
                list.readContent(oi);
                object = list;
                break;
            }
            case 14: {
                ListBandContent listBand = new ListBandContent(this.reportContent);
                listBand.readContent(oi);
                object = listBand;
                break;
            }
            case 16: {
                ListGroupContent listGroup = new ListGroupContent(this.reportContent);
                listGroup.readContent(oi);
                object = listGroup;
                break;
            }
            case 17: {
                TableGroupContent tableGroup = new TableGroupContent(this.reportContent);
                tableGroup.readContent(oi);
                object = tableGroup;
            }
        }
        return object;
    }

    public IContent readContent() throws IOException {
        long index = this.offset;
        IContent content = this.readContent(index);
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt.getFirstChild() != -1L) {
            this.offset = docExt.getFirstChild();
            return content;
        }
        if (docExt.getNext() != -1L) {
            this.offset = docExt.getNext();
            return content;
        }
        docExt = this.readDocumentExtension(docExt.getParent());
        while (docExt != null) {
            if (docExt.getNext() != -1L) {
                this.offset = docExt.getNext();
                return content;
            }
            docExt = this.readDocumentExtension(docExt.getParent());
        }
        this.offset = -1L;
        return content;
    }

    public IContent readContent(long index) throws IOException {
        if (index >= this.stream.length() || index < 0L) {
            return null;
        }
        DocumentExtension docExt = this.readDocumentExtension(index);
        IContent content = this.readObject(index + 40L);
        if (content != null) {
            content.setExtension(0, docExt);
        }
        return content;
    }

    private DocumentExtension readDocumentExtension(long index) throws IOException {
        if (index >= this.stream.length() || index < 0L) {
            return null;
        }
        this.stream.seek(index);
        index = this.stream.readLong();
        long parent = this.stream.readLong();
        long previous = this.stream.readLong();
        long next = this.stream.readLong();
        long child = this.stream.readLong();
        DocumentExtension docExt = new DocumentExtension(index);
        docExt.setParent(parent);
        docExt.setPrevious(previous);
        docExt.setNext(next);
        docExt.setFirstChild(child);
        return docExt;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

