/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.AbstractReportReader;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportItemReader;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;

public class ReportReader
extends AbstractReportReader {
    IReportExecutor executor = null;
    protected long offset;

    public ReportReader(ExecutionContext context) {
        super(context);
    }

    public IReportContent execute() {
        try {
            this.openReaders();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Fail to open the readers", ex);
            this.closeReaders();
        }
        return this.reportContent;
    }

    public void close() {
        this.closeReaders();
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ReportItemReader childReader = this.manager.createExecutor(null, this.offset);
            this.offset = childReader.findNextSibling();
            return childReader;
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.offset != -1L;
    }

    public IPageContent createPage(long pageNumber, MasterPageDesign pageDesign) {
        if (this.executor == null) {
            this.executor = new ReportExecutor(this.context, this.context.getReport().getReportDesign(), null);
            this.executor = new LocalizedReportExecutor(this.context, this.executor);
        }
        return this.executor.createPage(pageNumber, pageDesign);
    }
}

