/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.presentation;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportDocumentInfo;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.presentation.TransientReportDocument;

public class ReportDocumentInfo
implements IReportDocumentInfo {
    protected ExecutionContext context;
    protected long pageNumber;
    protected boolean finished;
    protected Map params = new HashMap();
    protected Map beans = new HashMap();
    protected List errors;

    public ReportDocumentInfo(ExecutionContext context, long pageNumber, boolean finished) {
        this.context = context;
        this.pageNumber = pageNumber;
        this.finished = finished;
        this.params.putAll(context.getParams());
        this.beans.putAll(context.getGlobalBeans());
        this.errors = context.getErrors();
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public boolean isFinsihed() {
        return this.finished;
    }

    public IReportDocument openReportDocument() throws BirtException {
        char lastChar;
        IReportEngine engine = this.context.getEngine();
        String documentName = this.context.getReportDocWriter().getName();
        if (new File(documentName).isDirectory() && (lastChar = documentName.charAt(documentName.length() - 1)) != '\\' && lastChar != '/' && lastChar != File.separatorChar) {
            documentName = documentName + File.separatorChar;
        }
        IReportDocument document = engine.openReportDocument(documentName);
        return new TransientReportDocument(document, this.pageNumber, this.params, this.beans);
    }

    public List getErrors() {
        return this.errors;
    }
}

